/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.omegat.CLIParameters;
import org.omegat.convert.ConvertConfigs;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.core.matching.external.lucene.LuceneWriter;
import org.omegat.core.matching.external.rmi.Server;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.filehooks.XliffFileHook;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.scripting.IScriptLogger;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXWriter;
import org.omegat.util.gui.OSXIntegration;

public class Main {
    protected static final Pattern PARAM = Pattern.compile("\\-\\-([A-Za-z\\-]+)(=(.+))?");
    protected static File projectLocation = null;
    protected static final Map<String, String> params = new TreeMap<String, String>();
    protected static CLIParameters.RUN_MODE runMode = CLIParameters.RUN_MODE.GUI;

    public static void main(String[] args) {
        int result;
        String configDir;
        if (args.length > 0 && ("-h".equals(args[0]) || "--help".equals(args[0]))) {
            if (args.length > 1) {
                System.out.println(CLIParameters.help(args[1]));
            } else {
                System.out.println(CLIParameters.help(null));
            }
            System.exit(0);
        }
        for (String arg : args) {
            Matcher m = PARAM.matcher(arg = StringUtil.normalizeUnicode(arg));
            if (m.matches()) {
                params.put(m.group(1), m.group(3));
                continue;
            }
            if (arg.startsWith("resource-bundle=")) {
                params.put("resource-bundle", arg.substring("resource-bundle".length()));
                continue;
            }
            File f = new File(arg);
            if (f.getName().equals("omegat.project")) {
                f = f.getParentFile();
            }
            if (!StaticUtils.isProjectDir(f)) continue;
            projectLocation = f;
        }
        Main.applyConfigFile(params.get("config-file"));
        runMode = CLIParameters.RUN_MODE.parse(params.get("mode"));
        String resourceBundle = params.get("resource-bundle");
        if (resourceBundle != null) {
            OStrings.loadBundle(resourceBundle);
        }
        if ((configDir = params.get("config-dir")) != null) {
            if (configDir.contains("{")) {
                if (!configDir.contains("$")) {
                    configDir = configDir.replace("{", "${");
                }
                configDir = FileUtil.interpolated(configDir);
                Log.log("Config directory set to " + configDir);
            }
            RuntimePreferences.setConfigDir(configDir);
        }
        if (params.containsKey("quiet")) {
            RuntimePreferences.setQuietMode(true);
        }
        if (params.containsKey("disable-project-locking")) {
            RuntimePreferences.setProjectLockingEnabled(false);
        }
        if (params.containsKey("disable-location-save")) {
            RuntimePreferences.setLocationSaveEnabled(false);
        }
        Log.log("\n===================================================================\n" + OStrings.getNameAndVersion() + " " + Main.getBuildDate() + "\n\tLocale " + Locale.getDefault() + " Date " + new Date());
        Log.logRB("LOG_STARTUP_INFO", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.home"));
        System.setProperty("http.user", OStrings.getDisplayNameAndVersion());
        ConvertConfigs.convert();
        PluginUtils.loadPlugins(params);
        if (params.containsKey("server-port")) {
            try {
                LocateRegistry.createRegistry(Integer.parseInt(params.get("server-port")));
                System.err.println("Listening server " + params.get("server-port"));
            }
            catch (Exception rmi1) {
                rmi1.printStackTrace();
            }
        }
        if (params.containsKey("server-object")) {
            try {
                String object = params.get("server-object");
                if (!object.startsWith("rmi:")) {
                    object = "rmi://" + InetAddress.getLocalHost().getHostAddress() + "/" + object;
                }
                System.err.println("Listening server object " + params.get("server.object"));
                Naming.rebind(object, new Server());
            }
            catch (Exception rmi2) {
                rmi2.printStackTrace();
            }
        }
        try {
            switch (runMode) {
                case GUI: {
                    result = Main.runGUI();
                    break;
                }
                case CONSOLE_TRANSLATE: {
                    result = Main.runConsoleTranslate();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_CREATEPSEUDOTRANSLATETMX: {
                    result = Main.runCreatePseudoTranslateTMX();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_ALIGN: {
                    result = Main.runConsoleAlign();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_INDEX_MEMORY: {
                    result = Main.runConsoleIndexMemory();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_EXTRACT_XLIFF: {
                    result = Main.runConsoleExtractXliff();
                    PluginUtils.unloadPlugins();
                    break;
                }
                default: {
                    result = 1;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
            result = 1;
        }
        if (result != 0) {
            System.exit(result);
        }
    }

    private static String getBuildDate() {
        try {
            JarURLConnection j = (JarURLConnection)ClassLoader.getSystemResource("org/omegat/Version.properties").openConnection();
            return " (" + new Date(j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime()) + ")";
        }
        catch (Exception e) {
            return "";
        }
    }

    private static void applyConfigFile(String path) {
        if (path == null) {
            return;
        }
        File configFile = new File(path);
        if (!configFile.exists()) {
            return;
        }
        System.out.println("Reading config from " + path);
        try {
            PropertyResourceBundle config = new PropertyResourceBundle(new FileInputStream(configFile));
            for (String key : config.keySet()) {
                String value = config.getString(key);
                System.setProperty(key, value);
                params.put(key, value);
                System.out.println("Read from config: " + key + "=" + value);
            }
            if (config.containsKey("user.language")) {
                String userLanguage = config.getString("user.language");
                Locale userLocale = config.containsKey("user.country") ? new Locale(userLanguage, config.getString("user.country")) : new Locale(userLanguage);
                Locale.setDefault(userLocale);
            }
        }
        catch (FileNotFoundException exception) {
            System.err.println("Config file not found: " + path);
        }
        catch (IOException exception) {
            System.err.println("Error while reading config file: " + path);
        }
    }

    protected static int runGUI() {
        if (Platform.isMacOSX()) {
            OSXIntegration.init();
        }
        Log.log("Docking Framework version: " + DockingDesktop.getDockingFrameworkVersion());
        Log.log("");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> cls = toolkit.getClass();
        try {
            if (cls.getName().equals("sun.awt.X11.XToolkit")) {
                Field field = cls.getDeclaredField("awtAppClassName");
                field.setAccessible(true);
                field.set(toolkit, "OmegaT");
            }
        }
        catch (Exception field) {
            // empty catch block
        }
        try {
            UIManager.getInstalledLookAndFeels();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("swing.aatext", "true");
        }
        catch (Exception e) {
            Log.logErrorRB("MAIN_ERROR_CANT_INIT_OSLF", new Object[0]);
        }
        try {
            Core.initializeGUI(params);
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
            return 1;
        }
        if (!Core.getPluginsLoadingErrors().isEmpty()) {
            String err = "";
            for (int i = 0; i < Core.getPluginsLoadingErrors().size(); ++i) {
                err = err + "\n" + Core.getPluginsLoadingErrors().get(i);
            }
            err = err.substring(1);
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), err, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
        }
        CoreEvents.fireApplicationStartup();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Core.getMainWindow().getApplicationFrame().setVisible(true);
                if (projectLocation != null) {
                    ProjectUICommands.projectOpen(projectLocation);
                }
            }
        });
        return 0;
    }

    protected static int runConsoleTranslate() throws Exception {
        Log.log("Console translation mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(params);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(OStrings.getString("CONSOLE_TRANSLATING"));
        String sourceMask = params.get("source-pattern");
        if (sourceMask != null) {
            p.compileProject(sourceMask, false);
        } else {
            p.compileProject(".*", false);
        }
        Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE);
        p.closeProject();
        Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE);
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    private static void validateTagsConsoleMode() {
        CLIParameters.TAG_VALIDATION_MODE mode = CLIParameters.TAG_VALIDATION_MODE.parse(params.get("tag-validation"));
        switch (mode) {
            case ABORT: {
                System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
                List<ErrorReport> stes = Core.getTagValidation().listInvalidTags();
                if (stes == null) break;
                Core.getTagValidation().displayTagValidationErrors(stes, null);
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_ABORT"));
                System.exit(1);
                break;
            }
            case WARN: {
                System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
                List<ErrorReport> stes = Core.getTagValidation().listInvalidTags();
                if (stes == null) break;
                Core.getTagValidation().displayTagValidationErrors(stes, null);
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
                break;
            }
        }
    }

    protected static int runCreatePseudoTranslateTMX() throws Exception {
        Log.log("Console pseudo-translate mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(params);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(OStrings.getString("CONSOLE_CREATE_PSEUDOTMX"));
        ProjectProperties m_config = p.getProjectProperties();
        List<SourceTextEntry> entries = p.getAllEntries();
        String pseudoTranslateTMXFilename = params.get("pseudotranslatetmx");
        String fname = !StringUtil.isEmpty(pseudoTranslateTMXFilename) ? (!pseudoTranslateTMXFilename.endsWith(".tmx") ? pseudoTranslateTMXFilename + "." + ".tmx" : pseudoTranslateTMXFilename) : "";
        IMachineTranslation translator = null;
        String pseudoTranslateType = params.get("pseudotranslatetype");
        pseudoTranslateType = Character.toTitleCase(pseudoTranslateType.charAt(0)) + pseudoTranslateType.substring(1).toLowerCase();
        try {
            Class<?> cls = Class.forName("org.omegat.core.machinetranslators." + pseudoTranslateType + "Translate");
            translator = (IMachineTranslation)cls.newInstance();
        }
        catch (ClassNotFoundException cnf1) {
            try {
                Class<?> cls = Class.forName("org.omegat.core.machinetranslators.dummy." + pseudoTranslateType + "Translate");
                translator = (IMachineTranslation)cls.newInstance();
            }
            catch (ClassNotFoundException cnf2) {
                try {
                    Class<?> cls = Class.forName("org.omegat.core.machinetranslators.net." + pseudoTranslateType + "Translate");
                    translator = (IMachineTranslation)cls.newInstance();
                }
                catch (ClassNotFoundException cnf3) {
                    Log.log("No such translation class");
                    System.exit(1);
                }
            }
        }
        try {
            BaseTranslate t = (BaseTranslate)translator;
            t.enable();
        }
        catch (ClassCastException t) {
            // empty catch block
        }
        HashMap<String, PrepareTMXEntry> data = new HashMap<String, PrepareTMXEntry>();
        for (SourceTextEntry ste : entries) {
            PrepareTMXEntry entry = new PrepareTMXEntry();
            entry.source = ste.getSrcText();
            entry.translation = translator.getTranslation(m_config.getSourceLanguage(), m_config.getTargetLanguage(), entry.source);
            data.put(ste.getSrcText(), entry);
        }
        try {
            TMXWriter.buildTMXFile(fname, false, false, m_config, data);
        }
        catch (IOException e) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
            Log.log(e);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
        }
        p.closeProject();
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    public static int runConsoleAlign() throws Exception {
        Log.log("Console alignment mode");
        Log.log("");
        if (projectLocation == null) {
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            return 1;
        }
        String dir = params.get("alignDir");
        if (dir == null) {
            System.out.println(OStrings.getString("CONSOLE_TRANSLATED_FILES_LOC_UNDEFINED"));
            return 1;
        }
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(params);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(StringUtil.format(OStrings.getString("CONSOLE_ALIGN_AGAINST"), dir));
        Map<String, TMXEntry> data = p.align(p.getProjectProperties(), new File(dir));
        TreeMap<String, PrepareTMXEntry> result = new TreeMap<String, PrepareTMXEntry>();
        for (Map.Entry<String, TMXEntry> en : data.entrySet()) {
            result.put(en.getKey(), new PrepareTMXEntry(en.getValue()));
        }
        String tmxFile = p.getProjectProperties().getProjectInternal() + "align.tmx";
        TMXWriter.buildTMXFile(tmxFile, false, false, p.getProjectProperties(), result);
        p.closeProject();
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    protected static int runConsoleIndexMemory() throws Exception {
        Object tmRoot;
        boolean isSentenceSegmentingEnabled;
        Language targetLanguage;
        Language sourceLanguage;
        ArrayList<File> saveDirs;
        ArrayList<File> targetDirs;
        List<File> sourceFiles;
        Log.log("Console index memory");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(params);
        String tmxPath = params.get("source");
        if (tmxPath != null) {
            String targetPath = params.get("target");
            String sourceLang = params.get("source-lang");
            String targetLang = params.get("target-lang");
            File tmxFile = new File(tmxPath);
            File targetDir = new File(targetPath);
            if (!tmxFile.exists()) {
                Log.log("File " + tmxPath + " not found. Exit");
                return 1;
            }
            if (targetDir.exists()) {
                if (!targetDir.isDirectory()) {
                    Log.log("Target path " + targetPath + " is not a directory. Exit.");
                    return 1;
                }
            } else {
                if (sourceLang == null) {
                    Log.log("Missing parameter source-lang");
                    return 1;
                }
                if (targetLang == null) {
                    Log.log("Missing parameter target-lang");
                    return 1;
                }
            }
            sourceFiles = new ArrayList<File>(1);
            sourceFiles.add(tmxFile);
            targetDirs = new ArrayList(1);
            targetDirs.add(targetDir);
            saveDirs = null;
            sourceLanguage = new Language(sourceLang);
            targetLanguage = new Language(targetLang);
            isSentenceSegmentingEnabled = params.get("source-segmenting-enabled") != null;
        } else {
            String idxRoot;
            if (projectLocation == null) {
                System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
                return 1;
            }
            RealProject p = Main.selectProjectConsoleMode(false);
            sourceFiles = FileUtil.findFiles(new File(p.getProjectProperties().getTMRoot()), f -> f.getName().endsWith(".tmx"));
            targetDirs = new ArrayList<File>(sourceFiles.size());
            saveDirs = new ArrayList<File>(sourceFiles.size());
            String projRoot = p.getProjectProperties().getProjectRoot();
            tmRoot = p.getProjectProperties().getTMRoot();
            if (!((String)tmRoot).endsWith(File.separator)) {
                tmRoot = (String)tmRoot + File.separator;
            }
            if (!(idxRoot = projRoot).endsWith(File.separator)) {
                idxRoot = idxRoot + File.separator;
            }
            idxRoot = idxRoot + "tm-indexes";
            new File(idxRoot).mkdirs();
            for (File sourceFile : sourceFiles) {
                targetDirs.add(new File(idxRoot + File.separator + sourceFile.getPath().substring(((String)tmRoot).length()) + ".ottm"));
                if (params.get("save-to") != null) {
                    saveDirs.add(new File(params.get("save-to") + sourceFile.getPath().substring(((String)tmRoot).length())));
                    continue;
                }
                if (!params.containsKey("save-files")) continue;
                saveDirs.add(new File(projRoot + File.separator + "tm-saved" + File.separator + sourceFile.getPath().substring(((String)tmRoot).length())));
            }
            sourceLanguage = p.getProjectProperties().getSourceLanguage();
            targetLanguage = p.getProjectProperties().getTargetLanguage();
            isSentenceSegmentingEnabled = p.getProjectProperties().isSentenceSegmentingEnabled();
        }
        for (int i = 0; i < targetDirs.size(); ++i) {
            try {
                FileOutputStream propFile = new FileOutputStream(sourceFiles.get(i) + ".properties");
                tmRoot = null;
                try {
                    PrintWriter pOut = new PrintWriter(propFile);
                    Object object = null;
                    try {
                        pOut.println("class=org.omegat.core.matching.external.lucene.LuceneReader");
                        StringBuffer targetBuf = new StringBuffer();
                        char[] targetChars = ((File)targetDirs.get(i)).toString().toCharArray();
                        for (int j = 0; j < targetChars.length; ++j) {
                            if (targetChars[j] == '\\') {
                                targetBuf.append("\\\\");
                                continue;
                            }
                            if (targetChars[j] > '\u0080') {
                                targetBuf.append("\\u").append(String.format("%04x", targetChars[j]));
                                continue;
                            }
                            targetBuf.append(targetChars[j]);
                        }
                        pOut.println("dir=" + targetBuf);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (pOut != null) {
                            if (object != null) {
                                try {
                                    pOut.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                pOut.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    tmRoot = throwable;
                    throw throwable;
                }
                finally {
                    if (propFile != null) {
                        if (tmRoot != null) {
                            try {
                                propFile.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)tmRoot).addSuppressed(throwable);
                            }
                        } else {
                            propFile.close();
                        }
                    }
                }
                ((File)targetDirs.get(i)).mkdir();
                LuceneWriter writer = new LuceneWriter((File)targetDirs.get(i), true);
                ExternalTMX tmx = new ExternalTMX(isSentenceSegmentingEnabled, sourceLanguage, targetLanguage, sourceFiles.get(i), Preferences.isPreference("ext_tmx_show_level2"), Preferences.isPreference("ext_tmx_use_slash"));
                writer.indexAll((Collection<PrepareTMXEntry>)tmx.getEntries());
                writer.close();
                if (tmxPath != null) continue;
                if (saveDirs.size() > i && saveDirs.get(i) != null) {
                    ((File)saveDirs.get(i)).getParentFile().mkdirs();
                    sourceFiles.get(i).renameTo((File)saveDirs.get(i));
                    continue;
                }
                sourceFiles.get(i).delete();
                continue;
            }
            catch (Exception e) {
                Log.log(e);
                return 1;
            }
        }
        return 0;
    }

    protected static int runConsoleExtractXliff() throws Exception {
        List<Object> extractedFiles;
        List<File> sourceFiles;
        Log.log("Console extract XLIFF");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(params);
        if (projectLocation != null) {
            RealProject p = Main.selectProjectConsoleMode(false);
            sourceFiles = FileUtil.findFiles(new File(p.getProjectProperties().getSourceRoot()), f -> f.getName().endsWith(".sdlxliff"));
            extractedFiles = new ArrayList<File>(sourceFiles.size());
            for (File f2 : sourceFiles) {
                extractedFiles.add(new File(f2.getParentFile().getParentFile(), "source-native" + File.separator + f2.getName().substring(0, f2.getName().lastIndexOf("."))));
            }
        } else {
            File source = new File(params.get("source"));
            if (source.getName().endsWith(".sdlxliff")) {
                sourceFiles = Collections.singletonList(source);
                String target = params.get("target");
                extractedFiles = target != null ? Collections.singletonList(new File(target, source.getName().substring(0, source.getName().lastIndexOf(".")))) : Collections.singletonList(new File(source.getCanonicalPath().substring(0, source.getCanonicalPath().lastIndexOf("."))));
            } else if (source.isDirectory()) {
                sourceFiles = FileUtil.findFiles(source, f -> f.getName().endsWith(".sdlxliff"));
                extractedFiles = new ArrayList(sourceFiles.size());
                for (File f2 : sourceFiles) {
                    extractedFiles.add(new File(f2.getCanonicalPath().substring(0, f2.getCanonicalPath().lastIndexOf("."))));
                }
            } else {
                throw new Exception("Wrong parameters: cannot see which files to convert");
            }
        }
        for (int i = 0; i < sourceFiles.size(); ++i) {
            try {
                System.out.println("Extracting " + sourceFiles.get(i) + " to " + extractedFiles.get(i));
                if (!((File)extractedFiles.get(i)).getParentFile().exists()) {
                    ((File)extractedFiles.get(i)).getParentFile().mkdirs();
                }
                XliffFileHook.extractBase64(sourceFiles.get(i), ((File)extractedFiles.get(i)).getCanonicalPath());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private static RealProject selectProjectConsoleMode(boolean loadProject) {
        System.out.println(OStrings.getString("CONSOLE_LOADING_PROJECT"));
        ProjectProperties projectProperties = null;
        try {
            projectProperties = ProjectFileStorage.loadProjectProperties(projectLocation);
            projectProperties.verifyProject();
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            System.exit(1);
        }
        RealProject p = new RealProject(projectProperties);
        Core.setProject(p);
        if (loadProject) {
            p.loadProject(true);
            if (!p.isProjectLoaded()) {
                Core.setProject(new NotLoadedProject());
            } else {
                Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD);
            }
        }
        return p;
    }

    private static void executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        File script;
        if (params.containsKey("script") && (script = new File(params.get("script").toString())).isFile()) {
            HashMap<String, Object> binding = new HashMap<String, Object>();
            binding.put("eventType", (Object)eventType);
            binding.put("console", new IScriptLogger(){

                @Override
                public void print(Object o) {
                    System.out.print(o);
                }

                @Override
                public void println(Object o) {
                    System.out.println(o);
                }

                @Override
                public void clear() {
                }
            });
            try {
                String result = ScriptRunner.executeScript(new ScriptItem(script), binding);
                Log.log(result);
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public static void showError(Throwable ex) {
        String msg = StringUtil.isEmpty(ex.getMessage()) ? ex.getClass().getName() : ex.getMessage();
        switch (runMode) {
            case GUI: {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), msg, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
                break;
            }
            default: {
                System.err.println(MessageFormat.format(OStrings.getString("CONSOLE_ERROR"), msg));
            }
        }
    }
}

