/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.search.ExternalSearchResultEntry;
import org.omegat.core.search.GlossarySearchResultEntry;
import org.omegat.core.search.ISearchable;
import org.omegat.core.search.InternalSearchResultEntry;
import org.omegat.core.search.OngoingSearchResultEntry;
import org.omegat.core.search.ProjectSearcher;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.core.search.VarMatch;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.search.ProjectSearchWindow;
import org.omegat.util.Language;
import org.omegat.util.OStrings;

public class FullProjectSearcher
extends ProjectSearcher {
    public static final int SEARCH_SCOPE_ORPHANS = 2;
    public static final int SEARCH_SCOPE_TM = 4;
    public static final int SEARCH_SCOPE_GLOSSARIES = 8;
    private final String m_searchFile;

    public FullProjectSearcher(ProjectSearchWindow window, IProject project, boolean removeDup, int numberOfResults, TranslationStateFilter translationStateFilter, int searchLocation, String searchFile, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, boolean andThenSearch, TextExpression author, TextExpression translator, long dateAfter, long dateBefore) {
        super(window, project, removeDup, numberOfResults, translationStateFilter, searchLocation, searchSource, searchTarget, searchNotes, andSearch, author, translator, dateAfter, dateBefore);
        this.m_translationStateFilter = translationStateFilter;
        this.m_searchLocation = searchLocation;
        this.m_andSearch = andSearch;
        this.m_searchFile = searchFile;
        if (andThenSearch) {
            if (searchSource != null && !searchSource.hasVariables()) {
                this.m_searchSource = searchSource.asVariableKeeper();
                this.m_searchTarget = searchTarget;
                this.m_searchNotes = searchNotes;
            } else if (searchTarget != null && !searchTarget.hasVariables()) {
                this.m_searchTarget = searchTarget.asVariableKeeper();
                this.m_searchSource = searchSource;
                this.m_searchNotes = searchNotes;
            } else if (searchNotes != null && !searchNotes.hasVariables()) {
                this.m_searchNotes = searchNotes.asVariableKeeper();
                this.m_searchSource = searchSource;
                this.m_searchTarget = searchTarget;
            } else {
                this.m_searchSource = searchSource;
                this.m_searchTarget = searchTarget;
                this.m_searchNotes = searchNotes;
            }
        } else {
            this.m_searchSource = searchSource;
            this.m_searchTarget = searchTarget;
            this.m_searchNotes = searchNotes;
        }
        this.m_sourceTranslationStateFilter = (searchLocation & 1) > 0 ? TranslationStateFilter.TRANSLATED_ONLY : this.getTranslationStateFilter();
    }

    @Override
    protected void doSearch() {
        super.doSearch();
        if ((this.m_searchLocation & 3) != 0) {
            String file = OStrings.getString("CT_ORPHAN_STRINGS");
            this.m_window.displayProgress("ORPHAN", 1, 2, this.m_numFinds);
            this.m_project.iterateByDefaultTranslations((source, en) -> {
                if (this.m_numFinds >= this.m_maxResults) {
                    return;
                }
                this.checkInterrupted();
                if (this.m_project.isOrphaned(source)) {
                    this.testInternalEntry(file, en);
                }
            });
            this.m_window.displayProgress("ORPHAN", 2, 2, this.m_numFinds);
            this.m_project.iterateByMultipleTranslations((source, en) -> {
                if (this.m_numFinds >= this.m_maxResults) {
                    return;
                }
                this.checkInterrupted();
                if (this.m_project.isOrphaned(source)) {
                    this.testInternalEntry(file, en);
                }
            });
        }
        if ((this.m_searchLocation & 4) != 0) {
            int count = this.m_project.getTransMemories().entrySet().size();
            int progress = 0;
            for (Map.Entry<String, IExternalMemory> entry : this.m_project.getTransMemories().entrySet()) {
                String fileTM = entry.getKey();
                this.m_window.displayProgress("TM", progress++, count, this.m_numFinds);
                try {
                    ISearchable mem = (ISearchable)((Object)entry.getValue());
                    if (!this.searchEntries(this.searchInProvider(mem), fileTM)) {
                        return;
                    }
                }
                catch (ClassCastException mem) {
                }
                catch (Exception otherException) {
                    otherException.printStackTrace();
                }
                this.checkInterrupted();
            }
            count = this.m_project.getOtherTargetLanguageTMs().entrySet().size();
            progress = 0;
            for (Map.Entry entry : this.m_project.getOtherTargetLanguageTMs().entrySet()) {
                Language langTM = (Language)entry.getKey();
                this.m_window.displayProgress("OTHER_LANG", progress++, count, this.m_numFinds);
                if (!this.searchEntriesAlternative(((ProjectTMX)entry.getValue()).getDefaults(), langTM.getLanguage())) {
                    return;
                }
                if (!this.searchEntriesAlternative(((ProjectTMX)entry.getValue()).getAlternatives(), langTM.getLanguage())) {
                    return;
                }
                this.checkInterrupted();
            }
            this.checkInterrupted();
        }
        if ((this.m_searchLocation & 8) != 0) {
            if (this.m_author != null || this.m_dateAfter < Long.MAX_VALUE || this.m_dateBefore > Long.MIN_VALUE) {
                return;
            }
            String intro = OStrings.getString("SW_GLOSSARY_RESULT");
            List<GlossaryEntry> entries = Core.getGlossaryManager().search("");
            for (GlossaryEntry glossaryEntry : entries) {
                this.testGlossary(glossaryEntry);
                if (this.m_numFinds >= this.m_maxResults) {
                    return;
                }
                this.checkInterrupted();
            }
        }
    }

    private boolean searchEntries(Iterable<PrepareTMXEntry> tmEn, String tmxID) {
        for (PrepareTMXEntry tm : tmEn) {
            if (this.m_numFinds >= this.m_maxResults) {
                return false;
            }
            this.testTM(tmxID, tm);
            this.checkInterrupted();
        }
        return true;
    }

    private boolean searchEntriesAlternative(Iterable<TMXEntry> tmEn, String tmxID) {
        for (TMXEntry tm : tmEn) {
            if (this.m_numFinds >= this.m_maxResults) {
                return false;
            }
            this.testInternalEntry(tmxID, tm);
            this.checkInterrupted();
        }
        return true;
    }

    private SearchResultEntry checkMatchesOrdered(TextExpression expr1, String text1, TextExpression expr2, String text2, TextExpression expr3, String text3, int id, EntryBuilder eBuilder) {
        LinkedList<SearchMatch> toRemove;
        List<SearchMatch> matchesA = (expr1 = expr1.asVariableKeeper()).searchString(text1);
        if (matchesA == null) {
            return null;
        }
        LinkedList<SearchMatch> matchesB = new LinkedList<SearchMatch>();
        LinkedList<SearchMatch> matchesC = new LinkedList<SearchMatch>();
        if (expr2 != null) {
            if (text2 == null) {
                return null;
            }
            toRemove = new LinkedList<SearchMatch>();
            for (SearchMatch m : matchesA) {
                List<SearchMatch> matches2 = expr2.rebuildForVariables(((VarMatch)m).groups).searchString(text2);
                if (matches2 == null) {
                    toRemove.add(m);
                    continue;
                }
                matchesB.addAll(matches2);
            }
            matchesA.removeAll(toRemove);
            toRemove.clear();
        }
        if (expr3 != null) {
            if (text3 == null) {
                return null;
            }
            toRemove = new LinkedList();
            for (SearchMatch m : matchesA) {
                List<SearchMatch> matches3 = expr3.rebuildForVariables(((VarMatch)m).groups).searchString(text3);
                if (matches3 == null) {
                    toRemove.add(m);
                    continue;
                }
                matchesC.addAll(matches3);
            }
            matchesA.removeAll(toRemove);
            toRemove.clear();
        }
        if (matchesA.size() > 0) {
            switch (id) {
                case 1: {
                    return eBuilder.buildEntry(matchesA, matchesB, matchesC);
                }
                case 2: {
                    return eBuilder.buildEntry(matchesB, matchesA, matchesC);
                }
                case 3: {
                    return eBuilder.buildEntry(matchesB, matchesC, matchesA);
                }
            }
        }
        return null;
    }

    protected SearchResultEntry checkMatchesFields(String srcText, String traText, String noteText, EntryBuilder eBuilder) {
        List<SearchMatch> srcMatches = null;
        List<SearchMatch> targetMatches = null;
        List<SearchMatch> noteMatches = null;
        if (this.m_searchSource != null && this.m_searchSource.isVariableKeeper()) {
            return this.checkMatchesOrdered(this.m_searchSource, srcText, this.m_searchTarget, traText, this.m_searchNotes, noteText, 1, eBuilder);
        }
        if (this.m_searchTarget != null && this.m_searchTarget.isVariableKeeper()) {
            return this.checkMatchesOrdered(this.m_searchTarget, traText, this.m_searchSource, srcText, this.m_searchNotes, noteText, 2, eBuilder);
        }
        if (this.m_searchNotes != null && this.m_searchNotes.isVariableKeeper()) {
            return this.checkMatchesOrdered(this.m_searchNotes, noteText, this.m_searchSource, srcText, this.m_searchTarget, traText, 3, eBuilder);
        }
        if (!this.m_andSearch) {
            if (this.m_searchSource != null) {
                srcMatches = this.m_searchSource.searchString(srcText);
            }
            if (this.m_searchTarget != null && traText != null) {
                targetMatches = this.m_searchTarget.searchString(traText);
            }
            if (this.m_searchNotes != null && noteText != null) {
                noteMatches = this.m_searchNotes.searchString(noteText);
            }
            if (srcMatches != null || targetMatches != null || noteMatches != null) {
                return eBuilder.buildEntry(srcMatches, targetMatches, noteMatches);
            }
            return null;
        }
        if (this.m_searchSource != null && (srcMatches = this.m_searchSource.searchString(srcText)) == null) {
            return null;
        }
        if (this.m_searchTarget != null && traText != null && (targetMatches = this.m_searchTarget.searchString(traText)) == null) {
            return null;
        }
        if (this.m_searchNotes != null && noteText != null && (noteMatches = this.m_searchNotes.searchString(noteText)) == null) {
            return null;
        }
        return eBuilder.buildEntry(srcMatches, targetMatches, noteMatches);
    }

    private void testTM(String fileName, PrepareTMXEntry entry) {
        if (!this.m_translationStateFilter.isValidEntry(entry)) {
            return;
        }
        if (this.m_searchFile != null && this.m_searchFile.trim().length() > 0 && !fileName.contains(this.m_searchFile)) {
            return;
        }
        if (!this.checkFilters(entry)) {
            return;
        }
        SearchResultEntry res = this.checkMatchesFields(entry.source, entry.translation, entry.note, (srcMatches, targetMatches, noteMatches) -> new ExternalSearchResultEntry(fileName, entry, srcMatches, targetMatches, noteMatches));
        if (res != null) {
            this.addEntry(res);
        }
    }

    private void testInternalEntry(String fileName, TMXEntry entry) {
        if (!this.m_translationStateFilter.isValidEntry(entry)) {
            return;
        }
        if (!this.checkFilters(entry)) {
            return;
        }
        SearchResultEntry res = this.checkMatchesFields(entry.source, entry.translation, entry.note, (srcMatches, targetMatches, noteMatches) -> new InternalSearchResultEntry(fileName, entry, srcMatches, targetMatches, noteMatches));
        if (res != null) {
            this.addEntry(res);
        }
    }

    @Override
    protected void testSource(SourceTextEntry ste) {
        if (this.m_searchFile != null && this.m_searchFile.trim().length() > 0 && !ste.getKey().file.contains(this.m_searchFile)) {
            return;
        }
        super.testSource(ste);
    }

    @Override
    public OngoingSearchResultEntry testOngoing(SourceTextEntry ste, boolean add) {
        TMXEntry tmxEntry = this.m_project.getTranslationInfo(ste);
        if (!this.getTranslationStateFilter().isValidEntry(tmxEntry)) {
            return null;
        }
        if (!this.checkFilters(tmxEntry)) {
            return null;
        }
        if (this.m_searchFile != null && this.m_searchFile.trim().length() > 0 && !ste.getKey().file.contains(this.m_searchFile)) {
            return null;
        }
        OngoingSearchResultEntry res = (OngoingSearchResultEntry)this.checkMatchesFields(ste.getSrcText(), tmxEntry.translation, tmxEntry.note, (srcMatches, targetMatches, noteMatches) -> new OngoingSearchResultEntry(ste, tmxEntry, srcMatches, targetMatches, noteMatches));
        if (add && res != null) {
            this.addEntry(res);
        }
        return res;
    }

    private void testGlossary(GlossaryEntry entry) {
        if (!this.m_translationStateFilter.isValidEntry(entry)) {
            return;
        }
        SearchResultEntry res = this.checkMatchesFields(entry.getSrcText(), entry.getLocText(), entry.getCommentText(), (srcMatches, targetMatches, noteMatches) -> new GlossarySearchResultEntry(entry, srcMatches, targetMatches, noteMatches));
        if (res != null) {
            this.addEntry(res);
        }
    }

    protected static interface EntryBuilder {
        public SearchResultEntry buildEntry(List<SearchMatch> var1, List<SearchMatch> var2, List<SearchMatch> var3);
    }
}

