/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.util.TMXProp;

public class InternalSearchResultEntry
extends SearchResultEntry {
    private String m_fileName;
    private TMXEntry m_entry;

    public InternalSearchResultEntry(String fileName, TMXEntry entry, List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        super(srcMatch, targetMatch, noteMatch);
        this.m_entry = entry;
        this.m_fileName = fileName;
    }

    @Override
    public int getEntryNum() {
        return -1;
    }

    @Override
    public String getPreamble() {
        return "TM:" + this.getShortPathName() + this.getMoreString() + ">";
    }

    public String getShortPathName() {
        String root = Core.getProject().getProjectProperties().getTMRoot();
        if (this.m_fileName.startsWith(root)) {
            return this.m_fileName.substring(root.length());
        }
        return this.m_fileName;
    }

    @Override
    public String getSrcText() {
        return this.m_entry.source;
    }

    @Override
    public String getTranslation() {
        return this.m_entry.translation;
    }

    @Override
    public String getNote() {
        return this.m_entry.note;
    }

    @Override
    public String getFileName() {
        return this.m_fileName;
    }

    @Override
    public String getAuthor() {
        return this.m_entry.creator;
    }

    @Override
    public Date getDate() {
        return new Date(Math.max(this.m_entry.creationDate, this.m_entry.changeDate));
    }

    @Override
    public List<TMXProp> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public String getRevisor() {
        return this.m_entry.revisor;
    }
}

