/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.search.ReplaceMatch;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.VarMatch;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;

public interface TextExpression {
    public List<SearchMatch> searchString(String var1);

    public boolean matchesString(String var1);

    public TextExpression asVariableKeeper();

    default public boolean isVariableKeeper() {
        return false;
    }

    public TextExpression rebuildForVariables(String[] var1);

    public boolean hasVariables();

    public static class ExactReplaceTokenExpression
    extends ExactTokenExpression {
        private String replacement;

        public ExactReplaceTokenExpression(ITokenizer tokenizer, ITokenizer.StemmingMode stemming_mode, String text, String replacement, boolean caseSensitive) {
            super(tokenizer, stemming_mode, text, caseSensitive);
            this.replacement = replacement;
        }

        @Override
        protected SearchMatch buildMatch(String text, Token[] textTokens, int length, int i) {
            String replaced = this.replacement;
            replaced = replaced.replaceAll("(?<!\\\\)\\$0", text.substring(textTokens[i].getOffset(), textTokens[i].getOffset() + length));
            for (int j = 0; j < this.phrase.length; ++j) {
                replaced = replaced.replaceAll("(?<!\\\\)\\$" + (j + 1), text.substring(textTokens[i + j].getOffset(), textTokens[i + j].getOffset() + textTokens[i + j].getLength()));
            }
            return new ReplaceMatch(textTokens[i].getOffset(), textTokens[i].getOffset() + length, replaced);
        }
    }

    public static class WordsTokenExpression
    implements TextExpression {
        private ITokenizer tokenizer;
        private ITokenizer.StemmingMode stemming_mode;
        private Set<Token> phrase;
        private String original;
        private boolean caseSensitive;

        public WordsTokenExpression(ITokenizer tokenizer, ITokenizer.StemmingMode stemming_mode, String text, boolean caseSensitive) {
            this.tokenizer = tokenizer;
            this.stemming_mode = stemming_mode;
            this.original = text;
            this.caseSensitive = caseSensitive;
            Token[] cut = tokenizer.tokenizeWords(text, stemming_mode);
            this.phrase = new HashSet<Token>();
            for (Token current : cut) {
                this.phrase.add(current);
            }
        }

        public ExactTokenExpression[] split() {
            Token[] cut = this.tokenizer.tokenizeWords(this.original, ITokenizer.StemmingMode.NONE);
            ExactTokenExpression[] res = new ExactTokenExpression[cut.length];
            for (int i = 0; i < cut.length; ++i) {
                res[i] = new ExactTokenExpression(this.tokenizer, this.stemming_mode, cut[i].getTextFromString(this.original), this.caseSensitive);
            }
            return res;
        }

        private Token findToken(Token[] textTokenArray, Token current, String text) {
            for (Token textToken : textTokenArray) {
                if (!textToken.equals(current) || this.caseSensitive && !textToken.getTextFromString(text).contains(current.getTextFromString(this.original))) continue;
                return textToken;
            }
            return null;
        }

        @Override
        public List<SearchMatch> searchString(String text) {
            Token[] textTokenArray = this.tokenizer.tokenizeWords(text, this.stemming_mode);
            ArrayList<SearchMatch> foundMatches = new ArrayList<SearchMatch>();
            for (Token current : this.phrase) {
                Token foundToken = this.findToken(textTokenArray, current, text);
                if (foundToken == null) {
                    return null;
                }
                foundMatches.add(new SearchMatch(foundToken.getOffset(), foundToken.getOffset() + foundToken.getLength()));
            }
            return foundMatches.size() > 0 ? foundMatches : null;
        }

        @Override
        public boolean matchesString(String text) {
            Token[] textTokenArray = this.tokenizer.tokenizeWords(text, this.stemming_mode);
            for (Token current : this.phrase) {
                if (this.findToken(textTokenArray, current, text) != null) continue;
                return false;
            }
            return this.phrase != null && this.phrase.size() > 0;
        }

        @Override
        public TextExpression asVariableKeeper() {
            return this;
        }

        @Override
        public TextExpression rebuildForVariables(String[] vars) {
            StringBuffer expression = new StringBuffer();
            Matcher m = Pattern.compile("(?<!\\\\)\\$(\\d+)").matcher(this.original);
            while (m.find()) {
                m.appendReplacement(expression, vars[Integer.parseInt(m.group(1))]);
            }
            m.appendTail(expression);
            return new WordsTokenExpression(this.tokenizer, this.stemming_mode, expression.toString(), this.caseSensitive);
        }

        @Override
        public boolean hasVariables() {
            return this.original.contains("$");
        }
    }

    public static class ExactTokenExpression
    implements TextExpression {
        protected ITokenizer tokenizer;
        protected Token[] phrase;
        private ITokenizer.StemmingMode stemming_mode;
        private String original;
        private boolean caseSensitive;

        public ExactTokenExpression(ITokenizer tokenizer, ITokenizer.StemmingMode stemming_mode, String text, boolean caseSensitive) {
            this.tokenizer = tokenizer;
            this.stemming_mode = stemming_mode;
            this.original = text;
            this.caseSensitive = caseSensitive;
            this.phrase = tokenizer.tokenizeWords(text, stemming_mode);
        }

        public String getOriginalExpression() {
            return this.original;
        }

        @Override
        public List<SearchMatch> searchString(String text) {
            if (this.phrase.length == 0) {
                return null;
            }
            Token[] textTokens = this.tokenizer.tokenizeWords(text, this.stemming_mode);
            ArrayList<SearchMatch> foundMatches = new ArrayList<SearchMatch>();
            block0: for (int i = 0; i < textTokens.length; ++i) {
                if (!textTokens[i].equals(this.phrase[0]) || this.caseSensitive && !textTokens[i].getTextFromString(text).contains(this.phrase[0].getTextFromString(this.original))) continue;
                for (int j = 1; j < this.phrase.length; ++j) {
                    if (i + j >= textTokens.length || !this.phrase[j].equals(textTokens[i + j]) || this.caseSensitive && !textTokens[i + j].getTextFromString(text).contains(this.phrase[j].getTextFromString(this.original))) continue block0;
                }
                Token last = textTokens[i + this.phrase.length - 1];
                int length = last.getLength() + last.getOffset() - textTokens[i].getOffset();
                foundMatches.add(this.buildMatch(text, textTokens, length, i));
            }
            return foundMatches.size() > 0 ? foundMatches : null;
        }

        protected SearchMatch buildMatch(String text, Token[] textTokens, int length, int i) {
            return new SearchMatch(textTokens[i].getOffset(), textTokens[i].getOffset() + length);
        }

        @Override
        public boolean matchesString(String text) {
            if (this.phrase.length == 0) {
                return false;
            }
            Token[] textTokens = this.tokenizer.tokenizeWords(text, this.stemming_mode);
            block0: for (int i = 0; i < textTokens.length; ++i) {
                if (!textTokens[i].equals(this.phrase[0])) continue;
                for (int j = 1; j < this.phrase.length; ++j) {
                    if (i + j >= textTokens.length || !this.phrase[j].equals(textTokens[i + j])) continue block0;
                }
                return true;
            }
            return false;
        }

        @Override
        public TextExpression asVariableKeeper() {
            return this;
        }

        @Override
        public TextExpression rebuildForVariables(String[] vars) {
            StringBuffer expression = new StringBuffer();
            Matcher m = Pattern.compile("(?<!\\\\)\\$(\\d+)").matcher(this.original);
            while (m.find()) {
                m.appendReplacement(expression, vars[Integer.parseInt(m.group(1))]);
            }
            m.appendTail(expression);
            return new ExactTokenExpression(this.tokenizer, this.stemming_mode, expression.toString(), this.caseSensitive);
        }

        @Override
        public boolean hasVariables() {
            return this.original.contains("$");
        }
    }

    public static class WordsTextExpression
    implements TextExpression {
        private RegexTextExpression[] theExpressions;

        public WordsTextExpression(String expression, boolean caseSensitive, boolean wholeWords) {
            String[] words = expression.split(" ");
            this.theExpressions = new RegexTextExpression[words.length];
            for (int i = 0; i < words.length; ++i) {
                this.theExpressions[i] = wholeWords ? RegexTextExpression.exactWholeWordsExpression(words[i], caseSensitive) : RegexTextExpression.exactStringExpression(words[i], caseSensitive);
            }
        }

        @Override
        public boolean matchesString(String text) {
            for (RegexTextExpression expression : this.theExpressions) {
                if (expression.matchesString(text)) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<SearchMatch> searchString(String text) {
            ArrayList<SearchMatch> foundMatches = new ArrayList<SearchMatch>(this.theExpressions.length);
            for (RegexTextExpression expression : this.theExpressions) {
                List<SearchMatch> matches = expression.searchString(text);
                if (matches == null) {
                    return null;
                }
                foundMatches.addAll(matches);
            }
            return foundMatches.size() > 0 ? foundMatches : null;
        }

        public RegexTextExpression[] split() {
            return this.theExpressions;
        }

        private WordsTextExpression(RegexTextExpression[] theExpressions) {
            this.theExpressions = theExpressions;
        }

        @Override
        public TextExpression asVariableKeeper() {
            RegexTextExpression[] res = new RegexTextExpression[this.theExpressions.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = this.theExpressions[i].asVariableKeeper();
            }
            return new WordsTextExpression(res);
        }

        @Override
        public TextExpression rebuildForVariables(String[] vars) {
            RegexTextExpression[] res = new RegexTextExpression[this.theExpressions.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (RegexTextExpression)this.theExpressions[i].rebuildForVariables(vars);
            }
            return new WordsTextExpression(res);
        }

        @Override
        public boolean hasVariables() {
            for (RegexTextExpression re : this.theExpressions) {
                if (!re.hasVariables()) continue;
                return true;
            }
            return false;
        }
    }

    public static class RegexReplaceExpression
    extends RegexTextExpression {
        private String replacement;

        public RegexReplaceExpression(String expression, boolean caseSensitive, String replacement) {
            super(expression, caseSensitive);
            this.replacement = replacement;
        }

        @Override
        protected SearchMatch buildSearchMatch(Matcher matcher) {
            String repl = this.replacement;
            Matcher replaceMatcher = Pattern.compile("(?<!\\\\)((?:\\\\\\\\)*)\\$(\\d+)").matcher(repl);
            while (replaceMatcher.find()) {
                int varId = Integer.parseInt(replaceMatcher.group(2));
                repl = repl.substring(0, replaceMatcher.start()) + replaceMatcher.group(1) + matcher.group(varId).replace("\\", "\\\\").replace("$", "\\$") + repl.substring(replaceMatcher.end());
                replaceMatcher.reset(repl);
            }
            if (!(repl = StringUtil.replaceCase(repl, Core.getProject().getProjectProperties().getTargetLanguage().getLocale())).equals(this.replacement)) {
                return new ReplaceMatch(matcher.start(), matcher.end(), repl);
            }
            return new SearchMatch(matcher.start(), matcher.end());
        }

        public static RegexReplaceExpression exactStringExpression(String expression, boolean caseSensitive, String replacement) {
            expression = StaticUtils.escapeNonRegex(expression, "S");
            expression = expression.replaceAll("\\S+", "($0)");
            return new RegexReplaceExpression(expression, caseSensitive, replacement);
        }

        public static RegexTextExpression exactWholeWordsExpression(String expression, boolean caseSensitive, String replacement) {
            expression = StaticUtils.escapeNonRegex(expression, "p{L}");
            expression = expression.replaceAll("(\\b|\\\\p\\{L\\}\\*?)(?<![\\\\\\{\\}])\\p{L}(\\p{L}|\\\\p\\{L\\}\\*?)*(\\\\p\\{L\\}\\*?|\\b)", "\\\\b($0)\\\\b");
            return new RegexReplaceExpression(expression, caseSensitive, replacement);
        }
    }

    public static class RegexTextExpression
    implements TextExpression {
        private Pattern thePattern;
        protected static final String REGEX_WORD_WITH_JOKERS = "(\\b|\\\\p\\{L\\}\\*?)(?<![\\\\\\{\\}])\\p{L}(\\p{L}|\\\\p\\{L\\}\\*?)*(\\\\p\\{L\\}\\*?|\\b)";

        public RegexTextExpression(String expression, boolean caseSensitive) {
            int flags = caseSensitive ? 0 : 66;
            expression = expression.replaceAll("(?<!\\\\)\\$(\\d+)", "%$1");
            this.thePattern = Pattern.compile(expression, flags += 256);
        }

        public Pattern getPattern() {
            return this.thePattern;
        }

        @Override
        public boolean matchesString(String text) {
            return this.thePattern.matcher(text).find();
        }

        @Override
        public List<SearchMatch> searchString(String text) {
            ArrayList<SearchMatch> foundMatches = new ArrayList<SearchMatch>();
            Matcher matcher = this.thePattern.matcher(text);
            while (matcher.find()) {
                foundMatches.add(this.buildSearchMatch(matcher));
            }
            return foundMatches.size() > 0 ? foundMatches : null;
        }

        protected SearchMatch buildSearchMatch(Matcher matcher) {
            return new SearchMatch(matcher.start(), matcher.end());
        }

        protected String getReplacement() {
            return null;
        }

        private RegexTextExpression(Pattern ptn) {
            this.thePattern = ptn;
        }

        @Override
        public RegexTextExpression asVariableKeeper() {
            return new RegexTextExpression(this.thePattern){

                @Override
                protected VarMatch buildSearchMatch(Matcher matcher) {
                    return new VarMatch(matcher);
                }

                @Override
                public RegexTextExpression asVariableKeeper() {
                    return this;
                }

                @Override
                public boolean isVariableKeeper() {
                    return true;
                }
            };
        }

        @Override
        public TextExpression rebuildForVariables(String[] vars) {
            if (!this.thePattern.toString().contains("%")) {
                return this;
            }
            StringBuffer expression = new StringBuffer();
            Matcher m = Pattern.compile("(?<!\\\\)\\%(\\d+)").matcher(this.thePattern.toString());
            while (m.find()) {
                String val = vars[Integer.parseInt(m.group(1))];
                val = StaticUtils.escapeNonRegex(val, null);
                val = StaticUtils.escapeNonRegex(val, null);
                m.appendReplacement(expression, val);
            }
            m.appendTail(expression);
            return new RegexTextExpression(expression.toString(), (this.thePattern.flags() & 2) == 0);
        }

        @Override
        public boolean hasVariables() {
            return Pattern.compile("(?<!\\\\)\\%(\\d+)").matcher(this.thePattern.toString()).find();
        }

        public String toString() {
            return "RE:" + this.thePattern.toString();
        }

        public static RegexTextExpression exactStringExpression(String expression, boolean caseSensitive) {
            return new RegexTextExpression(StaticUtils.escapeNonRegex(expression, "S"), caseSensitive);
        }

        public static RegexTextExpression exactWholeWordsExpression(String expression, boolean caseSensitive) {
            expression = StaticUtils.escapeNonRegex(expression, "p{L}");
            expression = expression.replaceAll(REGEX_WORD_WITH_JOKERS, "\\\\b$0\\\\b");
            return new RegexTextExpression(expression, caseSensitive);
        }
    }

    public static class NotExpression
    implements TextExpression {
        private TextExpression base;

        public NotExpression(TextExpression base) {
            this.base = base;
        }

        public TextExpression getBaseExpression() {
            return this.base;
        }

        @Override
        public List<SearchMatch> searchString(String text) {
            if (this.base.matchesString(text)) {
                return null;
            }
            return Collections.emptyList();
        }

        @Override
        public boolean matchesString(String text) {
            return !this.base.matchesString(text);
        }

        @Override
        public TextExpression asVariableKeeper() {
            return this;
        }

        @Override
        public TextExpression rebuildForVariables(String[] vars) {
            return new NotExpression(this.base.rebuildForVariables(vars));
        }

        @Override
        public boolean hasVariables() {
            return this.base.hasVariables();
        }
    }

    public static class FilterTextExpression
    implements TextExpression {
        private Function<String, String> filter;
        private TextExpression originalExpression;
        private BiFunction<String, String, Boolean> keepMatching;

        public FilterTextExpression(Function<String, String> filter, BiFunction<String, String, Boolean> keepMatching, TextExpression originalExpression) {
            this.filter = filter;
            this.originalExpression = originalExpression;
            this.keepMatching = keepMatching;
        }

        @Override
        public List<SearchMatch> searchString(String text) {
            String filterText = this.filter.apply(text);
            if (this.keepMatching.apply(text, filterText).booleanValue()) {
                return this.originalExpression.searchString(filterText);
            }
            if (this.originalExpression.matchesString(filterText)) {
                return Collections.emptyList();
            }
            return null;
        }

        @Override
        public boolean matchesString(String text) {
            return this.originalExpression.matchesString(this.filter.apply(text));
        }

        @Override
        public TextExpression asVariableKeeper() {
            return new FilterTextExpression(this.filter, this.keepMatching, this.originalExpression.asVariableKeeper());
        }

        @Override
        public boolean isVariableKeeper() {
            return this.originalExpression.isVariableKeeper();
        }

        @Override
        public TextExpression rebuildForVariables(String[] vars) {
            if (!this.originalExpression.hasVariables()) {
                return this;
            }
            return new FilterTextExpression(this.filter, this.keepMatching, this.originalExpression.rebuildForVariables(vars));
        }

        @Override
        public boolean hasVariables() {
            return this.originalExpression.hasVariables();
        }
    }
}

