/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.omegat.core.spellchecker.DictionaryFileNameFilter;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

public class DictionaryManager {
    private final File[] dirs;

    public DictionaryManager(String dirName) {
        String[] split = dirName.split(",");
        this.dirs = new File[split.length];
        for (int i = 0; i < split.length; ++i) {
            this.dirs[i] = new File(split[i]);
        }
    }

    public String getDirectory() {
        return this.dirs[0].getAbsolutePath();
    }

    private String getFileNameOnly(String filename) {
        int position = filename.indexOf(".");
        if (position != -1) {
            return filename.substring(0, position);
        }
        return null;
    }

    public List<String> getDictionaryNameList(List<String> aList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String dic : aList) {
            String[] parts = dic.split("_");
            Locale locale = parts.length == 1 ? new Locale(parts[0]) : new Locale(parts[0], parts[1]);
            result.add(dic + " - " + locale.getDisplayName());
        }
        return result;
    }

    public List<String> getLocalDictionaryNameList() {
        return this.getDictionaryNameList(this.getLocalDictionaryCodeList());
    }

    public List<String> getLocalDictionaryCodeList() {
        ArrayList<String> result = new ArrayList<String>();
        for (File dir : this.dirs) {
            this.getLocalDictionaryCodeList(result, dir);
        }
        return result;
    }

    private void getLocalDictionaryCodeList(List<String> result, File dir) {
        String[] affixFiles = dir.list(new DictionaryFileNameFilter(".aff"));
        String[] dictionaryFiles = dir.list(new DictionaryFileNameFilter(".dic"));
        if (affixFiles != null && dictionaryFiles != null) {
            for (String affixFile : affixFiles) {
                boolean match = false;
                String affixName = this.getFileNameOnly(affixFile);
                if (affixName == null || affixName.isEmpty()) continue;
                for (String dictionaryFile : dictionaryFiles) {
                    String dicName = this.getFileNameOnly(dictionaryFile);
                    if (dicName == null || dicName.isEmpty() || !affixName.equals(dicName)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                result.add(affixName);
            }
        }
    }

    public boolean uninstallDictionary(String lang) {
        if (lang == null || lang.isEmpty()) {
            return false;
        }
        for (int i = this.dirs.length - 1; i >= 0; --i) {
            String base = this.dirs[i] + File.separator + lang;
            File affFile = new File(base + ".aff");
            File dicFile = new File(base + ".dic");
            if (!dicFile.delete() || !affFile.delete()) continue;
            return true;
        }
        return false;
    }

    public List<String> getInstallableDictionaryNameList() throws IOException {
        return this.getDictionaryNameList(this.getInstallableDictionaryCodeList());
    }

    public List<String> getInstallableDictionaryCodeList() throws IOException {
        List<String> localDicList = this.getLocalDictionaryCodeList();
        List<String> remoteDicList = this.getRemoteDictionaryCodeList();
        ArrayList<String> result = new ArrayList<String>();
        for (String dicCode : remoteDicList) {
            if (localDicList.contains(dicCode)) continue;
            result.add(dicCode);
        }
        return result;
    }

    private List<String> getRemoteDictionaryCodeList() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String htmlfile = StaticUtils.downloadFileToString(Preferences.getPreference("dictionary_url"));
        Matcher matcher = PatternConsts.DICTIONARY_ZIP.matcher(htmlfile);
        while (matcher.find()) {
            String match = matcher.group();
            int dotPosition = match.indexOf(".");
            result.add(match.substring(1, dotPosition));
        }
        return result;
    }

    public void installRemoteDictionary(String langCode) throws MalformedURLException, IOException {
        String from = Preferences.getPreference("dictionary_url") + "/" + langCode + ".zip";
        File tempFile = File.createTempFile(langCode, ".zip");
        StaticUtils.downloadFileToDisk(from, tempFile.getAbsolutePath());
        int pos = langCode.indexOf("_1-3-2", 0);
        if (pos != -1) {
            langCode = langCode.substring(0, pos);
        }
        try {
            this.dirs[this.dirs.length - 1].mkdirs();
            StaticUtils.extractFileFromJar(tempFile, Arrays.asList(langCode + ".aff", langCode + ".dic"), this.dirs[this.dirs.length - 1].getAbsolutePath());
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(OStrings.getString("GUI_SPELLCHECKER_ERROR_ON_INSTALL"), ex);
        }
    }
}

