/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IFastMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;

public class SpellCheckerMarker
implements IFastMarker {
    protected static final Highlighter.HighlightPainter PAINTER = new UnderlineFactory.WaveUnderline(Styles.EditorColor.COLOR_SPELLCHECK.getColor());

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        if (translationText == null) {
            return null;
        }
        if (!Core.getEditor().getSettings().isAutoSpellChecking()) {
            return null;
        }
        return SpellCheckerMarker.check(translationText, 0, translationText.length());
    }

    private static List<Mark> check(String translationText, int checkStart, int checkEnd) throws Exception {
        ArrayList<Mark> result = new ArrayList<Mark>();
        for (Token tok : Core.getProject().getTargetTokenizer().tokenizeWords(translationText, ITokenizer.StemmingMode.NONE)) {
            int tokStart = tok.getOffset();
            int tokEnd = tok.getOffset() + tok.getLength();
            if (tokStart > checkEnd || tokEnd < checkStart) continue;
            String word = tok.getTextFromString(translationText);
            if (Core.getSpellChecker().isCorrect(word)) continue;
            Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, tokStart, tokEnd);
            m.painter = PAINTER;
            result.add(m);
        }
        return result;
    }

    @Override
    public List<MarkerController.MarkInfo> toRemove(DocumentEvent ev, List<MarkerController.MarkInfo> oriList) {
        if (!Core.getEditor().getSettings().isAutoSpellChecking()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MarkerController.MarkInfo> res = new ArrayList<MarkerController.MarkInfo>(1 + ev.getLength() / 5);
        for (MarkerController.MarkInfo ori : oriList) {
            if (ori.highlight == null || ori.highlight.getEndOffset() < ev.getOffset() || ev.getType() == DocumentEvent.EventType.INSERT && ori.highlight.getStartOffset() > ev.getOffset() + ev.getLength() || ev.getType() == DocumentEvent.EventType.REMOVE && ori.highlight.getStartOffset() > ev.getOffset()) continue;
            res.add(ori);
        }
        return res;
    }

    @Override
    public List<Mark> toAdd(DocumentEvent ev) throws Exception {
        if (!Core.getEditor().getSettings().isAutoSpellChecking()) {
            return Collections.EMPTY_LIST;
        }
        Document3 doc = (Document3)ev.getDocument();
        String translationText = doc.getText(doc.getTranslationStart(), doc.getTranslationEnd() - doc.getTranslationStart());
        return SpellCheckerMarker.check(translationText, ev.getOffset() - doc.getTranslationStart(), ev.getOffset() + ev.getLength() - doc.getTranslationStart());
    }
}

