/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filehooks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.filehooks.IFileHook;
import org.omegat.filehooks.XliffFileHook;
import org.omegat.util.Log;
import org.omegat.util.Preferences;

public class RenumXliffHook
implements IFileHook {
    public static final String SOURCE_TRADOS_DIR = "source-trados";
    public static final String COMPILED_TRADOS_DIR = "target-trados";
    private Exception lastCompileException = null;

    @Override
    public String getNativeSourceFile(String currentFile) {
        currentFile = currentFile.replace("/", File.separator);
        ProjectProperties otProj = Core.getProject().getProjectProperties();
        try {
            File handler = new File(currentFile);
            handler = new File(handler.getParentFile().getParentFile(), SOURCE_TRADOS_DIR);
            handler = new File(handler, currentFile.substring(otProj.getSourceRoot().length()).replace(".renum.xlf", ".sdlxliff"));
            if (handler.exists()) {
                return XLIFF_HOOK.getNativeSourceFile(handler.getCanonicalPath(), otProj.getProjectRoot() + SOURCE_TRADOS_DIR + File.separator);
            }
            String nativeFile = currentFile.substring(0, currentFile.lastIndexOf(46));
            handler = new File(nativeFile = nativeFile.substring(0, nativeFile.lastIndexOf(46)));
            if (handler.exists()) {
                return nativeFile;
            }
            if ((handler = new File(new File(handler.getParentFile().getParentFile(), "original"), nativeFile)).exists()) {
                return handler.getCanonicalPath();
            }
            if ((handler = new File(new File(handler.getParentFile().getParentFile(), "source-native"), nativeFile)).exists()) {
                return handler.getCanonicalPath();
            }
            return XliffFileHook.readOriginalFileName(currentFile).getCanonicalPath();
        }
        catch (Exception e) {
            return currentFile;
        }
    }

    @Override
    public Exception lastCompileException() {
        return this.lastCompileException;
    }

    @Override
    public String getNativeTargetFile(String currentFile) {
        return XLIFF_HOOK.getNativeTargetFile(currentFile);
    }

    @Override
    public void postCompile(File destDir, String midName) {
        String extraScripts = Preferences.getPreferenceDefault("scripts_dir", System.getenv("OMEGAT_HOME") + File.separator + "scripts") + File.separator + "extra" + File.separator;
        try {
            String line;
            File oriSdlxliff = new File(destDir.getParentFile() + File.separator + SOURCE_TRADOS_DIR + File.separator + midName.replace(".renum.xlf", ".sdlxliff"));
            if (!oriSdlxliff.exists()) {
                oriSdlxliff = XliffFileHook.readOriginalFileName(destDir.getCanonicalPath() + File.separator + midName);
                oriSdlxliff = new File(oriSdlxliff.getParentFile() + "\\" + midName.replace(".renum.xlf", ".sdlxliff"));
            }
            if (!oriSdlxliff.exists()) {
                this.lastCompileException = new FileNotFoundException("Need source sdlxliff to rebuild native file");
                return;
            }
            File tmpDestFile = new File(destDir.getParentFile(), COMPILED_TRADOS_DIR);
            if (!tmpDestFile.exists()) {
                tmpDestFile.mkdirs();
            }
            tmpDestFile = new File(tmpDestFile, midName.replace(".renum.xlf", ".sdlxliff"));
            System.err.println("perl " + extraScripts + "\\renum-to-trados.pl " + oriSdlxliff.getPath() + " " + destDir.getPath() + "\\" + midName + " " + tmpDestFile.getPath());
            Process p = Runtime.getRuntime().exec(new String[]{Preferences.getPreferenceDefault("perl_path", "perl"), extraScripts + "\\renum-to-trados.pl", oriSdlxliff.getPath(), destDir.getPath() + "\\" + midName, Core.getProject().getProjectProperties().getProjectRoot() + "\\omegat\\project_save.tmx", tmpDestFile.getPath()});
            System.err.println("Reading getInputStream");
            InputStream is = p.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                System.err.println("[PERL OUT]: " + line);
            }
            reader.close();
            is.close();
            System.err.println("Reading getErrorStream");
            is = p.getErrorStream();
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                System.err.println("[PERL ERR]: " + line);
            }
            reader.close();
            is.close();
            p.waitFor();
            XLIFF_HOOK.postCompile(new File(destDir.getParentFile(), "target-native"), midName.replace(".renum.xlf", ".sdlxliff"), destDir.getParentFile() + File.separator + COMPILED_TRADOS_DIR + File.separator);
            this.lastCompileException = XLIFF_HOOK.lastCompileException();
        }
        catch (Exception eEx) {
            this.lastCompileException = eEx;
            eEx.printStackTrace();
            Log.log(eEx);
        }
    }

    @Override
    public boolean supportsPseudoTags() {
        return true;
    }

    @Override
    public boolean supportsOpenInStudio(String file) {
        return true;
    }

    @Override
    public String getTradosTargetFile(String currentFile) {
        return currentFile.replaceAll("\\btarget(\\.tmp)?\\b", COMPILED_TRADOS_DIR).replace(".renum.xlf", ".sdlxliff");
    }
}

