/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2;

public class LBuffer {
    private char[] m_buf;
    private int m_size;

    public LBuffer(int size) {
        int sz = LBuffer.PowerOfTwo(size);
        if (sz < 4) {
            sz = 4;
        }
        this.m_buf = new char[sz];
        this.m_size = 0;
    }

    public void append(LBuffer buf) {
        if (buf.length() + this.m_size > this.m_buf.length) {
            this.setSize(buf.length() + this.m_size);
        }
        char[] b = buf.getBuf();
        System.arraycopy(b, 0, this.m_buf, this.m_size, buf.length());
        this.m_size += buf.length();
    }

    public void append(String str) {
        if (str.length() + this.m_size > this.m_buf.length) {
            this.setSize(str.length() + this.m_size);
        }
        str.getChars(0, str.length(), this.m_buf, this.m_size);
        this.m_size += str.length();
    }

    public void append(char c) {
        if (this.m_size + 1 > this.m_buf.length) {
            this.setSize(this.m_size + 1);
        }
        this.m_buf[this.m_size] = c;
        ++this.m_size;
    }

    public char getZeroChar() {
        if (0 >= this.m_size) {
            return '\u0000';
        }
        return this.m_buf[0];
    }

    public boolean isEqual(LBuffer buf) {
        if (buf.length() != this.m_size) {
            return false;
        }
        for (int i = 0; i < this.m_size; ++i) {
            if (this.m_buf[i] == buf.m_buf[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualIgnoreCase(String str) {
        if (str.length() != this.m_size) {
            return false;
        }
        String s = new String(this.m_buf, 0, this.m_size);
        return str.compareToIgnoreCase(s) == 0;
    }

    public String string() {
        return new String(this.m_buf, 0, this.m_size);
    }

    public void appendInt(int x) {
        this.append(Integer.toString(x));
    }

    private void setSize(int newSize) {
        if (newSize < 0) {
            newSize = 0;
        }
        if (newSize > this.m_buf.length) {
            int logSize;
            for (logSize = this.m_buf.length; newSize > logSize; logSize *= 2) {
            }
            char[] buf = new char[logSize];
            System.arraycopy(this.m_buf, 0, buf, 0, this.m_buf.length);
            this.m_buf = buf;
        }
        if (this.m_size > newSize) {
            this.m_size = newSize;
        }
    }

    public void reset() {
        this.m_size = 0;
    }

    private static int PowerOfTwo(int x) {
        int retVal = 0;
        int initVal = x;
        int ctr = 0;
        int bits = 0;
        if (x > 0) {
            while (x != 0) {
                ++ctr;
                if ((x & 1) != 0) {
                    ++bits;
                }
                x >>= 1;
            }
            retVal = bits == 1 ? initVal : 1 << ctr;
        }
        return retVal;
    }

    private int length() {
        return this.m_size;
    }

    public int size() {
        return this.m_size;
    }

    public char[] getBuf() {
        return this.m_buf;
    }
}

