/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.xliff;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.filters4.xml.xliff.AbstractXliffFilter;

public class Xliff1Filter
extends AbstractXliffFilter {
    private String unitId = null;
    private boolean flushedUnit = false;
    private int lastGroupId = 0;
    private List<XMLEvent> segSource = new LinkedList<XMLEvent>();
    private Map<String, List<XMLEvent>> subSegments = new TreeMap<String, List<XMLEvent>>();
    private StartElement targetStartEvent = null;
    private int inSubSeg = 0;

    @Override
    public String getFileFormatName() {
        return "Xliff 1.x";
    }

    @Override
    protected final String versionPrefix() {
        return "1.";
    }

    @Override
    protected void cleanBuffers() {
        this.source.clear();
        this.target = null;
        this.note.clear();
        this.segSource.clear();
        this.subSegments.clear();
    }

    @Override
    protected boolean processStartElement(StartElement startElement, XMLEventWriter evWriter) throws XMLStreamException {
        switch (startElement.getName().getLocalPart()) {
            case "xliff": {
                if (this.namespace != null) break;
                this.namespace = startElement.getName().getNamespaceURI();
                break;
            }
            case "file": {
                this.path = this.path + "/" + startElement.getAttributeByName(new QName("original")).getValue();
                this.updateIgnoreScope(startElement);
                break;
            }
            case "group": {
                try {
                    this.path = this.path + "/" + startElement.getAttributeByName(new QName("id")).getValue();
                }
                catch (NullPointerException noid) {
                    try {
                        this.path = this.path + "/" + startElement.getAttributeByName(new QName("resname")).getValue();
                    }
                    catch (NullPointerException noresname) {
                        this.path = this.path + "/x-auto-" + this.lastGroupId;
                        ++this.lastGroupId;
                    }
                }
                this.updateIgnoreScope(startElement);
                break;
            }
            case "trans-unit": {
                this.unitId = startElement.getAttributeByName(new QName("id")).getValue();
                this.flushedUnit = false;
                this.targetStartEvent = null;
                this.updateIgnoreScope(startElement);
                break;
            }
            case "source": {
                this.currentBuffer = this.source;
                this.source.clear();
                break;
            }
            case "target": {
                this.currentBuffer = this.target = new LinkedList();
                this.inTarget = true;
                this.targetStartEvent = startElement;
                break;
            }
            case "note": {
                this.currentBuffer = this.note;
                this.note.clear();
                break;
            }
            case "seg-source": {
                this.currentBuffer = this.segSource;
                this.segSource.clear();
                break;
            }
            case "mrk": {
                if (startElement.getAttributeByName(new QName("mtype")).getValue().equals("seg")) {
                    String mid = startElement.getAttributeByName(new QName("mid")).getValue();
                    this.currentBuffer.add(startElement);
                    this.currentBuffer = new LinkedList();
                    if (!this.inTarget) {
                        this.subSegments.put(mid, this.currentBuffer);
                    }
                    ++this.inSubSeg;
                    break;
                }
                if (this.inSubSeg > 0) {
                    ++this.inSubSeg;
                }
            }
            default: {
                if (this.currentBuffer != null) {
                    this.currentBuffer.add(startElement);
                    break;
                }
                if (this.ignoreScope != null && !this.ignoreScope.startsWith("!") || this.unitId == null || startElement.getName().getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:1.2")) break;
                this.flushTranslationsAndNotes(evWriter);
            }
        }
        return !this.inTarget;
    }

    @Override
    protected boolean processEndElement(EndElement endElement, XMLEventWriter evWriter) throws XMLStreamException {
        switch (endElement.getName().getLocalPart()) {
            case "source": 
            case "seg-source": 
            case "note": {
                this.currentBuffer = null;
                break;
            }
            case "target": {
                this.currentBuffer = null;
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    this.flushTranslationsAndNotes(evWriter);
                }
                this.inTarget = false;
                return false;
            }
            case "trans-unit": {
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    this.flushTranslationsAndNotes(evWriter);
                }
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    if (this.subSegments.isEmpty()) {
                        this.registerCurrentTransUnit(this.unitId, this.source, this.target, ".*");
                    } else {
                        HashSet<String> parsed = new HashSet<String>();
                        for (XMLEvent xMLEvent : this.segSource) {
                            List<XMLEvent> curSubSeg;
                            Attribute mid;
                            StartElement stEv;
                            if (!xMLEvent.isStartElement() || !(stEv = xMLEvent.asStartElement()).getName().getLocalPart().equals("mrk") || !stEv.getAttributeByName(new QName("mtype")).getValue().equals("seg") || (mid = stEv.getAttributeByName(new QName("mid"))) == null || (curSubSeg = this.subSegments.get(mid.getValue())) == null) continue;
                            this.registerCurrentTransUnit(this.unitId + "/" + mid.getValue(), curSubSeg, this.findSubsegment(this.target, mid.getValue()), "\\[(\\d+)\\](.*)\\[/\\1\\]");
                            parsed.add(mid.getValue());
                        }
                        for (Map.Entry entry : this.subSegments.entrySet()) {
                            if (parsed.contains(entry.getKey())) continue;
                            this.registerCurrentTransUnit(this.unitId + "/" + (String)entry.getKey(), (List)entry.getValue(), this.findSubsegment(this.target, (String)entry.getKey()), "\\[(\\d+)\\](.*)\\[/\\1\\]");
                        }
                    }
                }
                this.unitId = null;
                this.cleanBuffers();
                if (endElement.getName().getLocalPart().equals(this.ignoreScope)) {
                    this.ignoreScope = null;
                    break;
                }
                if (this.ignoreScope == null || !this.ignoreScope.startsWith("!" + endElement.getName().getLocalPart())) break;
                this.ignoreScope = this.ignoreScope.substring(endElement.getName().getLocalPart().length() + 2);
                break;
            }
            case "group": 
            case "file": {
                this.path = this.path.substring(0, this.path.lastIndexOf(47));
                this.cleanBuffers();
                if (endElement.getName().getLocalPart().equals(this.ignoreScope)) {
                    this.ignoreScope = null;
                    break;
                }
                if (this.ignoreScope == null || !this.ignoreScope.startsWith("!" + endElement.getName().getLocalPart())) break;
                this.ignoreScope = this.ignoreScope.substring(endElement.getName().getLocalPart().length() + 2);
                break;
            }
            case "mrk": {
                if (this.inSubSeg == 1) {
                    List<XMLEvent> save = this.inTarget ? this.target : this.segSource;
                    save.addAll(this.currentBuffer);
                    this.currentBuffer = save;
                    this.currentBuffer.add(endElement);
                    this.inSubSeg = 0;
                    break;
                }
                if (this.inSubSeg > 0) {
                    --this.inSubSeg;
                }
            }
            default: {
                if (this.currentBuffer == null) break;
                this.currentBuffer.add(endElement);
            }
        }
        return !this.inTarget;
    }

    protected void addNoteFromSource(String tag, String noteText) {
        this.note.add(eFactory.createCharacters("[" + tag + "]" + noteText + "[/" + tag + "]"));
    }

    @Override
    protected String[] getPairIdNames(boolean start) {
        return new String[]{"rid", "id", "i"};
    }

    protected PrepareTMXEntry currentEntryTranslation(String mid) {
        if (this.entryTranslateCallback == null) {
            return null;
        }
        if (this.subSegments.get(mid) == null) {
            System.err.println("currentEntryTranslation: Not found segment(" + mid + ")");
            return null;
        }
        return this.entryTranslateCallback.getTranslationEntry(this.unitId + "/" + mid, this.buildTags(this.subSegments.get(mid), false), this.path);
    }

    @Override
    protected String buildTags(List<XMLEvent> srcList, boolean reuse) {
        if (!reuse) {
            this.tagsMap.clear();
            for (Character c : this.tagsCount.keySet()) {
                this.tagsCount.put(c, 0);
            }
        }
        StringBuffer res = new StringBuffer();
        StringBuffer saveBuf = null;
        LinkedList<XMLEvent> nativeCode = null;
        boolean errCount = false;
        block26: for (XMLEvent ev : srcList) {
            if (nativeCode != null) {
                nativeCode.add(ev);
            }
            if (ev.isCharacters()) {
                if (nativeCode != null) continue;
                res.append(ev.asCharacters().getData());
                continue;
            }
            if (ev.isStartElement()) {
                StartElement stEl = ev.asStartElement();
                String name = stEl.getName().getLocalPart();
                char prefix = this.findPrefix(stEl);
                Integer count = (Integer)this.tagsCount.get(Character.valueOf(prefix));
                if (count == null) {
                    count = 0;
                }
                this.tagsCount.put(Character.valueOf(prefix), count + 1);
                switch (name) {
                    case "x": {
                        res.append(this.startPair(reuse, true, stEl, 'x', count, Xliff1Filter.toPair(stEl)));
                        break;
                    }
                    case "bx": {
                        res.append(this.startPair(reuse, false, stEl, prefix, count, Xliff1Filter.toPair(stEl)));
                        break;
                    }
                    case "ex": {
                        res.append(this.endPair(reuse, stEl, prefix, count, Xliff1Filter.toPair(stEl)));
                        break;
                    }
                    case "bpt": {
                        nativeCode = new LinkedList<XMLEvent>();
                        res.append(this.startPair(reuse, false, stEl, prefix, count, nativeCode));
                        saveBuf = res;
                        res = new StringBuffer();
                        nativeCode.add(ev);
                        break;
                    }
                    case "ept": {
                        nativeCode = new LinkedList();
                        res.append(this.endPair(reuse, stEl, prefix, count, nativeCode));
                        saveBuf = res;
                        res = new StringBuffer();
                        nativeCode.add(ev);
                        break;
                    }
                    default: {
                        if (this.isProtectedTag(stEl)) {
                            nativeCode = new LinkedList();
                            if (reuse) {
                                res.append(this.findKey(stEl, true));
                            } else {
                                String posVal;
                                Attribute posAttr = stEl.getAttributeByName(new QName("pos"));
                                String string = posVal = posAttr == null ? "" : posAttr.getValue();
                                if ("close".equals(posVal) || "end".equals(posVal)) {
                                    this.tagsMap.put("/" + prefix + count, nativeCode);
                                    res.append("</").append(prefix).append(count).append(">");
                                } else {
                                    this.tagsMap.put("" + prefix + count, nativeCode);
                                    if ("open".equals(posVal) || "begin".equals(posVal)) {
                                        res.append("<").append(prefix).append(count).append(">");
                                    } else {
                                        res.append("<").append(prefix).append(count).append("/>");
                                    }
                                }
                            }
                            saveBuf = res;
                            res = new StringBuffer();
                            nativeCode.add(ev);
                            this.tagStack.push("mark-protected");
                            break;
                        }
                        if (this.isIngoredTag(stEl)) {
                            this.tagStack.push("mark-ignored");
                            break;
                        }
                        this.startStackElement(reuse, stEl, prefix, count, res);
                        break;
                    }
                }
                continue;
            }
            if (!ev.isEndElement()) continue;
            EndElement endEl = ev.asEndElement();
            switch (endEl.getName().getLocalPart()) {
                case "x": 
                case "bx": 
                case "ex": {
                    continue block26;
                }
                case "bpt": 
                case "ept": {
                    nativeCode = null;
                    res.setLength(0);
                    res = saveBuf;
                    continue block26;
                }
            }
            String pop = (String)this.tagStack.pop();
            if (pop.equals("mark-protected")) {
                nativeCode = null;
                res.setLength(0);
                res = saveBuf;
                continue;
            }
            if (pop.equals("mark-ignored")) continue;
            this.tagsMap.put("/" + pop, Collections.singletonList(ev));
            res.append("</").append(pop).append(">");
        }
        return res.toString();
    }

    protected char findPrefix(StartElement stEl) {
        String name = stEl.getName().getLocalPart();
        if (name.equals("bx") || name.equals("ex")) {
            return 'e';
        }
        if (name.equals("bpt") || name.equals("ept")) {
            return 't';
        }
        if (name.equals("it")) {
            return 'a';
        }
        if (!stEl.getName().getNamespaceURI().equals(this.namespace)) {
            System.err.println("Found strange tag: " + stEl + " (" + stEl.getName().getNamespaceURI() + " vs " + this.namespace + ")");
            return 'o';
        }
        Attribute ctype = stEl.getAttributeByName(new QName("ctype"));
        if (ctype == null || ctype.getValue() == null || ctype.getValue().length() == 0) {
            ctype = stEl.getAttributeByName(new QName("type"));
        }
        if (ctype != null && ctype.getValue().length() > 0) {
            return Character.toLowerCase(ctype.getValue().charAt(0));
        }
        if (!(name.startsWith("g") || name.startsWith("x") || name.equals("mrk"))) {
            System.err.println("Found strange tag: " + stEl);
        }
        return name.charAt(0);
    }

    protected boolean isProtectedTag(StartElement stEl) {
        return stEl.getName().equals(new QName(this.namespace, "ph")) || stEl.getName().equals(new QName(this.namespace, "it")) || stEl.getName().equals(new QName(this.namespace, "mrk")) && stEl.getAttributeByName(new QName("mtype")).getValue().equals("protected");
    }

    protected boolean isIngoredTag(StartElement stEl) {
        return false;
    }

    public boolean isUsingStandardNote() {
        return true;
    }

    protected boolean isStandardTranslationState() {
        return true;
    }

    protected final void generateTargetStartElement(XMLEventWriter writer) throws XMLStreamException {
        boolean isTranslated;
        if (!this.isStandardTranslationState()) {
            if (this.targetStartEvent == null) {
                writer.add(eFactory.createStartElement(new QName(this.namespace, "target"), null, null));
            } else {
                writer.add(this.targetStartEvent);
            }
            return;
        }
        if (this.subSegments.isEmpty()) {
            isTranslated = this.entryTranslateCallback.getTranslation(this.unitId, this.buildTags(this.source, false), this.path) != null;
        } else {
            isTranslated = true;
            for (String mid : this.subSegments.keySet()) {
                isTranslated = isTranslated && null != this.entryTranslateCallback.getTranslation(this.unitId + "/" + mid, this.buildTags(this.subSegments.get(mid), false), this.path);
            }
        }
        if (isTranslated) {
            writer.add(eFactory.createStartElement(new QName(this.namespace, "target"), null, null));
            writer.add(eFactory.createAttribute(new QName("state"), "translated"));
            if (this.targetStartEvent != null) {
                Iterator<Attribute> I = this.targetStartEvent.getAttributes();
                while (I.hasNext()) {
                    Attribute next = I.next();
                    if ("state".equals(next.getName().getLocalPart())) continue;
                    writer.add(next);
                }
            }
        } else if (this.targetStartEvent == null) {
            writer.add(eFactory.createStartElement(new QName(this.namespace, "target"), null, null));
        } else {
            writer.add(this.targetStartEvent);
        }
    }

    private void flushTranslationsAndNotes(XMLEventWriter evWriter) throws XMLStreamException {
        if (evWriter == null) {
            return;
        }
        if (this.flushedUnit) {
            return;
        }
        QName __TARGET = new QName(this.namespace, "target");
        QName __NOTE = new QName(this.namespace, "note");
        if (this.subSegments.isEmpty()) {
            String note;
            String src = this.buildTags(this.source, false);
            String tra = this.entryTranslateCallback.getTranslation(this.unitId, src, this.path);
            if (tra != null) {
                this.generateTargetStartElement(evWriter);
                for (XMLEvent ev : this.restoreTags(this.unitId, this.path, src, tra)) {
                    evWriter.add(ev);
                }
                evWriter.add(eFactory.createEndElement(__TARGET, null));
            } else if (this.target != null) {
                this.generateTargetStartElement(evWriter);
                for (XMLEvent ev : this.target) {
                    evWriter.add(ev);
                }
                evWriter.add(eFactory.createEndElement(__TARGET, null));
            }
            if (this.isUsingStandardNote() && (note = this.entryTranslateCallback.getNote(this.unitId, src, this.path)) != null) {
                evWriter.add(eFactory.createStartElement(__NOTE, null, null));
                evWriter.add(eFactory.createCharacters(note));
                evWriter.add(eFactory.createEndElement(__NOTE, null));
            }
        } else {
            this.inSubSeg = 0;
            this.generateTargetStartElement(evWriter);
            StringBuffer noteBuf = new StringBuffer();
            for (XMLEvent ev : this.segSource) {
                XMLEvent el;
                if (ev.isStartElement() && (el = ev.asStartElement()).getName().getLocalPart().equals("mrk")) {
                    if (el.getAttributeByName(new QName("mtype")).getValue().equals("seg")) {
                        evWriter.add(ev);
                        String mid = el.getAttributeByName(new QName("mid")).getValue();
                        String src = this.buildTags(this.subSegments.get(mid), false);
                        String tra = this.entryTranslateCallback.getTranslation(this.unitId + "/" + mid, src, this.path);
                        if (tra != null) {
                            for (XMLEvent tev : this.restoreTags(this.unitId, this.path, src, tra)) {
                                evWriter.add(tev);
                            }
                        } else {
                            List<XMLEvent> fromTarget = this.findSubsegment(this.target, mid);
                            if (fromTarget != null && fromTarget.size() > 0) {
                                for (XMLEvent tev : fromTarget) {
                                    evWriter.add(tev);
                                }
                            } else {
                                for (XMLEvent tev : this.subSegments.get(mid)) {
                                    evWriter.add(tev);
                                }
                            }
                        }
                        ++this.inSubSeg;
                        String note = this.entryTranslateCallback.getNote(this.unitId + "/" + mid, src, this.path);
                        if (note != null) {
                            noteBuf.append("[").append(mid).append("]").append(note).append("[/").append(mid).append("]");
                        }
                    } else if (this.inSubSeg > 0) {
                        ++this.inSubSeg;
                    }
                }
                if (ev.isEndElement() && (el = ev.asEndElement()).getName().getLocalPart().equals("mrk") && this.inSubSeg > 0) {
                    --this.inSubSeg;
                }
                if (this.inSubSeg != 0) continue;
                evWriter.add(ev);
            }
            evWriter.add(eFactory.createEndElement(__TARGET, null));
            if (this.isUsingStandardNote() && noteBuf.length() > 0) {
                evWriter.add(eFactory.createStartElement(__NOTE, null, null));
                evWriter.add(eFactory.createCharacters(noteBuf.toString()));
                evWriter.add(eFactory.createEndElement(__NOTE, null));
            }
        }
        this.flushedUnit = true;
    }

    protected List<XMLEvent> restoreTags(String unitId, String path, String src, String tra) {
        return super.restoreTags(tra);
    }

    @Override
    protected StartElement createAddTagElement(char type, int idx) {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        attrs.add(eFactory.createAttribute(new QName("id"), "pseudo-" + idx));
        switch (type) {
            case '\u2460': {
                attrs.add(eFactory.createAttribute(new QName("ctype"), "italic"));
                break;
            }
            case '\u2461': {
                attrs.add(eFactory.createAttribute(new QName("ctype"), "bold"));
                break;
            }
            case '\u2462': {
                attrs.add(eFactory.createAttribute(new QName("ctype"), "underlined"));
            }
        }
        return eFactory.createStartElement(new QName(this.namespace, "g"), attrs.iterator(), null);
    }

    private List<XMLEvent> findSubsegment(List<XMLEvent> list, String mid) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        LinkedList<XMLEvent> buf = new LinkedList<XMLEvent>();
        int depth = 0;
        for (XMLEvent ev : this.target) {
            XMLEvent el;
            if (ev.isEndElement() && (el = ev.asEndElement()).getName().getLocalPart().equals("mrk")) {
                if (depth == 1) {
                    return buf;
                }
                if (depth > 0) {
                    --depth;
                }
            }
            if (depth > 0) {
                buf.add(ev);
            }
            if (!ev.isStartElement() || !(el = ev.asStartElement()).getName().getLocalPart().equals("mrk")) continue;
            if (el.getAttributeByName(new QName("mtype")).getValue().equals("seg") && el.getAttributeByName(new QName("mid")).getValue().equals(mid)) {
                depth = 1;
                continue;
            }
            if (depth <= 0) continue;
            ++depth;
        }
        return buf;
    }
}

