/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.filter;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.search.CrossSourceSearchResultEntry;
import org.omegat.core.search.CrossSourceSearcher;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.filter.FilterBarCrossSource;

public class CrossSourceFilter
implements IEditorFilter {
    private final List<CrossSourceSearchResultEntry> entries = new LinkedList<CrossSourceSearchResultEntry>();
    private FilterBarCrossSource controlComponent;
    private CrossSourceSearcher searcher;
    private int currentEntryNum;

    public CrossSourceFilter(CrossSourceSearcher searcher, int initialEntryNum) {
        this.searcher = searcher;
        this.currentEntryNum = initialEntryNum;
        for (SearchResultEntry sre : searcher.getSearchResults()) {
            this.entries.add((CrossSourceSearchResultEntry)sre);
        }
        this.controlComponent = new FilterBarCrossSource();
        this.controlComponent.btnRemoveFilter.addActionListener(e -> {
            Core.getEditor().commitAndDeactivate();
            Core.getEditor().removeFilter();
        });
        this.controlComponent.btnNext.addActionListener(e -> {
            Core.getEditor().removeFilter();
            ++this.currentEntryNum;
            if (this.currentEntryNum > this.entries.size()) {
                this.currentEntryNum = 0;
            }
            Core.getEditor().setFilter(this);
        });
    }

    @Override
    public boolean isSourceAsEmptyTranslation() {
        return true;
    }

    @Override
    public boolean allowed(SourceTextEntry ste) {
        return this.entries.get(this.currentEntryNum).entries().contains(ste.entryNum());
    }

    @Override
    public Component getControlComponent() {
        return this.controlComponent;
    }
}

