/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.notes;

import java.awt.Dimension;
import javax.swing.undo.UndoManager;
import org.omegat.core.Core;
import org.omegat.gui.common.EntryInfoPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.notes.INotes;
import org.omegat.util.OStrings;
import org.omegat.util.gui.JTextPaneLinkifier;
import org.omegat.util.gui.UIThreadsUtil;

public class NotesTextArea
extends EntryInfoPane<String>
implements INotes {
    private static final String EXPLANATION = OStrings.getString("GUI_NOTESWINDOW_explanation");
    UndoManager undoManager;

    public NotesTextArea(MainWindow mw) {
        super(true);
        String title = OStrings.getString("GUI_NOTESWINDOW_SUBWINDOWTITLE_Notes");
        Core.getMainWindow().addDockable(new DockableScrollPane("NOTES", title, this, true));
        this.setEditable(false);
        this.setText(EXPLANATION);
        this.setDragEnabled(true);
        this.setMinimumSize(new Dimension(100, 50));
        JTextPaneLinkifier.linkify(this);
        this.undoManager = new UndoManager();
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
    }

    @Override
    public void clear() {
        super.clear();
        this.setEditable(false);
        this.undoManager.discardAllEdits();
    }

    @Override
    public void setNoteText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(text);
        this.setEditable(true);
    }

    @Override
    public String getNoteText() {
        UIThreadsUtil.mustBeSwingThread();
        String text = this.getText();
        return text.isEmpty() ? null : text;
    }

    @Override
    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    @Override
    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }
}

