/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import org.omegat.core.Core;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class RecentProjects {
    private static final List<String> recentProjects;
    private static final int mostRecentProjectSize;

    private RecentProjects() {
    }

    private static void saveToPrefs() {
        for (int i = 0; i < recentProjects.size(); ++i) {
            String project = recentProjects.get(i);
            if (StringUtil.isEmpty(project)) continue;
            Preferences.setPreference("most_recent_projects_" + i, recentProjects.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMenu() {
        IMainWindow window = Core.getMainWindow();
        if (window == null) {
            return;
        }
        JMenuItem recentMenu = window.getMainMenu().getProjectRecentMenuItem();
        if (recentMenu == null) {
            return;
        }
        recentMenu.removeAll();
        List<String> list = recentProjects;
        synchronized (list) {
            for (final String project : recentProjects) {
                JMenuItem recentProjectMenuItem = new JMenuItem(project);
                recentProjectMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ProjectUICommands.projectOpen(new File(project), true);
                    }
                });
                recentMenu.add(recentProjectMenuItem);
            }
            recentMenu.setEnabled(!recentProjects.isEmpty());
        }
    }

    public static void add(String element) {
        if (StringUtil.isEmpty(element)) {
            return;
        }
        recentProjects.remove(element);
        recentProjects.add(0, element);
        while (recentProjects.size() > mostRecentProjectSize) {
            recentProjects.remove(mostRecentProjectSize);
        }
        RecentProjects.updateMenu();
        RecentProjects.saveToPrefs();
    }

    static {
        mostRecentProjectSize = Preferences.getPreferenceDefault("most_recent_projects_size", 5);
        recentProjects = new ArrayList<String>(mostRecentProjectSize);
        for (int i = 0; i < mostRecentProjectSize; ++i) {
            String project = Preferences.getPreferenceDefault("most_recent_projects_" + i, null);
            if (project == null) continue;
            recentProjects.add(project);
        }
    }
}

