/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.history;

import java.util.ArrayList;
import java.util.List;
import org.madlonkay.history.WordCompleter;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.AutoCompleterListView;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;

public class HistoryCompleter
extends AutoCompleterListView {
    WordCompleter completer = new WordCompleter();
    private SourceTextEntry currentEntry;
    private TMXEntry currentEntryTranslation;

    public HistoryCompleter() {
        super("History Completions");
        CoreEvents.registerProjectChangeListener((IProjectEventListener)new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD) {
                    HistoryCompleter.this.train();
                }
            }
        });
        CoreEvents.registerEntryEventListener((IEntryEventListener)new IEntryEventListener(){

            public void onNewFile(String activeFileName) {
            }

            public void onEntryActivated(SourceTextEntry newEntry) {
                SourceTextEntry lastEntry = HistoryCompleter.this.currentEntry;
                TMXEntry lastEntryTranslation = HistoryCompleter.this.currentEntryTranslation;
                if (lastEntry != null && lastEntryTranslation != null && !lastEntryTranslation.isTranslated()) {
                    TMXEntry newTranslation = Core.getProject().getTranslationInfo(lastEntry);
                    HistoryCompleter.this.trainString(newTranslation.translation);
                }
                HistoryCompleter.this.currentEntry = newEntry;
                HistoryCompleter.this.currentEntryTranslation = Core.getProject().getTranslationInfo(newEntry);
            }
        });
    }

    synchronized void train() {
        this.completer.reset();
        Core.getProject().iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){

            public void iterate(String source, TMXEntry trans) {
                HistoryCompleter.this.trainString(trans.translation);
            }
        });
        Core.getProject().iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){

            public void iterate(EntryKey source, TMXEntry trans) {
                HistoryCompleter.this.trainString(trans.translation);
            }
        });
    }

    private void trainString(String text) {
        if (text == null) {
            return;
        }
        String[] tokens = this.getTokenizer().tokenizeWordsToStrings(text, ITokenizer.StemmingMode.NONE);
        this.completer.train(text, tokens);
    }

    public List<AutoCompleterItem> computeListData(String prevText, boolean contextualOnly) {
        if (prevText == null || prevText.isEmpty()) {
            return new ArrayList<AutoCompleterItem>(1);
        }
        return this.completer.completeWord(this.getLastToken(prevText));
    }

    public String itemToString(AutoCompleterItem item) {
        return item.payload;
    }

    public boolean shouldPopUp() {
        return Preferences.isPreference((String)"allow_history_completer") && super.shouldPopUp();
    }
}

