/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.history;

import java.util.ArrayList;
import java.util.List;
import org.madlonkay.history.WordPredictor;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.AutoCompleterListView;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;

public class HistoryPredictor
extends AutoCompleterListView {
    WordPredictor predictor = new WordPredictor();
    private SourceTextEntry currentEntry;
    private TMXEntry currentEntryTranslation;

    public HistoryPredictor() {
        super("History Predictions");
        CoreEvents.registerProjectChangeListener((IProjectEventListener)new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD) {
                    HistoryPredictor.this.train();
                }
            }
        });
        CoreEvents.registerEntryEventListener((IEntryEventListener)new IEntryEventListener(){

            public void onNewFile(String activeFileName) {
            }

            public void onEntryActivated(SourceTextEntry newEntry) {
                SourceTextEntry lastEntry = HistoryPredictor.this.currentEntry;
                TMXEntry lastEntryTranslation = HistoryPredictor.this.currentEntryTranslation;
                if (lastEntry != null && lastEntryTranslation != null && !lastEntryTranslation.isTranslated()) {
                    TMXEntry newTranslation = Core.getProject().getTranslationInfo(lastEntry);
                    HistoryPredictor.this.trainString(newTranslation.translation);
                }
                HistoryPredictor.this.currentEntry = newEntry;
                HistoryPredictor.this.currentEntryTranslation = Core.getProject().getTranslationInfo(newEntry);
            }
        });
    }

    synchronized void train() {
        this.predictor.reset();
        Core.getProject().iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){

            public void iterate(String source, TMXEntry trans) {
                HistoryPredictor.this.trainString(trans.translation);
            }
        });
        Core.getProject().iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){

            public void iterate(EntryKey source, TMXEntry trans) {
                HistoryPredictor.this.trainString(trans.translation);
            }
        });
    }

    private void trainString(String text) {
        if (text == null) {
            return;
        }
        String[] tokens = this.getTokenizer().tokenizeWordsToStrings(text, ITokenizer.StemmingMode.NONE);
        this.predictor.trainStringPrediction(text, tokens);
    }

    public List<AutoCompleterItem> computeListData(String prevText, boolean contextualOnly) {
        if (prevText == null || prevText.isEmpty()) {
            return new ArrayList<AutoCompleterItem>(1);
        }
        String[] tokens = this.getTokenizer().tokenizeVerbatimToStrings(prevText);
        List<AutoCompleterItem> predictions = this.predictor.predictWord(tokens);
        if (predictions.isEmpty()) {
            return predictions;
        }
        if (tokens[tokens.length - 1].trim().isEmpty()) {
            return predictions;
        }
        String context = tokens[tokens.length - 1];
        ArrayList<AutoCompleterItem> result = new ArrayList<AutoCompleterItem>();
        for (AutoCompleterItem item : predictions) {
            if (!item.payload.startsWith(context) || item.payload.equals(context)) continue;
            result.add(new AutoCompleterItem(item.payload, item.extras, context.length()));
        }
        return result;
    }

    public String itemToString(AutoCompleterItem item) {
        return "<html>" + item.payload + " <font color=\"gray\">(" + item.extras[0] + ")</font></html>";
    }

    public boolean shouldPopUp() {
        return Preferences.isPreference((String)"allow_history_completer") && Preferences.isPreference((String)"history_completer_prediction_enabled") && super.shouldPopUp();
    }
}

