/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.madlonkay.history.HistoryCompleter;
import org.madlonkay.history.HistoryPredictor;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.gui.editor.autocompleter.AbstractAutoCompleterView;
import org.omegat.util.Preferences;

public class Installer {
    static final String PREFERENCE_AUTOMATIC = "allow_history_completer";
    static final String PREFERENCE_COMPLETION_MIN_CHARS = "history_completer_min_chars";
    static final String PREFERENCE_PREDICTION_ENABLED = "history_completer_prediction_enabled";
    static final String MENU_TITLE = "History Completer";
    static final String MENU_ITEM_AUTOMATIC = "Suggest Automatically";
    static final String MENU_ITEM_PREDICTION_ENABLED = "Predict Words";
    static final String MENU_ITEM_CHARS_LABEL = "Complete words after:";
    static final String MENU_ITEM_NCHARS_ONE = "%d character";
    static final String MENU_ITEM_NCHARS_OTHER = "%d characters";
    static final int MIN_CHARS_MIN = 1;
    static final int MIN_CHARS_MAX = 5;

    public static void loadPlugins() {
        CoreEvents.registerApplicationEventListener((IApplicationEventListener)new IApplicationEventListener(){

            public void onApplicationStartup() {
                Installer.install();
            }

            public void onApplicationShutdown() {
            }
        });
    }

    private static void install() {
        final HistoryCompleter view = new HistoryCompleter();
        Core.getEditor().getAutoCompleter().addView((AbstractAutoCompleterView)view);
        HistoryPredictor predictor = new HistoryPredictor();
        Core.getEditor().getAutoCompleter().addView((AbstractAutoCompleterView)predictor);
        JMenu menu = new JMenu(MENU_TITLE);
        JMenuItem item = new JCheckBoxMenuItem(MENU_ITEM_AUTOMATIC);
        item.setSelected(Preferences.isPreference((String)PREFERENCE_AUTOMATIC));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.setPreference((String)Installer.PREFERENCE_AUTOMATIC, (Object)((AbstractButton)e.getSource()).isSelected());
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JCheckBoxMenuItem(MENU_ITEM_PREDICTION_ENABLED);
        item.setSelected(Preferences.isPreference((String)PREFERENCE_PREDICTION_ENABLED));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.setPreference((String)Installer.PREFERENCE_PREDICTION_ENABLED, (Object)((AbstractButton)e.getSource()).isSelected());
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(MENU_ITEM_CHARS_LABEL);
        item.setEnabled(false);
        menu.add(item);
        ButtonGroup group = new ButtonGroup();
        int minChars = Preferences.getPreferenceDefault((String)PREFERENCE_COMPLETION_MIN_CHARS, (int)3);
        for (int i = 1; i <= 5; ++i) {
            final int chars = i;
            item = new JRadioButtonMenuItem(String.format(chars == 1 ? MENU_ITEM_NCHARS_ONE : MENU_ITEM_NCHARS_OTHER, chars));
            item.setSelected(chars == minChars);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preferences.setPreference((String)Installer.PREFERENCE_COMPLETION_MIN_CHARS, (Object)chars);
                    view.completer.minSeedLength = chars;
                    if (Core.getProject().isProjectLoaded()) {
                        view.train();
                    }
                }
            });
            group.add(item);
            menu.add(item);
        }
        try {
            Core.getMainWindow().getMainMenu().getAutoCompletionMenu().add(menu);
        }
        catch (Throwable ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, "Failed to install the History Completer menu. OmegaT 3.6+ is required.", ex);
        }
    }

    public static void unloadPlugins() {
    }
}

