my $IN = shift or die "Syntax : $0 <input sdlxliff file> <output renum-xliff file?>";
my $OUT = shift; unless ($OUT) { $OUT = $IN; $OUT =~ s/\.sdlxliff/\.renum\.xlf/; }

open(IN, $IN) or die "Could not open '$IN': $!";
open (OUT, ">$OUT") or die "Cannot write $OUT: $!"; 

our %COMMENTS;

local $/ = '</header>';
$CONTENTS = <IN>; $CONTENTS =~ s!<header(.+)</header>!<header />!s; 
if ($CONTENTS =~ m!<doc\-info(.+)</doc-info>!) {
    while ($CONTENTS =~ m!<cmt-def id="([0-9A-Fa-f\-]+)">(.+?)</cmt\-def>!g) {
        my $id = $1; my $comTxt = $2;
        while ($comTxt =~ m!<Comment (.*?)>(.+?)</Comment>!g) {
            $COMMENTS{$id} .= $2 . "\n";
        }
        $COMMENTS{$id} =~ s/\n+$//;
    }
    $CONTENTS =~ s!<doc\-info(.+)</doc-info>!!;
}
print OUT $CONTENTS;


$/ = '</trans-unit>';
while (defined ($CONTENTS = <IN>)) {
    $CONTENTS =~ s{<seg-source>(.+?)</seg-source>}{renum($1,'seg-source')}ges;
    $CONTENTS =~ s{<source>(.+?)</source>}{renum($1,'source')}ges;
    $CONTENTS =~ s{<target>(.+?)</target>}{renum($1,'target')}ges;
    
    my $curNote = ""; $curNote .= $COMMENTS{$1} while $CONTENTS =~ m!<mrk mtype="x-sdl-comment" sdl:cid="([0-9A-Fa-f\-]+)"!g;
    if ($curNote) {     # XLIFF-1 : comes after <target> and before any <sdl:xxx>
        $CONTENTS =~ s{</note>}{$&<note>$curNote</note>}
            or $CONTENTS =~ s{</target>}{$&<note>$curNote</note>}
            or $CONTENTS =~ s{<sdl:}{<note>$curNote</note>$&};
    }
    
    # Remove segments with only tags -- these ones could be translated automatically
    my $SrcText = $1 if $CONTENTS =~ m{<source(?:.+?)>(.+?)</source>}s; $SrcText =~ s/\<.+?\>//gs;
    unless ($SrcText) { $CONTENTS =~ s{<trans-unit.+?</trans-unit>}{}s; }
    
    print OUT $CONTENTS;
}


close IN; close OUT;


sub renum($) {
    my $txt = shift;
    my ($first) = ($txt =~ m!<(?:g|x) id="(\d+)"!);
    $txt =~ s!<(g|x) id="(\d+)"!"<$1 id=\"" . ($2 - $first) . "\""!ge;
    my $mark = shift || 'seg-source';
    return "\n<$mark renum=\"$first\">$txt</$mark>\n";
}
