<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xliff="urn:oasis:names:tc:xliff:document:1.2"
	exclude-result-prefixes="xliff">

	<xsl:param name="selSrcTxt" />
	<xsl:param name="segmentNum" />
	
	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			</head>
			<body style="font-family:calibri;" onload="location.hash = '#jump'">
				<xsl:apply-templates select="//xliff:file" />
			</body>
		</html>
	</xsl:template>

	<xsl:template match="xliff:file">
		<div width="100%" style="background-color:#ADD8E6;">
			<b>Document: </b> <xsl:value-of select="@original" />
		</div>
		<table width="100%" border="0" cellpadding="2" cellspacing="1">
			<xsl:apply-templates select=".//xliff:trans-unit[xliff:seg-source//text()]" />
		</table>
	</xsl:template>
	
	<xsl:template match="xliff:trans-unit">
		<xsl:for-each select="xliff:seg-source//xliff:mrk">	
			<tr>
				<xsl:attribute name="bgcolor">
					<xsl:choose>
						<xsl:when test="@mid mod 2 = 0">#FFFFFF</xsl:when>
						<xsl:when test="($selSrcTxt = '') and ($segmentNum = @mid)">#FFFFCC</xsl:when>
						<xsl:otherwise>#F0F0F0</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				
				<td align="right">
					<xsl:if test="@mid = 1">
						<xsl:attribute name="width">4%</xsl:attribute>
					</xsl:if>
					<a name="{./@mid}" />
					<xsl:if test="($selSrcTxt = '') and ($segmentNum = @mid) and ($segmentNum &lt; 3)">
						<a name="jump" />
					</xsl:if>
					<xsl:if test="($selSrcTxt = '') and ($segmentNum = @mid + 2) and ($segmentNum &gt;= 3)">
						<a name="jump" />
					</xsl:if>
					<xsl:value-of select="@mid" />			
				</td>
				<td>
					<xsl:if test="@mid = 1">
						<xsl:attribute name="width">47%</xsl:attribute>
					</xsl:if>
					<xsl:apply-templates  />
				</td>
				<td>
					<xsl:if test="@mid = 1">
						<xsl:attribute name="width">47%</xsl:attribute>
					</xsl:if>
					<xsl:variable name="id" select="@mid" />
					<xsl:apply-templates select="ancestor::xliff:trans-unit//xliff:target//xliff:mrk[@mid = $id]/node()" />
				</td>
				<xsl:if test="position() = 1" ><td valign="top"><div style="background-color:#C2DFFF; text-align:center">P</div></td></xsl:if>
			</tr>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="xliff:g">
		<em><xsl:apply-templates /></em>
	</xsl:template>
	
	<xsl:template match="text()">
		<xsl:choose>
			<xsl:when test="($selSrcTxt != '') and contains(., $selSrcTxt)">
				<a name="jump" />
				<xsl:value-of select="substring-before(., $selSrcTxt)" />
				<span style="background-color: yellow"><xsl:value-of select="$selSrcTxt" /></span>
				<xsl:value-of select="substring-after(., $selSrcTxt)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="." />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>