/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.sasl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNPlainAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.sasl.SaslInputStream;
import org.tmatesoft.svn.core.internal.io.svn.sasl.SaslOutputStream;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSaslAuthenticator
extends SVNAuthenticator {
    private SaslClient myClient;
    private ISVNAuthenticationManager myAuthenticationManager;
    private SVNAuthentication myAuthentication;

    public SVNSaslAuthenticator(SVNConnection connection) throws SVNException {
        super(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVNAuthentication authenticate(List mechs, String realm, SVNRepositoryImpl repository) throws SVNException {
        boolean failed = true;
        this.setLastError(null);
        this.myAuthenticationManager = repository.getAuthenticationManager();
        this.myAuthentication = null;
        boolean isAnonymous = false;
        if (mechs.contains("EXTERNAL") && repository.getExternalUserName() != null) {
            mechs = new ArrayList();
            mechs.add("EXTERNAL");
        } else {
            for (String m : mechs) {
                if (!"ANONYMOUS".equals(m) && !"EXTERNAL".equals(m) && !"PLAIN".equals(m)) continue;
                mechs = new ArrayList();
                isAnonymous = "ANONYMOUS".equals(m);
                mechs.add(m);
                break;
            }
        }
        this.dispose();
        try {
            this.myClient = this.createSaslClient(mechs, realm, repository, repository.getLocation());
            while (true) {
                boolean startOver;
                block19: {
                    if (this.myClient == null) {
                        SVNAuthentication mech = new SVNPlainAuthenticator(this.getConnection()).authenticate(mechs, realm, repository);
                        Object var10_12 = null;
                        if (!failed) return mech;
                        this.dispose();
                        return mech;
                    }
                    startOver = false;
                    try {
                        if (!this.tryAuthentication(repository, SVNSaslAuthenticator.getMechanismName(this.myClient, isAnonymous))) break block19;
                        if (this.myAuthenticationManager != null && this.myAuthentication != null) {
                            String realmName = SVNSaslAuthenticator.getFullRealmName(repository.getLocation(), realm);
                            BasicAuthenticationManager.acknowledgeAuthentication(true, this.myAuthentication.getKind(), realmName, null, this.myAuthentication, repository.getLocation(), this.myAuthenticationManager);
                        }
                        failed = false;
                        this.setLastError(null);
                        this.setEncryption(repository);
                        break;
                    }
                    catch (SaslException e) {
                        String mechName = SVNSaslAuthenticator.getMechanismName(this.myClient, isAnonymous);
                        mechs.remove(mechName);
                        startOver = true;
                    }
                }
                if (this.myAuthenticationManager != null) {
                    SVNErrorMessage error = this.getLastError();
                    if (error == null) {
                        error = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED);
                        this.setLastError(error);
                    }
                    if (this.myAuthentication != null) {
                        String realmName = SVNSaslAuthenticator.getFullRealmName(repository.getLocation(), realm);
                        BasicAuthenticationManager.acknowledgeAuthentication(false, this.myAuthentication.getKind(), realmName, this.getLastError(), this.myAuthentication, repository.getLocation(), this.myAuthenticationManager);
                    } else {
                        mechs.remove(SVNSaslAuthenticator.getMechanismName(this.myClient, isAnonymous));
                    }
                }
                this.dispose();
                if (mechs.isEmpty()) {
                    failed = true;
                    break;
                }
                if (startOver) {
                    this.myAuthentication = null;
                }
                this.myClient = this.createSaslClient(mechs, realm, repository, repository.getLocation());
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (failed) {
                this.dispose();
            }
            throw throwable;
        }
        Object var10_13 = null;
        if (failed) {
            this.dispose();
        }
        if (this.getLastError() != null) {
            SVNErrorManager.error(this.getLastError(), SVNLogType.NETWORK);
        }
        return this.myAuthentication;
    }

    public void dispose() {
        if (this.myClient != null) {
            try {
                this.myClient.dispose();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
        }
    }

    protected boolean tryAuthentication(SVNRepositoryImpl repos, String mechName) throws SaslException, SVNException {
        boolean expectChallenge;
        String initialChallenge = null;
        boolean bl = expectChallenge = !"ANONYMOUS".equals(mechName) && !"EXTERNAL".equals(mechName) && !"PLAIN".equals(mechName);
        if ("EXTERNAL".equals(mechName) && repos.getExternalUserName() != null) {
            initialChallenge = "";
        } else if (this.myClient.hasInitialResponse()) {
            byte[] initialResponse = null;
            initialResponse = this.myClient.evaluateChallenge(new byte[0]);
            if (initialResponse == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected initial response received from {0}", (Object)mechName);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            initialChallenge = SVNSaslAuthenticator.toBase64(initialResponse);
        }
        if (initialChallenge != null) {
            this.getConnection().write("(w(s))", new Object[]{mechName, initialChallenge});
        } else {
            this.getConnection().write("(w())", new Object[]{mechName});
        }
        String status = "step";
        while ("step".equals(status)) {
            List items = this.getConnection().readTuple("w(?s)", true);
            status = (String)items.get(0);
            if ("failure".equals(status)) {
                String msg = items.size() > 1 ? items.get(1) : "";
                this.setLastError(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, msg));
                return false;
            }
            String challenge = items.size() > 1 ? items.get(1) : null;
            if (challenge == null && ("CRAM-MD5".equals(mechName) || "GSSAPI".equals(mechName)) && "success".equals(status)) {
                challenge = "";
            }
            if (!"step".equals(status) && !"success".equals(status) || challenge == null && expectChallenge) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected server response to authentication");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            byte[] challengeBytes = "CRAM-MD5".equals(mechName) ? challenge.getBytes() : SVNSaslAuthenticator.fromBase64(challenge);
            byte[] response = null;
            if (!this.myClient.isComplete()) {
                response = this.myClient.evaluateChallenge(challengeBytes);
            }
            if ("success".equals(status)) {
                return true;
            }
            if (response == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected response received from {0}", (Object)mechName);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            if (response.length > 0) {
                String responseStr = "CRAM-MD5".equals(mechName) ? new String(response) : SVNSaslAuthenticator.toBase64(response);
                this.getConnection().write("s", new Object[]{responseStr});
                continue;
            }
            this.getConnection().write("s", new Object[]{""});
        }
        return true;
    }

    protected void setEncryption(SVNRepositoryImpl repository) {
        if (this.getConnection().isEncrypted()) {
            this.dispose();
            return;
        }
        String qop = (String)this.myClient.getNegotiatedProperty("javax.security.sasl.qop");
        String buffSizeStr = (String)this.myClient.getNegotiatedProperty("javax.security.sasl.maxbuffer");
        String sendSizeStr = (String)this.myClient.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if ("auth-int".equals(qop) || "auth-conf".equals(qop)) {
            int outBuffSize = 1000;
            int inBuffSize = 1000;
            if (sendSizeStr != null) {
                try {
                    outBuffSize = Integer.parseInt(sendSizeStr);
                }
                catch (NumberFormatException nfe) {
                    outBuffSize = 1000;
                }
            }
            if (buffSizeStr != null) {
                try {
                    inBuffSize = Integer.parseInt(buffSizeStr);
                }
                catch (NumberFormatException nfe) {
                    inBuffSize = 1000;
                }
            }
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SASL read buffer size: " + inBuffSize);
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SASL write buffer size: " + outBuffSize);
            try {
                this.getPlainOutputStream().flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            OutputStream os = new SaslOutputStream(this.myClient, outBuffSize, this.getPlainOutputStream());
            os = repository.getDebugLog().createLogStream(SVNLogType.NETWORK, os);
            this.setOutputStream(os);
            InputStream is = new SaslInputStream(this.myClient, inBuffSize, this.getPlainInputStream());
            is = repository.getDebugLog().createLogStream(SVNLogType.NETWORK, is);
            this.setInputStream(is);
            this.getConnection().setEncrypted(this);
        } else {
            this.dispose();
        }
    }

    protected SaslClient createSaslClient(List mechs, String realm, SVNRepositoryImpl repos, SVNURL location) throws SVNException {
        SVNHashMap props = new SVNHashMap();
        props.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
        props.put("javax.security.sasl.maxbuffer", "8192");
        props.put("javax.security.sasl.rawsendsize", "8192");
        props.put("javax.security.sasl.policy.noplaintext", "false");
        props.put("javax.security.sasl.reuse", "false");
        props.put("javax.security.sasl.policy.noanonymous", "true");
        String[] mechsArray = mechs.toArray(new String[mechs.size()]);
        SaslClient client = null;
        for (int i = 0; i < mechsArray.length; ++i) {
            String mech = mechsArray[i];
            try {
                SaslClientFactory clientFactory;
                if ("ANONYMOUS".equals(mech) || "EXTERNAL".equals(mech) || "PLAIN".equals(mech)) {
                    props.put("javax.security.sasl.policy.noanonymous", "false");
                }
                if ((clientFactory = SVNSaslAuthenticator.getSaslClientFactory(mech, props)) == null) continue;
                SVNAuthentication auth = null;
                if ("ANONYMOUS".equals(mech)) {
                    auth = new SVNPasswordAuthentication("", "", false, location, false);
                } else if ("EXTERNAL".equals(mech)) {
                    String name = repos.getExternalUserName();
                    if (name == null) {
                        name = "";
                    }
                    auth = new SVNPasswordAuthentication(name, "", false, location, false);
                } else {
                    if (this.myAuthenticationManager == null) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication required for ''{0}''", (Object)realm), SVNLogType.NETWORK);
                    }
                    String realmName = SVNSaslAuthenticator.getFullRealmName(location, realm);
                    this.myAuthentication = this.myAuthentication != null ? this.myAuthenticationManager.getNextAuthentication("svn.simple", realmName, location) : this.myAuthenticationManager.getFirstAuthentication("svn.simple", realmName, location);
                    if (this.myAuthentication == null) {
                        if (this.getLastError() != null) {
                            SVNErrorManager.error(this.getLastError(), SVNLogType.NETWORK);
                        }
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication required for ''{0}''", (Object)realm), SVNLogType.NETWORK);
                    }
                    auth = this.myAuthentication;
                }
                client = clientFactory.createSaslClient(new String[]{"ANONYMOUS".equals(mech) ? "PLAIN" : mech}, null, "svn", location.getHost(), props, new SVNCallbackHandler(realm, auth));
                if (client != null) break;
                this.myAuthentication = null;
                continue;
            }
            catch (SaslException e) {
                mechs.remove(mechsArray[i]);
                this.myAuthentication = null;
            }
        }
        return client;
    }

    private static String getFullRealmName(SVNURL location, String realm) {
        if (location == null || realm == null) {
            return realm;
        }
        return "<" + location.getProtocol() + "://" + location.getHost() + ":" + location.getPort() + "> " + realm;
    }

    private static String toBase64(byte[] src) {
        return SVNBase64.byteArrayToBase64(src);
    }

    private static byte[] fromBase64(String src) {
        if (src == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            if (Character.isWhitespace(ch) || ch == '\n' || ch == '\r') continue;
            bos.write((byte)ch & 0xFF);
        }
        byte[] cbytes = new byte[src.length()];
        try {
            src = new String(bos.toByteArray(), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        int clength = SVNBase64.base64ToByteArray(new StringBuffer(src), cbytes);
        byte[] result = new byte[clength];
        for (int i = clength - 1; i >= 0; --i) {
            if (i != -1) continue;
            --clength;
        }
        System.arraycopy(cbytes, 0, result, 0, clength);
        return result;
    }

    private static String getMechanismName(SaslClient client, boolean isAnonymous) {
        if (client == null) {
            return null;
        }
        String name = client.getMechanismName();
        if ("PLAIN".equals(name) && isAnonymous) {
            name = "ANONYMOUS";
        }
        return name;
    }

    private static SaslClientFactory getSaslClientFactory(String mechName, Map props) {
        if (mechName == null) {
            return null;
        }
        if ("ANONYMOUS".equals(mechName)) {
            mechName = "PLAIN";
        }
        Enumeration<SaslClientFactory> factories = Sasl.getSaslClientFactories();
        while (factories.hasMoreElements()) {
            SaslClientFactory factory = factories.nextElement();
            String[] mechs = factory.getMechanismNames(props);
            for (int i = 0; mechs != null && i < mechs.length; ++i) {
                if (!mechName.endsWith(mechs[i])) continue;
                return factory;
            }
        }
        return null;
    }

    private static class SVNCallbackHandler
    implements CallbackHandler {
        private String myRealm;
        private SVNAuthentication myAuthentication;

        public SVNCallbackHandler(String realm, SVNAuthentication auth) {
            this.myRealm = realm;
            this.myAuthentication = auth;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback callback = callbacks[i];
                if (callback instanceof NameCallback) {
                    String userName = this.myAuthentication.getUserName();
                    ((NameCallback)callback).setName(userName != null ? userName : "");
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    String password = ((SVNPasswordAuthentication)this.myAuthentication).getPassword();
                    ((PasswordCallback)callback).setPassword(password != null ? password.toCharArray() : new char[]{});
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    ((RealmCallback)callback).setText(this.myRealm);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

