/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarContainer;
import com.vlsolutions.swing.toolbars.ToolBarIO;
import com.vlsolutions.swing.toolbars.ToolBarIOReadInfo;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.prefs.Preferences;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ToolBarPersistence
implements Runnable {
    private static final String TOOLBAR_LAYOUT = "toolbar_layout";
    private ToolBarContainer container;
    private ToolBarIO io;
    private Preferences prefs;

    public ToolBarPersistence(Object mainClass, ToolBarContainer container) {
        this.container = container;
        this.io = new ToolBarIO(container);
        String nodeName = mainClass.getClass().getName().replaceFirst(String.valueOf(mainClass.getClass().getPackage().getName()) + ".", "");
        this.prefs = Preferences.userNodeForPackage(mainClass.getClass()).node(nodeName);
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    protected void handleUnloadedToolBar(VLToolBar toolbar) {
        ToolBarPanel panel = this.container.getToolBarPanelAt("North");
        if (panel != null) {
            panel.add(toolbar, new ToolBarConstraints());
        }
    }

    public void loadToolBarLayout() throws IOException, ParserConfigurationException, SAXException {
        byte[] data = this.prefs.getByteArray(TOOLBAR_LAYOUT, null);
        if (data != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ToolBarIOReadInfo tri = this.io.readXML(in);
            List unloadedToolBars = tri.getNotInstalledToolbars();
            ((InputStream)in).close();
            for (VLToolBar toolbar : unloadedToolBars) {
                this.handleUnloadedToolBar(toolbar);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.saveToolBarLayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveToolBarLayout() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.io.writeXML(out);
        out.close();
        this.prefs.putByteArray(TOOLBAR_LAYOUT, out.toByteArray());
    }
}

