/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.StringTools;

public class UppercaseSentenceStartRule
extends Rule {
    private final Language language;
    private String lastParagraphString = "";
    private static final Pattern NUMERALS_EN = Pattern.compile("[a-z]|(m{0,4}(cm|cd|d?c{0,3})(xc|xl|l?x{0,3})(ix|iv|v?i{0,3}))$");

    public UppercaseSentenceStartRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_case")));
        this.language = language;
        this.setLocQualityIssueType("typographical");
    }

    @Override
    public final String getId() {
        return "UPPERCASE_SENTENCE_START";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_uppercase_sentence");
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence text) {
        boolean languageHasSpecialCases;
        String firstDutchToken;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        if (tokens.length < 2) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int matchTokenPos = 1;
        String firstToken = tokens[matchTokenPos].getToken();
        String secondToken = null;
        String thirdToken = null;
        if (tokens.length >= 3 && ("'".equals(firstToken) || "\"".equals(firstToken) || "\u201e".equals(firstToken))) {
            matchTokenPos = 2;
            secondToken = tokens[matchTokenPos].getToken();
        }
        if ((firstDutchToken = this.dutchSpecialCase(firstToken, secondToken, tokens)) != null) {
            thirdToken = firstDutchToken;
            matchTokenPos = 3;
        }
        String checkToken = firstToken;
        if (thirdToken != null) {
            checkToken = thirdToken;
        } else if (secondToken != null) {
            checkToken = secondToken;
        }
        String lastToken = tokens[tokens.length - 1].getToken();
        if (lastToken.matches("[ \"'\u201e\u00bb\u00ab\u201c]") && tokens.length >= 2) {
            lastToken = tokens[tokens.length - 2].getToken();
        }
        boolean preventError = false;
        String langCode = this.language.getShortName();
        boolean bl = languageHasSpecialCases = langCode.equals("ru") || langCode.equals("pl") || langCode.equals("uk") || langCode.equals("be") || langCode.equals(Locale.ENGLISH.getLanguage()) || langCode.equals(Locale.ITALIAN.getLanguage()) || langCode.equals(Locale.GERMAN.getLanguage());
        if (languageHasSpecialCases) {
            if (";".equals(this.lastParagraphString) || ";".equals(lastToken) || ",".equals(this.lastParagraphString) || ",".equals(lastToken)) {
                preventError = true;
            }
            if (!lastToken.matches("[.?!\u2026]")) {
                preventError = true;
            }
        }
        this.lastParagraphString = lastToken;
        if (matchTokenPos + 1 < tokens.length && NUMERALS_EN.matcher(tokens[matchTokenPos].getToken()).matches() && (tokens[matchTokenPos + 1].getToken().equals(".") || tokens[matchTokenPos + 1].getToken().equals(")"))) {
            preventError = true;
        }
        if (this.isUrl(checkToken)) {
            preventError = true;
        }
        if (checkToken.length() > 0) {
            char firstChar = checkToken.charAt(0);
            if (!preventError && Character.isLowerCase(firstChar)) {
                RuleMatch ruleMatch = new RuleMatch(this, tokens[matchTokenPos].getStartPos(), tokens[matchTokenPos].getStartPos() + tokens[matchTokenPos].getToken().length(), this.messages.getString("incorrect_case"));
                ruleMatch.setSuggestedReplacement(StringTools.uppercaseFirstChar(checkToken));
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private String dutchSpecialCase(String firstToken, String secondToken, AnalyzedTokenReadings[] tokens) {
        if (!this.language.getShortName().equals("nl")) {
            return null;
        }
        if (tokens.length >= 3 && firstToken.equals("'") && secondToken.matches("k|m|n|r|s|t")) {
            return tokens[3].getToken();
        }
        return null;
    }

    @Override
    public void reset() {
    }

    protected boolean isUrl(String token) {
        for (String protocol : WordTokenizer.getProtocols()) {
            if (!token.startsWith(protocol + "://")) continue;
            return true;
        }
        return false;
    }
}

