/*
 * Decompiled with CFR 0.152.
 */
package morfologik.speller;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import morfologik.fsa.FSA;
import morfologik.fsa.FSATraversal;
import morfologik.fsa.MatchResult;
import morfologik.speller.HMatrix;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryMetadata;
import morfologik.util.BufferUtils;

public class Speller {
    private final int editDistance;
    private int e_d;
    private final HMatrix H;
    public static int MAX_WORD_LENGTH = 120;
    private char[] candidate;
    private int candLen;
    private int wordLen;
    private char[] word_ff;
    private final List<CandidateData> candidates = new ArrayList<CandidateData>();
    private boolean containsSeparators = true;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(MAX_WORD_LENGTH);
    private CharBuffer charBuffer = CharBuffer.allocate(MAX_WORD_LENGTH);
    private final MatchResult matchResult = new MatchResult();
    private final DictionaryMetadata dictionaryMetadata;
    private final CharsetEncoder encoder;
    protected final CharsetDecoder decoder;
    private final FSATraversal matcher;
    private final int rootNode;
    protected final FSA fsa;

    public Speller(Dictionary dictionary) {
        this(dictionary, 1);
    }

    public Speller(Dictionary dictionary, int editDistance) {
        this(dictionary, editDistance, true);
    }

    public Speller(Dictionary dictionary, int editDistance, boolean convertCase) {
        this.editDistance = editDistance;
        this.H = new HMatrix(editDistance, MAX_WORD_LENGTH);
        this.dictionaryMetadata = dictionary.metadata;
        this.rootNode = dictionary.fsa.getRootNode();
        this.fsa = dictionary.fsa;
        this.matcher = new FSATraversal(this.fsa);
        if (this.rootNode == 0) {
            throw new IllegalArgumentException("Dictionary must have at least the root node.");
        }
        if (this.dictionaryMetadata == null) {
            throw new IllegalArgumentException("Dictionary metadata must not be null.");
        }
        try {
            Charset charset = Charset.forName(this.dictionaryMetadata.encoding);
            this.encoder = charset.newEncoder();
            this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException("FSA's encoding charset is not supported: " + this.dictionaryMetadata.encoding);
        }
        try {
            CharBuffer decoded = this.decoder.decode(ByteBuffer.wrap(new byte[]{this.dictionaryMetadata.separator}));
            if (decoded.remaining() != 1) {
                throw new RuntimeException("FSA's separator byte takes more than one character after conversion  of byte 0x" + Integer.toHexString(this.dictionaryMetadata.separator) + " using encoding " + this.dictionaryMetadata.encoding);
            }
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("FSA's separator character cannot be decoded from byte value 0x" + Integer.toHexString(this.dictionaryMetadata.separator) + " using encoding " + this.dictionaryMetadata.encoding, e);
        }
    }

    private ByteBuffer charsToBytes(CharBuffer chars, ByteBuffer bytes) {
        bytes.clear();
        int maxCapacity = (int)((float)chars.remaining() * this.encoder.maxBytesPerChar());
        if (bytes.capacity() <= maxCapacity) {
            bytes = ByteBuffer.allocate(maxCapacity);
        }
        chars.mark();
        this.encoder.reset();
        if (this.encoder.encode(chars, bytes, true).isError()) {
            bytes.clear();
        }
        bytes.flip();
        chars.reset();
        return bytes;
    }

    private ByteBuffer CharSequenceToBytes(CharSequence word) {
        this.charBuffer.clear();
        this.charBuffer = BufferUtils.ensureCapacity(this.charBuffer, word.length());
        for (int i = 0; i < word.length(); ++i) {
            char chr = word.charAt(i);
            this.charBuffer.put(chr);
        }
        this.charBuffer.flip();
        this.byteBuffer = this.charsToBytes(this.charBuffer, this.byteBuffer);
        return this.byteBuffer;
    }

    public boolean isInDictionary(CharSequence word) {
        this.byteBuffer = this.CharSequenceToBytes(word);
        MatchResult match = this.matcher.match(this.matchResult, this.byteBuffer.array(), 0, this.byteBuffer.remaining(), this.rootNode);
        if (match.kind == 0) {
            this.containsSeparators = false;
            return true;
        }
        byte separator = this.dictionaryMetadata.separator;
        return this.containsSeparators && match.kind == -4 && this.fsa.getArc(match.node, separator) != 0;
    }

    public List<String> replaceRunOnWords(String original) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (!this.isInDictionary(original)) {
            String ch = original;
            for (int i = 2; i < ch.length(); ++i) {
                CharSequence firstCh = ch.subSequence(0, i);
                if (!this.isInDictionary(firstCh) || !this.isInDictionary(ch.subSequence(i, ch.length()))) continue;
                candidates.add(firstCh + " " + ch.subSequence(i, ch.length()));
            }
        }
        return candidates;
    }

    public List<String> findReplacements(String word) throws CharacterCodingException {
        this.candidates.clear();
        if (!this.isInDictionary(word) && word.length() < MAX_WORD_LENGTH) {
            this.word_ff = word.toCharArray();
            this.wordLen = this.word_ff.length;
            this.candidate = new char[MAX_WORD_LENGTH];
            this.candLen = this.candidate.length;
            this.e_d = this.wordLen <= this.editDistance ? this.wordLen - 1 : this.editDistance;
            this.charBuffer = BufferUtils.ensureCapacity(this.charBuffer, MAX_WORD_LENGTH);
            this.byteBuffer = BufferUtils.ensureCapacity(this.byteBuffer, MAX_WORD_LENGTH);
            this.charBuffer.clear();
            this.byteBuffer.clear();
            byte[] prevBytes = new byte[]{};
            this.findRepl(0, this.fsa.getRootNode(), prevBytes);
        }
        Collections.sort(this.candidates);
        ArrayList<String> candStringList = new ArrayList<String>(this.candidates.size());
        for (CandidateData cd : this.candidates) {
            candStringList.add(cd.getWord());
        }
        return candStringList;
    }

    private void findRepl(int depth, int node, byte[] prevBytes) throws CharacterCodingException {
        int dist = 0;
        int arc = this.fsa.getFirstArc(node);
        while (arc != 0) {
            this.byteBuffer = BufferUtils.ensureCapacity(this.byteBuffer, prevBytes.length + 1);
            this.byteBuffer.clear();
            this.byteBuffer.put(prevBytes);
            this.byteBuffer.put(this.fsa.getArcLabel(arc));
            int bufPos = this.byteBuffer.position();
            this.byteBuffer.flip();
            this.decoder.reset();
            CoderResult c = this.decoder.decode(this.byteBuffer, this.charBuffer, true);
            if (c.isMalformed()) {
                byte[] prev = new byte[bufPos];
                this.byteBuffer.position(0);
                this.byteBuffer.get(prev);
                if (!this.fsa.isArcTerminal(arc)) {
                    this.findRepl(depth, this.fsa.getEndNode(arc), prev);
                }
                this.byteBuffer.clear();
            } else if (!c.isError()) {
                this.charBuffer.flip();
                this.candidate[depth] = this.charBuffer.get();
                this.charBuffer.clear();
                this.byteBuffer.clear();
                if (this.cuted(depth) <= this.e_d) {
                    if (Math.abs(this.wordLen - 1 - depth) <= this.e_d && (dist = this.ed(this.wordLen - 1, depth)) <= this.e_d && (this.fsa.isArcFinal(arc) || this.isBeforeSeparator(arc))) {
                        this.addCandidate(depth, dist);
                    }
                    if (!this.fsa.isArcTerminal(arc)) {
                        this.findRepl(depth + 1, this.fsa.getEndNode(arc), new byte[0]);
                    }
                }
            }
            arc = this.fsa.getNextArc(arc);
        }
    }

    private boolean isBeforeSeparator(int arc) {
        if (this.containsSeparators) {
            int arc1 = this.fsa.getArc(this.fsa.getEndNode(arc), this.dictionaryMetadata.separator);
            return arc1 != 0 && !this.fsa.isArcTerminal(arc1);
        }
        return false;
    }

    private void addCandidate(int depth, int dist) throws CharacterCodingException {
        StringBuilder sb = new StringBuilder(depth);
        sb.append(this.candidate, 0, depth + 1);
        this.candidates.add(new CandidateData(sb.toString(), dist));
    }

    public int ed(int i, int j) {
        int result;
        if (this.word_ff[i] == this.candidate[j]) {
            result = this.H.get(i, j);
        } else if (i > 0 && j > 0 && this.word_ff[i] == this.candidate[j - 1] && this.word_ff[i - 1] == this.candidate[j]) {
            int a = this.H.get(i - 1, j - 1);
            int b = this.H.get(i + 1, j);
            int c = this.H.get(i, j + 1);
            result = 1 + this.min(a, b, c);
        } else {
            int a = this.H.get(i, j);
            int b = this.H.get(i + 1, j);
            int c = this.H.get(i, j + 1);
            result = 1 + this.min(a, b, c);
        }
        this.H.set(i + 1, j + 1, result);
        return result;
    }

    public int cuted(int depth) {
        int l = Math.max(0, depth - this.e_d);
        int u = Math.min(this.wordLen - 1, depth + this.e_d);
        int min_ed = this.e_d + 1;
        for (int i = l; i <= u; ++i) {
            int d = this.ed(i, depth);
            if (d >= min_ed) continue;
            min_ed = d;
        }
        return min_ed;
    }

    private int min(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }

    public void setWordAndCandidate(String word, String candidate) {
        this.word_ff = word.toCharArray();
        this.wordLen = this.word_ff.length;
        this.candidate = candidate.toCharArray();
        this.candLen = this.candidate.length;
        this.e_d = this.wordLen <= this.editDistance ? this.wordLen - 1 : this.editDistance;
    }

    public final int getWordLen() {
        return this.wordLen;
    }

    public final int getCandLen() {
        return this.candLen;
    }

    public final int getEffectiveED() {
        return this.e_d;
    }

    private class CandidateData
    implements Comparable<CandidateData> {
        private final String word;
        private final int distance;

        CandidateData(String word, int distance) {
            this.word = word;
            this.distance = distance;
        }

        final String getWord() {
            return this.word;
        }

        final int getDistance() {
            return this.distance;
        }

        @Override
        public int compareTo(CandidateData cd) {
            return cd.getDistance() > this.distance ? -1 : (cd.getDistance() == this.distance ? 0 : 1);
        }
    }
}

