/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.tinysegmenter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.moraleboost.io.CodePointReader;
import net.moraleboost.tinysegmenter.TinySegmenterConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinySegmenter {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_MAX_TOKEN_SIZE = 255;
    private static final Set<Integer> CHINESE_NUMBER_SET = Collections.unmodifiableSet(new HashSet<Integer>(){
        {
            this.addAll(TinySegmenter.getCodePoints("\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u5104\u5146"));
        }
    });
    private CodePointReader reader;
    private boolean eos = false;
    private int eosCount = 0;
    private CharInfo[] buffer;
    private int end = 0;
    private int position = 0;
    private boolean done = false;
    private String p1 = "U";
    private String p2 = "U";
    private String p3 = "U";
    private CharInfo[] tokenBuffer;
    private int tokenPosition = 0;

    private static String getCharType(int cp) {
        if (CHINESE_NUMBER_SET.contains(cp)) {
            return "M";
        }
        if (19968 <= cp && cp <= 40864 || cp == 12293 || cp == 12294 || cp == 12533 || cp == 12534) {
            return "H";
        }
        if (12353 <= cp && cp <= 12435) {
            return "I";
        }
        if (12449 <= cp && cp <= 12532 || cp == 12540 || 65393 <= cp && cp <= 65438 || cp == 65392) {
            return "K";
        }
        if (97 <= cp && cp <= 122 || 65 <= cp && cp <= 90 || 65345 <= cp && cp <= 65370 || 65313 <= cp && cp <= 65338) {
            return "A";
        }
        if (48 <= cp && cp <= 57 || 65296 <= cp && cp <= 65305) {
            return "N";
        }
        return "O";
    }

    private static List<Integer> getCodePoints(String str) {
        int count = str.codePointCount(0, str.length());
        ArrayList<Integer> result = new ArrayList<Integer>(count);
        int charIndex = 0;
        while (charIndex < str.length()) {
            int cp = str.codePointAt(charIndex);
            result.add(cp);
            charIndex += Character.charCount(cp);
        }
        return result;
    }

    public TinySegmenter(CodePointReader reader) {
        this(reader, 4096, 255);
    }

    public TinySegmenter(CodePointReader reader, int bufferSize, int maxTokenSize) {
        assert (bufferSize > 6);
        assert (maxTokenSize > 1);
        this.reader = reader;
        this.buffer = new CharInfo[bufferSize];
        this.tokenBuffer = new CharInfo[maxTokenSize];
    }

    public CharInfo readChar() throws IOException {
        CharInfo c;
        block8: {
            block7: {
                c = new CharInfo();
                if (this.eos) {
                    c.start = -1L;
                    c.end = -1L;
                    c.cp = -1;
                } else {
                    c.start = this.reader.getPosition();
                    c.cp = this.reader.read();
                    c.end = this.reader.getPosition();
                }
                if (c.cp >= 0) break block7;
                this.eos = true;
                switch (this.eosCount) {
                    case 0: {
                        c.str = "E1";
                        c.ctype = "O";
                        ++this.eosCount;
                        break block8;
                    }
                    case 1: {
                        c.str = "E2";
                        c.ctype = "O";
                        ++this.eosCount;
                        break block8;
                    }
                    case 2: {
                        c.str = "E3";
                        c.ctype = "O";
                        ++this.eosCount;
                        break block8;
                    }
                    default: {
                        return null;
                    }
                }
            }
            c.str = new String(Character.toChars(c.cp));
            c.ctype = TinySegmenter.getCharType(c.cp);
        }
        return c;
    }

    private void initBuffer() {
        CharInfo c = new CharInfo();
        c.cp = 0;
        c.str = "B3";
        c.ctype = "O";
        c.start = -1L;
        c.end = -1L;
        this.buffer[0] = c;
        c = new CharInfo();
        c.cp = 0;
        c.str = "B2";
        c.ctype = "O";
        c.start = -1L;
        c.end = -1L;
        this.buffer[1] = c;
        c = new CharInfo();
        c.cp = 0;
        c.str = "B1";
        c.ctype = "O";
        c.start = -1L;
        c.end = -1L;
        this.buffer[2] = c;
        this.end = 3;
        this.position = 3;
    }

    private int fillBuffer() throws IOException {
        int src = this.end - 6;
        int dst = 0;
        if (src < 0) {
            src = 0;
        }
        while (src < this.end) {
            this.buffer[dst++] = this.buffer[src++];
        }
        int start = dst;
        this.end = dst;
        this.position = 3;
        while (this.end < this.buffer.length) {
            CharInfo c = this.readChar();
            if (c == null) break;
            this.buffer[this.end++] = c;
        }
        return this.end - start;
    }

    public Token next() throws IOException {
        if (this.done) {
            return null;
        }
        if (this.end <= 0) {
            this.initBuffer();
            if (this.fillBuffer() > 3) {
                this.tokenBuffer[this.tokenPosition++] = this.buffer[this.position++];
            } else {
                this.done = true;
                return null;
            }
        }
        Token token = null;
        while (true) {
            if (this.position < this.end - 3) {
                if (this.isBoundary()) {
                    if (this.tokenPosition <= 0) continue;
                    token = this.makeToken();
                    this.tokenBuffer[this.tokenPosition++] = this.buffer[this.position++];
                } else {
                    this.tokenBuffer[this.tokenPosition++] = this.buffer[this.position++];
                    if (this.tokenPosition < this.tokenBuffer.length) continue;
                    token = this.makeToken();
                }
            }
            if (token != null || this.fillBuffer() <= 0) break;
        }
        if (token == null) {
            this.done = true;
            token = this.makeToken();
        }
        return token;
    }

    private Token makeToken() {
        Token token = new Token();
        StringBuilder builder = new StringBuilder();
        token.start = this.tokenBuffer[0].start;
        int i = 0;
        while (i < this.tokenPosition) {
            builder.append(this.tokenBuffer[i].str);
            token.end = this.tokenBuffer[i].end;
            ++i;
        }
        token.str = builder.toString();
        this.tokenPosition = 0;
        return token;
    }

    private boolean isBoundary() {
        int score = -332;
        CharInfo c1 = this.buffer[this.position - 3];
        CharInfo c2 = this.buffer[this.position - 2];
        CharInfo c3 = this.buffer[this.position - 1];
        CharInfo c4 = this.buffer[this.position];
        CharInfo c5 = this.buffer[this.position + 1];
        CharInfo c6 = this.buffer[this.position + 2];
        score += this.getScore(TinySegmenterConstants.UP1, this.p1);
        score += this.getScore(TinySegmenterConstants.UP2, this.p2);
        score += this.getScore(TinySegmenterConstants.UP3, this.p3);
        score += this.getScore(TinySegmenterConstants.BP1, String.valueOf(this.p1) + this.p2);
        score += this.getScore(TinySegmenterConstants.BP2, String.valueOf(this.p2) + this.p3);
        score += this.getScore(TinySegmenterConstants.UW1, c1.str);
        score += this.getScore(TinySegmenterConstants.UW2, c2.str);
        score += this.getScore(TinySegmenterConstants.UW3, c3.str);
        score += this.getScore(TinySegmenterConstants.UW4, c4.str);
        score += this.getScore(TinySegmenterConstants.UW5, c5.str);
        score += this.getScore(TinySegmenterConstants.UW6, c6.str);
        score += this.getScore(TinySegmenterConstants.BW1, String.valueOf(c2.str) + c3.str);
        score += this.getScore(TinySegmenterConstants.BW2, String.valueOf(c3.str) + c4.str);
        score += this.getScore(TinySegmenterConstants.BW3, String.valueOf(c4.str) + c5.str);
        score += this.getScore(TinySegmenterConstants.TW1, String.valueOf(c1.str) + c2.str + c3.str);
        score += this.getScore(TinySegmenterConstants.TW2, String.valueOf(c2.str) + c3.str + c4.str);
        score += this.getScore(TinySegmenterConstants.TW3, String.valueOf(c3.str) + c4.str + c5.str);
        score += this.getScore(TinySegmenterConstants.TW4, String.valueOf(c4.str) + c5.str + c6.str);
        score += this.getScore(TinySegmenterConstants.UC1, c1.ctype);
        score += this.getScore(TinySegmenterConstants.UC2, c2.ctype);
        score += this.getScore(TinySegmenterConstants.UC3, c3.ctype);
        score += this.getScore(TinySegmenterConstants.UC4, c4.ctype);
        score += this.getScore(TinySegmenterConstants.UC5, c5.ctype);
        score += this.getScore(TinySegmenterConstants.UC6, c6.ctype);
        score += this.getScore(TinySegmenterConstants.BC1, String.valueOf(c2.ctype) + c3.ctype);
        score += this.getScore(TinySegmenterConstants.BC2, String.valueOf(c3.ctype) + c4.ctype);
        score += this.getScore(TinySegmenterConstants.BC3, String.valueOf(c4.ctype) + c5.ctype);
        score += this.getScore(TinySegmenterConstants.TC1, String.valueOf(c1.ctype) + c2.ctype + c3.ctype);
        score += this.getScore(TinySegmenterConstants.TC2, String.valueOf(c2.ctype) + c3.ctype + c4.ctype);
        score += this.getScore(TinySegmenterConstants.TC3, String.valueOf(c3.ctype) + c4.ctype + c5.ctype);
        score += this.getScore(TinySegmenterConstants.TC4, String.valueOf(c4.ctype) + c5.ctype + c6.ctype);
        score += this.getScore(TinySegmenterConstants.UQ1, String.valueOf(this.p1) + c1.ctype);
        score += this.getScore(TinySegmenterConstants.UQ2, String.valueOf(this.p2) + c2.ctype);
        score += this.getScore(TinySegmenterConstants.UQ3, String.valueOf(this.p3) + c3.ctype);
        score += this.getScore(TinySegmenterConstants.BQ1, String.valueOf(this.p2) + c2.ctype + c3.ctype);
        score += this.getScore(TinySegmenterConstants.BQ2, String.valueOf(this.p2) + c3.ctype + c4.ctype);
        score += this.getScore(TinySegmenterConstants.BQ3, String.valueOf(this.p3) + c2.ctype + c3.ctype);
        score += this.getScore(TinySegmenterConstants.BQ4, String.valueOf(this.p3) + c3.ctype + c4.ctype);
        score += this.getScore(TinySegmenterConstants.TQ1, String.valueOf(this.p2) + c1.ctype + c2.ctype + c3.ctype);
        score += this.getScore(TinySegmenterConstants.TQ2, String.valueOf(this.p2) + c2.ctype + c3.ctype + c4.ctype);
        score += this.getScore(TinySegmenterConstants.TQ3, String.valueOf(this.p3) + c1.ctype + c2.ctype + c3.ctype);
        boolean result = false;
        String p = "O";
        if ((score += this.getScore(TinySegmenterConstants.TQ4, String.valueOf(this.p3) + c2.ctype + c3.ctype + c4.ctype)) > 0) {
            p = "B";
            result = true;
        }
        this.p1 = this.p2;
        this.p2 = this.p3;
        this.p3 = p;
        return result;
    }

    private int getScore(Map<String, Integer> m, String key) {
        Integer s = m.get(key);
        return s != null ? s : 0;
    }

    public static class CharInfo {
        public int cp;
        public String str;
        public String ctype;
        public long start;
        public long end;
    }

    public static class Token {
        public String str;
        public long start;
        public long end;

        public boolean equals(Object obj) {
            if (!(obj instanceof Token)) {
                return false;
            }
            Token another = (Token)obj;
            return (this.str == null ? another.str == null : this.str.equals(another.str)) && this.start == another.start && this.end == another.end;
        }

        public String toString() {
            return "(" + this.str + "," + Long.toString(this.start) + "," + Long.toString(this.end) + ")";
        }
    }
}

