/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class ProgressWindow
extends JFrame
implements ActionListener {
    private final Timer timer;
    private final int millisToPopup = 2000;
    private final int millisToDecidePopup = 500;
    private boolean mustPopUp = false;
    private boolean maxIsSet = false;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private JPanel jPanel1;
    private JLabel label;
    private JProgressBar progressBar;

    public ProgressWindow() {
        this.initComponents();
        this.timer = new Timer(500, this);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void setMaximum(int max) {
        this.maxIsSet = true;
        this.progressBar.setMaximum(max);
    }

    public void setValue(int value) {
        if (!this.maxIsSet) {
            throw new UnsupportedOperationException("Must set maximum before setting value.");
        }
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(value);
    }

    public void setMustPopup(boolean mustPopUp) {
        this.mustPopUp = mustPopUp;
    }

    public void setMessage(String text) {
        this.label.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ProgressWindow popup = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProgressWindow.this.shouldShowPopup()) {
                    GuiUtil.displayWindowCentered(popup);
                }
            }
        });
    }

    private boolean shouldShowPopup() {
        int current;
        if (this.mustPopUp || this.progressBar.isIndeterminate() || this.progressBar.getValue() == 0) {
            return true;
        }
        if (this.progressBar.getValue() == this.progressBar.getMaximum()) {
            return false;
        }
        int min = this.progressBar.getMinimum();
        int max = this.progressBar.getMaximum();
        int required = (max - min) / ((current = this.progressBar.getValue()) - min) * this.timer.getInitialDelay();
        return required > 2000;
    }

    private void initComponents() {
        this.filler1 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, 0));
        this.filler3 = new Box.Filler(new Dimension(0, 10), new Dimension(0, 10), new Dimension(0, 10));
        this.filler2 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, 0));
        this.filler4 = new Box.Filler(new Dimension(0, 10), new Dimension(0, 10), new Dimension(0, 10));
        this.jPanel1 = new JPanel();
        this.label = new JLabel();
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle(LocString.get("STM_PROGRESS_WINDOW_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressWindow.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().add((Component)this.filler1, "West");
        this.getContentPane().add((Component)this.filler3, "North");
        this.getContentPane().add((Component)this.filler2, "East");
        this.getContentPane().add((Component)this.filler4, "Last");
        this.jPanel1.setLayout(new GridLayout(0, 1));
        this.label.setText(LocString.get("STM_PROGRESS_WINDOW_LABEL"));
        this.jPanel1.add(this.label);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setPreferredSize(new Dimension(300, 14));
        this.jPanel1.add(this.progressBar);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
    }
}

