/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.segment.srx.SrxDocument;
import net.sourceforge.segment.srx.SrxTextIterator;
import net.sourceforge.segment.srx.io.Srx2SaxParser;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.tokenizers.SentenceTokenizer;

public class SRXSentenceTokenizer
extends SentenceTokenizer {
    private static final String RULES = "/segment.srx";
    private static final SrxDocument document = SRXSentenceTokenizer.createSrxDocument();
    private final String languageCode;
    private String parCode;

    private static SrxDocument createSrxDocument() {
        SrxDocument srxDocument;
        BufferedReader srxReader = null;
        try {
            SrxDocument document;
            srxReader = new BufferedReader(new InputStreamReader(JLanguageTool.getDataBroker().getFromResourceDirAsStream(RULES), "utf-8"));
            HashMap<String, Boolean> parserParameters = new HashMap<String, Boolean>();
            parserParameters.put("validate", true);
            Srx2SaxParser srxParser = new Srx2SaxParser(parserParameters);
            srxDocument = document = srxParser.parse((Reader)srxReader);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not load rules /segment.srx from resource dir " + JLanguageTool.getDataBroker().getResourceDir(), e);
            }
            catch (Throwable throwable) {
                SRXSentenceTokenizer.closeQuietly(srxReader);
                throw throwable;
            }
        }
        SRXSentenceTokenizer.closeQuietly(srxReader);
        return srxDocument;
    }

    private static void closeQuietly(BufferedReader srxReader) {
        if (srxReader != null) {
            try {
                srxReader.close();
            }
            catch (IOException e) {
                System.err.println("Error closing SRX file reader.");
            }
        }
    }

    public SRXSentenceTokenizer(Language language) {
        this.languageCode = language.getShortName();
        this.setSingleLineBreaksMarksParagraph(false);
    }

    @Override
    public final List<String> tokenize(String text) {
        ArrayList<String> segments = new ArrayList<String>();
        SrxTextIterator textIterator = new SrxTextIterator(document, this.languageCode + this.parCode, (CharSequence)text);
        while (textIterator.hasNext()) {
            segments.add(textIterator.next());
        }
        return segments;
    }

    @Override
    public final boolean singleLineBreaksMarksPara() {
        return "_one".equals(this.parCode);
    }

    @Override
    public final void setSingleLineBreaksMarksParagraph(boolean lineBreakParagraphs) {
        this.parCode = lineBreakParagraphs ? "_one" : "_two";
    }
}

