/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2020 Thomas CORDONNIER
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external.lucene;

import java.util.*;
import java.io.*;
import java.text.*;

import org.omegat.tokenizer.BaseTokenizer; 
import org.omegat.gui.glossary.GlossaryEntry;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Field.TermVector;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.analysis.Analyzer;

public class LuceneGlossaryWriter {

    private IndexWriter indexWriter;
    private Analyzer analyzer;
    private File indexDir;

    public LuceneGlossaryWriter(File indexDirectory, Analyzer analyser, boolean createNewIndex) throws IOException {
        indexDir = indexDirectory;
        indexWriter = new IndexWriter(FSDirectory.open(indexDirectory), this.analyzer = analyser, createNewIndex, IndexWriter.MaxFieldLength.UNLIMITED);
    }
    
    /*
    public LuceneGlossaryWriter(File indexDirectory, BaseTokenizer tokenizer, boolean createNewIndex) throws IOException {
        indexDir = indexDirectory;
        indexWriter = new IndexWriter(FSDirectory.open(indexDirectory), this.analyzer = tokenizer.getAnalyser(), createNewIndex, IndexWriter.MaxFieldLength.UNLIMITED);
    }
    */
        
    public void indexAll (Iterable<GlossaryEntry> entries) throws Exception {
        try {
            for (GlossaryEntry en: entries) {
                Document doc = createDocument(en);
                if (doc != null) indexWriter.addDocument(doc);
            }
        } finally {
            try {
                indexWriter.commit();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    
    public void close() throws Exception {
        indexWriter.close();
    }
    
    public Document createDocument(GlossaryEntry gen) {
        Document doc = new Document();
        doc.add (new Field("src", gen.getSrcText(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, TermVector.YES));
        if (gen.getLocText() != null) doc.add (new Field("tra", gen.getLocText(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        //if (gen.getCommentText() != null) doc.add (new Field("comment", gen.getLocText(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        return doc;
    }
    
}
