/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2015 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;


/**
 * An external provider (memory, glossary, ...) which can be included in the search window (project search only, not replacement or directory search).
 * 
 * The <code>search</code> method may really do a search in the memory or return everything and let the Searcher do the filtering.
 * Note that the algorithm used by the plugin may have a different behaviour than what OmegaT's Searcher does:
 * ideally, the plugin should try to be as close as possible (for example, considering strings instead of words) 
 * but it may ignore some parameters from the search expression, which will be in this case used by the searcher.
 * 
 * @author Thomas Cordonnier
 */
public interface ISearchable<T> {

    /** 
	 * Tries to send all parameters to the search engine.
	 * If some of them are not understood by the engine, simply ignore them: let OmegaT do the filtering again.
	 **/
    public Iterable<T> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch,
        TextExpression author, // NOTE: does not take DGT-specific "translator" fields, because they would be meaningless for external providers
        long dateAfter, long dateBefore) throws Exception;
    
}
