/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2013 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external;

import java.util.List;

import org.omegat.core.data.ITMXEntry;
import org.omegat.util.Language;

/**
 * Interface for external translation memories (MyMemory, ...)
 * 
 * @author Thomas Cordonnier
 */
public interface IExternalMemory {
    /**
     * Get the name of the provider (or engine). <br>
     * In a project you can have more than one instance of the same engine, in which case all have same result for this method
     * but a different result in {getMemoryName()}
     */
    String getProviderName();


    /**
     * Get memory name, to replace the file name when displayed inside matches pane.
     * In a project you can have more than one instance of the same engine, in which case all have same result for {getProviderName()}
     * but a different result for this method.
     */
    String getMemoryName();
    
    /**
     * Returns matching TMX entries
     * 
     * @param sLang
     *            source language
     * @param tLang
     *            target language
     * @param text
     *            text for translation
     * @param minScore
     *            the minimum score for a result to be valid (calculated by the provider, should be different from OmegaT's levenstein)
     *            (provided for optimisation purposes, the provider is not required to use this information)
     * @param maxCount
     *            the maximum results which may be used
     *            (provided for optimisation purposes, the provider is not required to use this information)
     * @return an array of TMX entries, with all necessary info to be displayed in matches pane
     */
    Iterable<? extends ITMXEntry> findMatchingTranslations (Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception;
}
