/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2020 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external;

import org.omegat.core.Core;
import org.omegat.core.matching.external.ProjectMemory.ContextTMXEntry;

import java.util.*;
import java.io.*;

/**
 * This project provider ensures that your recent segments will not be lost 
 * if OmegaT is stopped in a way which did not enable saving
 * 
 * @author Thomas CORDONNIER
 */
public class NoDelaySaver implements ProjectMemory.IExternalProjectMemory {

    private PrintStream out;
    
    public NoDelaySaver (java.util.Properties propList) {
    }

    /** On first call, dumps the file; next time do nothing **/
    public List<ContextTMXEntry> findChanges (long timeStamp) throws Exception {
        if (out != null) return Collections.emptyList();
        
        List<ContextTMXEntry> res = new ArrayList<>();
        File outFile = new File(Core.getProject().getProjectProperties().getProjectInternal() + "project_save.tmp");
        System.err.println("Using " + outFile + " for immediate save");
        if (outFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(outFile), "UTF-8"))) {
                String line; while ((line = reader.readLine()) != null) {
                    String[] fields = line.split("\t");
                    fields[1] = fields[1].replaceAll("\\t","\t"); fields[2] = fields[2].replaceAll("\\t","\t"); fields[7] = fields[7].replaceAll("\\t","\t"); 
                    ContextTMXEntry nEntry = new ContextTMXEntry(); res.add(nEntry);
                    nEntry.source = fields[1]; nEntry.translation = fields[2]; if (fields[2].equals("")) fields[2] = null;
                    nEntry.changer = fields[3]; nEntry.changeDate = Long.parseLong(fields[4]);
                    nEntry.creator = fields[5]; nEntry.creationDate = Long.parseLong(fields[6]);
                    nEntry.note = fields[7];
                    nEntry.isDefault = "true".equals(fields[8]);
                    nEntry.entryNum = Integer.parseInt(fields[9]);
                }
            }
            outFile.delete(); Core.getProject().saveProject();
        }
        out = new PrintStream(outFile, "UTF-8");        
        return res;
    }

    /** Also writes to the file */
    public void registerTranslation(ContextTMXEntry entry) throws Exception {
        if (out == null) return; 
        StringBuffer buf = new StringBuffer("+\t"); 
        entryToBuf(entry, buf); out.println(buf); out.flush();
    }
        
    /** Also writes to the file */
    public void removeTranslation(ContextTMXEntry entry) throws Exception {
        if (out == null) return;
        StringBuffer buf = new StringBuffer("-\t");
        entryToBuf(entry, buf); out.println(buf); out.flush();        
    }
    
    private void entryToBuf(ContextTMXEntry entry, StringBuffer buf) {
        buf.append(entry.source.replaceAll("\t","\\t")).append("\t");
        buf.append(entry.translation == null ? "" : entry.translation.replaceAll("\t","\\t")).append("\t");
        buf.append(entry.changer).append("\t");
        buf.append(entry.changeDate).append("\t");
        buf.append(entry.creator).append("\t");
        buf.append(entry.creationDate).append("\t");
        buf.append(entry.note == null ? "" : entry.note.replaceAll("\t","\\t")).append("\t");
        buf.append(entry.isDefault).append("\t");
        buf.append(entry.entryNum).append("\t");
    }

}