/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2014 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external.rmi;

import org.omegat.core.data.*;

import org.omegat.core.matching.external.ProjectMemory.ContextTMXEntry;

import java.rmi.*;
import java.util.List;

/** 
 * Implement ProjectMemory.IExternalMemory as a remote interface 
 **/
public interface IDistantExternalMemory extends Remote {

    /**
     * Returns server-side timestamp, to prevent too much difference with client-side one
     **/
    long timeStamp() throws RemoteException;


    /**
     * Fetches last modifications from the database
     * @param timeStamp		
     *		a <i>server-side</i> timestamp : 
     *			the client should take care about an eventual time-unsynchronization
     *			because the server does not know all its clients
     **/
    List<ContextTMXEntry> findChanges (long timeStamp) throws RemoteException;

    /**
     * Register current translation. This method <i>must</i> use the context from the entry.
     */
    void registerTranslation(ContextTMXEntry entry) throws RemoteException;
        
    /**
     * Removes the entry with the following source, translation and properties.
     */
    void removeTranslation(ContextTMXEntry entry) throws RemoteException;
    
}
