/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2010 Antonio Vilei
               2014 Piotr Kulik, Thomas Cordonnier
               2016 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import java.util.Date;
import java.util.List;

import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.OStrings;
import org.omegat.util.TMXProp;
import org.omegat.util.OStrings;

/**
 * Storage for a search result entry coming from glossary
 * 
 * @author Antonio Vilei
 * @author Thomas Cordonnier
 */
public class GlossarySearchResultEntry extends FullSearchResultEntry {

    /**
     * Creates a new search result entry with properties set to given values.
     */
    public GlossarySearchResultEntry(GlossaryEntry en,
            List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        super(srcMatch, targetMatch, noteMatch);
        m_entry = en;
    }

    /**
     * Returns the number of the corresponding entry within a project. The
     * returned value is < 0 
     */
    public int getEntryNum() {
        return -1;
    }

    /** Returns information about where this entry comes from. */
    public String getPreamble() {
        return OStrings.getString("SW_GLOSSARY_RESULT") + getMoreString();
    }
    
    /** Returns the source text of the corresponding entry within a project. */
    public String getSrcText() {
        return m_entry.getSrcText();
    }

    /** Returns the target text of the corresponding entry within a project. */
    public String getTranslation() {
        return m_entry.getLocText();
    }

    /** Returns the note text of the corresponding entry within a project. */
    public String getNote() {
        return m_entry.getCommentText();
    }

    public String getFileName() {
        return OStrings.getString("SW_GLOSSARY_RESULT");
    }
    
    public String getAuthor() {
        return null;
    }

    public String getRevisor () {
        return null;
    }

    public Date getDate() {
        return null;
    }

    public List<TMXProp> getProperties() {
        return java.util.Collections.emptyList();
    }

    private GlossaryEntry m_entry;
}
