/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2012 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import org.omegat.core.data.ITranslationEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.glossary.GlossaryEntry;

/**
 * This class indicates what we do with translated and untranslated segments.
 * Can be used as an enum or as bitfields
 * 
 * @author Thomas Cordonnier
 */
public enum TranslationStateFilter {
    TRANSLATED_ONLY(1), 	// (FLAG_TRANSLATED),
    UNTRANSLATED_ONLY(2),	// (FLAG_UNTRANSLATED),
    TRANSLATED_AND_UNTRANSLATED(3); // (FLAG_TRANSLATED + FLAG_UNTRANSLATED);
    
    public static final int FLAG_TRANSLATED = 1;
    public static final int FLAG_UNTRANSLATED = 2;
        
    public final int value;
    private TranslationStateFilter(int value) {
        this.value = value;
    }

    public boolean isValid (String entry) {
        if (entry != null) return (this.value & FLAG_TRANSLATED) > 0;
        else return (this.value & FLAG_UNTRANSLATED) > 0;
    }
    
    public boolean isValidEntry (ITranslationEntry entry) {
        if (entry.isTranslated()) return (this.value & FLAG_TRANSLATED) > 0;
        else return (this.value & FLAG_UNTRANSLATED) > 0;
    }
    
    public boolean isValidEntry (SourceTextEntry entry) {
        String translation = entry.getSourceTranslation();
        if ((translation != null) && (translation.length() > 0)) return (this.value & FLAG_TRANSLATED) > 0;
        else return (this.value & FLAG_UNTRANSLATED) > 0;
    }
}
