/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2011 Alex Buloichik
               2017-2019 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.filters2;

import org.omegat.core.data.PrepareTMXEntry;

/**
 * Callback for translate files.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 * @author Thomas Cordonnier
 */
public interface ITranslateCallback {
    /**
     * Set current pass number
     * 
     * Any filter called in one-pass mode by default. But if it require second pass for support prev/next
     * segments, it can set flag 'needSecondPass'.
     * @param pass The current path number, i.e., 1 or 2
     */
    void setPass(int pass);

    /**
     * This method called from AbstractFilter if filter require second pass. It links prev/next segments for
     * multiple translations.
     */
    void linkPrevNextSegments();

    /**
     * Get translation for output to compiled target.
     * 
     * @param id
     *            ID in source file, or null if ID not supported by format
     * @param source
     *            source entry text
     * @param path
     *            path of segment
     * @return translation or null if translation not exist
     */
    String getTranslation(String id, String source, String path);

    /**
     * Old call without path, for compatibility
     * @param id
     *              ID in source file, or null if ID not supported by format
     * @param source
     *              source entry text
     * @return translation or null if translation not exist
     */
    String getTranslation(String id, String source);

    /**
     * Get note for given entry : used if the format has capacity to contain notes
     * 
     * @param id
     *            ID in source file, or null if ID not supported by format
     * @param source
     *            source entry text
     * @param path
     *            path of segment
     * @return note or null if note not exist
     */
    default String getNote(String id, String source, String path) { return null; }

    /**
     * Get translation entry, trying to set author and date if possible
     * 
     * @param id
     *            ID in source file, or null if ID not supported by format
     * @param source
     *            source entry text
     * @param path
     *            path of segment
     * @return entry, or null if translation not exist;
	 *           if all sub-entries share same author, also set author and date to most recently set
     */
    default PrepareTMXEntry getTranslationEntry(String id, String source, String path) {
		PrepareTMXEntry res = new PrepareTMXEntry();
		res.source = source; res.translation = getTranslation(id,source,path); res.note = getNote(id,source,path);
		return res;
	}
    
}
