/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.MenuMemory;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.TMXReader2;

public class MyMemory
extends MenuMemory {
    private static final String MYMEMORY_API_EMAIL = "mymemory.api.email";
    protected static String GT_URL = "https://mymemory.translated.net/api/get?q=";
    protected static String GT_URL2 = "&langpair=#sourceLang#|#targetLang#&of=#format#";
    protected static String XPATH_QUERY_ALL_TU = "//tu";
    protected static String XPATH_QUERY_TUV = "child::tuv[starts-with(@lang, '#langCode#')]/seg/text()";
    public static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);

    protected String mymemoryCode(Language language) {
        String lCode = language.getLanguageCode().toLowerCase();
        return lCode;
    }

    protected String buildMyMemoryUrl(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException {
        String sourceLang = this.mymemoryCode(sLang);
        String targetLang = this.mymemoryCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang).replace("#format#", format);
        String url = GT_URL + URLEncoder.encode(text, "UTF-8") + url2;
        return url;
    }

    protected InputStream getMyMemoryResponse(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException, IOException {
        String url = this.buildMyMemoryUrl(sLang, tLang, text, format);
        String email = System.getProperty(MYMEMORY_API_EMAIL);
        if (email != null && !"".equals(email)) {
            url = url + "&de=" + email;
        }
        return new URL(url).openStream();
    }

    protected String getPreferenceName() {
        return "allow_mymemory_translation_memory";
    }

    public String getProviderName() {
        return OStrings.getString((String)"MT_ENGINE_MYMEMORY_HUMAN");
    }

    public String getMemoryName() {
        return OStrings.getString((String)"MT_ENGINE_MYMEMORY_HUMAN");
    }

    public List<PrepareTMXEntry> retreiveMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        ArrayList<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>();
        TMXReader2 reader = new TMXReader2();
        reader.readTMX(this.getMyMemoryResponse(sLang, tLang, text, "tmx"), sLang, tLang, true, false, false, false, (tu, tuvSource, tuvTarget, isParagraphSegtype) -> {
            PrepareTMXEntry entry = new PrepareTMXEntry();
            entry.source = tuvSource.text;
            entry.translation = tuvTarget.text;
            entry.creator = tuvTarget.creationid == null ? tu.creationid : tuvTarget.creationid;
            entry.creationDate = tuvTarget.creationdate == 0L ? tu.creationdate : tuvTarget.creationdate;
            entry.changer = tuvTarget.changeid == null ? tu.changeid : tuvTarget.changeid;
            entry.changeDate = tuvTarget.changedate == 0L ? tu.changedate : tuvTarget.changedate;
            entries.add(entry);
            return true;
        });
        return entries;
    }
}

