/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators.net;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.omegat.core.machinetranslators.net.AbstractMyMemoryTranslate;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MyMemoryMachineTranslate
extends AbstractMyMemoryTranslate {
    protected static String GT_URL2 = "&langpair=#sourceLang#|#targetLang#&of=#format#&mt=1";

    @Override
    protected String getPreferenceName() {
        return "allow_mymemory_machine_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString((String)"MT_ENGINE_MYMEMORY_MACHINE");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String tmxResponse = "";
        String machineTranslationMatch = "";
        tmxResponse = this.getMyMemoryResponse(sLang, tLang, text, "tmx");
        tmxResponse = tmxResponse.replace("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">", "");
        tmxResponse = tmxResponse.replace("&", "&amp;");
        tmxResponse = this.getXMLString(tmxResponse);
        InputSource source = new InputSource(new StringReader(tmxResponse));
        Document document = this.factory.newDocumentBuilder().parse(source);
        String targetLangCode = tLang.getLocaleCode().replace('_', '-').toUpperCase();
        machineTranslationMatch = this.extractMTresponse(document, targetLangCode);
        machineTranslationMatch = this.cleanSpacesAroundTags(machineTranslationMatch, text);
        return machineTranslationMatch;
    }

    private String extractMTresponse(Document document, String targetLang) {
        String MTresponse = "";
        String MTQuery = String.format("/tmx/body/tu[@creationid='MT!']/tuv[starts-with(@lang, '%s')]/seg/text()", targetLang);
        Object result = null;
        XPath xpath = this.xPathFactory.newXPath();
        try {
            XPathExpression expr = xpath.compile(MTQuery);
            result = expr.evaluate(document, XPathConstants.NODE);
            Node node = (Node)result;
            MTresponse = node.getTextContent();
        }
        catch (Exception ex) {
            MTresponse = OStrings.getString((String)"MT_ENGINE_MYMEMORY_MACHINE_ERROR") + ex.getMessage();
        }
        MTresponse = this.cleanUpText(MTresponse);
        return MTresponse;
    }

    @Override
    protected String buildMyMemoryUrl(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException {
        String sourceLang = this.mymemoryCode(sLang);
        String targetLang = this.mymemoryCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang).replace("#format#", format);
        String url = GT_URL + URLEncoder.encode(text, "UTF-8") + url2;
        return url;
    }
}

