/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class WordRepeatRule
extends Rule {
    public WordRepeatRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
        this.setLocQualityIssueType("duplication");
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        return false;
    }

    @Override
    public String getId() {
        return "WORD_REPEAT_RULE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_repetition");
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        String prevToken = "";
        for (int i = 1; i < tokens.length; ++i) {
            char c;
            String token = tokens[i].getToken();
            boolean isWord = true;
            if (token.length() == 1 && !Character.isLetter(c = token.charAt(0))) {
                isWord = false;
            }
            boolean isException = this.ignore(tokens, i);
            if (isWord && prevToken.toLowerCase().equals(token.toLowerCase()) && !isException) {
                String msg = this.messages.getString("repetition");
                int prevPos = tokens[i - 1].getStartPos();
                int pos = tokens[i].getStartPos();
                RuleMatch ruleMatch = new RuleMatch(this, prevPos, pos + prevToken.length(), msg, this.messages.getString("desc_repetition_short"));
                ruleMatch.setSuggestedReplacement(prevToken);
                ruleMatches.add(ruleMatch);
            }
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
    }
}

