/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.tm;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.core.search.TextExpression;
import org.omegat.util.Language;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.PostgresqlCyclotisTMX;
import org.silvestrislab.cyclotis.omegat.tm.SaveConditions;

public class PostgresqlMemory
extends PostgresqlCyclotisTMX<PrepareTMXEntry>
implements IWritableExternalMemory,
IBrowsableMemory {
    private SaveConditions conditions;
    private String exclude = "";
    private boolean hasAuthor = false;
    private boolean hasChanger = false;
    private boolean hasDate = false;
    private boolean hasChangeDate = false;

    public PostgresqlMemory(Properties propList) throws SQLException, ClassNotFoundException {
        super(propList);
        if (propList.getProperty("update") != null) {
            String updateString = propList.getProperty("update");
            if (!updateString.equalsIgnoreCase("false")) {
                String author;
                this.conditions = SaveConditions.forProperty(updateString);
                String table = propList.getProperty("table");
                if (table == null) {
                    table = "MEM";
                }
                if ((author = propList.getProperty("author")) == null) {
                    author = Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name"));
                }
                this.pInsert = this.getInsertStatement();
                this.pInsert.setString(3, author);
            } else {
                this.conditions = null;
            }
        } else if (propList.getProperty("table.exclude") != null) {
            ResultSet set;
            this.tableWrite = propList.getProperty("table.exclude");
            this.conditions = null;
            if (this.mem_id instanceof Integer) {
                set = this.getInfoResultSet("MEM_ID");
                if (set.next()) {
                    this.exclude = " and MEM_ID != " + set.getInt(1);
                }
                set.close();
            }
            if (this.mem_id instanceof Long) {
                set = this.getInfoResultSet("MEM_CODE");
                if (set.next()) {
                    this.exclude = " and MEM_CODE != " + set.getLong(1);
                }
                set.close();
            }
            if (this.mem_id instanceof String) {
                set = this.getInfoResultSet("MEM_PATH");
                if (set.next()) {
                    this.exclude = " and MEM_PATH != '" + set.getString(1) + "'";
                }
                set.close();
            }
        } else {
            this.conditions = null;
        }
        System.out.println(this.getMemoryName() + (this.conditions == null ? " update = false" : " update condition = " + this.conditions));
    }

    public PostgresqlMemory(PostgresqlCyclotisTMX ori) {
        super(ori);
    }

    @Override
    protected String selectCondition() {
        return "src % ?" + this.exclude;
    }

    protected final PreparedStatement selectStatement(String table) throws SQLException {
        this.logMessage("sql", "Select statement = select * from " + table + " where src % ?");
        return this.connection.prepareStatement("select * from " + table + " where src % ?");
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        this.logMessage("search", "Searching for <" + this.digest(text) + "> '" + text + "'");
        this.getSelectStatement().setString(1, this.reduceWords(text));
        return this.retreiveQuery(this.getSelectStatement());
    }

    @Override
    protected PrepareTMXEntry buildEntry(ResultSet set) throws SQLException {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        entry.source = this.reformatText(set.getString("SRC"), true);
        entry.translation = this.reformatText(set.getString("TRA"), true);
        try {
            entry.creator = set.getString("AUTHOR");
            entry.creationDate = set.getTimestamp("DATE").getTime();
            entry.changer = set.getString("CHANGER");
            entry.changeDate = set.getTimestamp("CHANGEDATE").getTime();
            entry.note = set.getString("NOTE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.col_props != null) {
            List<TMXProp> read = this.col_props.read(set.getObject("PROPS"));
            try {
                read.add(new TMXProp("db.table.name", set.getString("MEM_NAME")));
            }
            catch (Exception e1) {
                read.add(new TMXProp("db.table.name", this.tableRead));
            }
            entry.otherProperties = this.store.fromDatabase(read, entry);
        } else {
            entry.otherProperties = this.store.fromDatabase(null, entry);
        }
        this.logEntry("search-results", entry, true);
        return entry;
    }

    public boolean isWriteMode() {
        return this.conditions != null;
    }

    @Override
    protected List<String> insertFields() {
        ArrayList<String> res = new ArrayList<String>(4);
        res.add("SRC");
        res.add("TRA");
        res.add("AUTHOR");
        if (this.col_props != null) {
            res.add("PROPS");
        }
        if (this.hasNote) {
            res.add("NOTE");
        }
        if (this.contextMode != null) {
            res.add("CONTEXT");
        }
        if (this.mem_id != null) {
            if (this.mem_id instanceof Integer) {
                res.add("MEM_ID");
            } else if (this.mem_id instanceof Long) {
                res.add("MEM_CODE");
            } else if (this.mem_id instanceof String) {
                res.add("MEM_PATH");
            }
        }
        return res;
    }

    public boolean mustWrite(PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
        return this.conditions.mustWrite(this, entryContents, entrySource);
    }

    public void registerTranslation(Language sLang, Language tLang, PrepareTMXEntry entryContents, SourceTextEntry entrySource) throws Exception {
        int idx;
        if (this.col_props != null) {
            this.getInsertStatement().setObject(4, this.col_props.write(this.store.toDatabase(entryContents, entrySource)));
        }
        if (this.hasNote) {
            int n = idx = this.col_props == null ? 4 : 5;
            if (entryContents.note == null) {
                this.getInsertStatement().setNull(idx, 12);
            } else {
                this.getInsertStatement().setString(idx, entryContents.note);
            }
        }
        if (this.contextMode != null) {
            idx = 4;
            if (this.col_props != null) {
                ++idx;
            }
            if (this.hasNote) {
                ++idx;
            }
            this.contextMode.setStatementValue(this.getInsertStatement(), idx, entrySource, false);
        }
        this.registerTranslation(entryContents);
    }

    @Override
    protected void registerColumn(ResultSet set, Properties propList) throws SQLException {
        super.registerColumn(set, propList);
        if (set.getString("column_name").equalsIgnoreCase("author")) {
            this.hasAuthor = true;
        }
        if (set.getString("column_name").equalsIgnoreCase("changer")) {
            this.hasChanger = true;
        }
        if (set.getString("column_name").equalsIgnoreCase("date")) {
            this.hasDate = true;
        }
        if (set.getString("column_name").equalsIgnoreCase("changedate")) {
            this.hasChangeDate = true;
        }
    }

    public Iterable<PrepareTMXEntry> search(int numberOfResults, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, boolean andSearch, TextExpression author, long dateAfter, long dateBefore) throws Exception {
        StringBuffer sql = new StringBuffer(this.getSelectFrom() + " where (");
        if (andSearch) {
            sql.append("1=1");
        } else {
            sql.append("0=1");
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (searchSource != null) {
            sql.append(andSearch ? " and " : " or ").append(PostgresqlMemory.textExpressionSql(searchSource, "src", values));
        }
        if (searchTarget != null) {
            sql.append(andSearch ? " and " : " or ").append(PostgresqlMemory.textExpressionSql(searchTarget, "tra", values));
        }
        if (searchNotes != null) {
            sql.append(andSearch ? " and " : " or ").append(PostgresqlMemory.textExpressionSql(searchNotes, "note", values));
        }
        sql.append(")");
        if (this.hasAuthor && author != null) {
            if (this.hasChanger) {
                sql.append(" and ((").append(PostgresqlMemory.textExpressionSql(author, "author", values)).append(") or (").append(PostgresqlMemory.textExpressionSql(author, "changer", values)).append(")) ");
            } else {
                sql.append(" and (").append(PostgresqlMemory.textExpressionSql(author, "author", values)).append(") ");
            }
        }
        if (this.hasDate && dateAfter < Long.MAX_VALUE) {
            if (this.hasChangeDate) {
                sql.append(" and (changedate <= ? or (changedate is null and date <= ?))");
            } else {
                sql.append("and date <= ?");
            }
            values.add(new Date(dateAfter));
            values.add(new Date(dateAfter));
        }
        if (this.hasDate && dateBefore > Long.MIN_VALUE) {
            if (this.hasChangeDate) {
                sql.append(" and (changedate >= ? or (changedate is null and date >= ?))");
            } else {
                sql.append("and date >= ?");
            }
            values.add(new Date(dateBefore));
            values.add(new Date(dateBefore));
        }
        return this.executeSearch(sql.toString(), values);
    }

    private static String textExpressionSql(TextExpression expr, String var, List<Object> values) {
        if (expr instanceof TextExpression.NotExpression) {
            return "not (" + PostgresqlMemory.textExpressionSql(((TextExpression.NotExpression)expr).getBaseExpression(), var, values) + ")";
        }
        if (expr instanceof TextExpression.RegexTextExpression) {
            TextExpression.RegexTextExpression RE = (TextExpression.RegexTextExpression)expr;
            values.add(RE.getPattern().pattern());
            return var + ((RE.getPattern().flags() & 2) == 0 ? " ~ " : " ~* ") + "?";
        }
        if (expr instanceof TextExpression.WordsTextExpression) {
            TextExpression.WordsTextExpression RE = (TextExpression.WordsTextExpression)expr;
            StringBuffer buf = new StringBuffer();
            for (TextExpression.RegexTextExpression word : RE.split()) {
                buf.append(" or ").append(PostgresqlMemory.textExpressionSql((TextExpression)word, var, values));
            }
            return buf.toString().substring(4);
        }
        if (expr instanceof TextExpression.ExactTokenExpression) {
            TextExpression.ExactTokenExpression RE = (TextExpression.ExactTokenExpression)expr;
            values.add(RE.getOriginalExpression());
            return var + " @@ plainto_tsquery(?)";
        }
        if (expr instanceof TextExpression.WordsTokenExpression) {
            TextExpression.WordsTokenExpression RE = (TextExpression.WordsTokenExpression)expr;
            StringBuffer buf = new StringBuffer();
            for (TextExpression.ExactTokenExpression word : RE.split()) {
                buf.append(" or ").append(PostgresqlMemory.textExpressionSql((TextExpression)word, var, values));
            }
            return buf.toString().substring(4);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PrepareTMXEntry> executeSearch(String sql, List<Object> values) throws SQLException {
        this.logMessage("sql", "Select statement for search: " + sql);
        PreparedStatement searchStmt = this.connection.prepareStatement(sql);
        try {
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) instanceof String) {
                    searchStmt.setString(i + 1, values.get(i).toString());
                    continue;
                }
                if (!(values.get(i) instanceof Date)) continue;
                searchStmt.setDate(i + 1, (Date)values.get(i));
            }
            List<PrepareTMXEntry> list = this.retreiveQuery(searchStmt);
            return list;
        }
        finally {
            try {
                searchStmt.close();
            }
            catch (Exception exception) {}
        }
    }

    public Iterable<PrepareTMXEntry> getEntries() throws SQLException {
        this.logMessage("search", "Searching for all entries");
        PreparedStatement st = this.connection.prepareStatement(this.getSelectFrom());
        return this.iterateQuery(st);
    }
}

