/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.AutoHideButton;
import com.vlsolutions.swing.docking.AutoHidePolicy;
import com.vlsolutions.swing.docking.DockViewTitleBar;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingPreferences;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.animation.AnimationEvent;
import com.vlsolutions.swing.docking.animation.AnimationListener;
import com.vlsolutions.swing.docking.animation.ComponentAnimator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class AutoHideExpandPanel
extends JPanel
implements SingleDockableContainer {
    private static final long serialVersionUID = 1L;
    public static final String uiClassID = "AutoHideExpandPanelUI";
    public static final String PROPERTY_EXPANDED = "AutoHideExpanded";
    private Timer expansionTimer;
    private boolean isRolloverTimer = false;
    private boolean isExpanding = false;
    private HashMap<Component, Dimension> savedDimensions = new HashMap();
    ExpandControler controler = new ExpandControler();
    private AutoHideButton selectedButton;
    private Component expandedComponent;
    DockingDesktop desk;
    private JPanel topDragger = this.getTopDragger();
    private JPanel leftDragger = this.getLeftDragger();
    private JPanel bottomDragger = this.getBottomDragger();
    private JPanel rightDragger = this.getRightDragger();
    private JPanel lastDragger;
    private JPanel content = new JPanel(new BorderLayout());
    private Panel heavyPanel;
    private DockViewTitleBar titleBar = this.createTitleBar();
    private AnimationControler animationControler = new AnimationControler();
    private Border expandFromTopBorder;
    private Border expandFromLeftBorder;
    private Border expandFromBottomBorder;
    private Border expandFromRightBorder;
    private boolean shouldCollapse = true;
    private boolean isHeavyPanelInstalled = false;
    private long lastTimeMouseWasIn = 0L;
    private boolean canUseMouseInfo = DockingUtilities.canUseMouseInfo();
    private FocusCollapser collapser = new FocusCollapser();
    private Timer collapseTimer = new Timer(250, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Point mouseLocation = DockingUtilities.getMouseLocation();
            if (mouseLocation == null) {
                return;
            }
            Point p = new Point();
            SwingUtilities.convertPointToScreen(p, AutoHideExpandPanel.this);
            Rectangle expandPanelBounds = new Rectangle(p.x, p.y, AutoHideExpandPanel.this.getWidth(), AutoHideExpandPanel.this.getHeight());
            if (expandPanelBounds.contains(mouseLocation)) {
                AutoHideExpandPanel.this.lastTimeMouseWasIn = System.currentTimeMillis();
            } else {
                Point btnPoint = new Point();
                SwingUtilities.convertPointToScreen(btnPoint, AutoHideExpandPanel.this.selectedButton);
                Rectangle btnRect = new Rectangle(btnPoint.x, btnPoint.y, AutoHideExpandPanel.this.selectedButton.getWidth(), AutoHideExpandPanel.this.selectedButton.getHeight());
                if (btnRect.contains(mouseLocation)) {
                    AutoHideExpandPanel.this.lastTimeMouseWasIn = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - AutoHideExpandPanel.this.lastTimeMouseWasIn > 1000L && !AutoHideExpandPanel.this.isActive() && AutoHideExpandPanel.this.shouldCollapse() && AutoHideExpandPanel.this.selectedButton != null) {
                    AutoHideExpandPanel.this.collapse();
                }
            }
        }
    });

    public AutoHideExpandPanel() {
        super(new BorderLayout());
        if (!DockingPreferences.isLightWeightUsageEnabled()) {
            this.heavyPanel = new Panel(new BorderLayout());
        }
        if (AutoHidePolicy.getPolicy().getExpandMode() == AutoHidePolicy.ExpandMode.EXPAND_ON_ROLLOVER) {
            this.expansionTimer = new Timer(AutoHidePolicy.getPolicy().getRolloverTriggerDelay(), this.controler);
            this.expansionTimer.setRepeats(false);
            this.isRolloverTimer = true;
        }
        this.initBorders();
        this.setFocusCycleRoot(true);
        this.addMouseListener(new MouseAdapter(){});
        if (DockingPreferences.isLightWeightUsageEnabled()) {
            this.add((Component)this.content, "Center");
        } else if (!DockingPreferences.isSingleHeavyWeightComponent()) {
            this.heavyPanel.add((Component)this.content, "Center");
            try {
                Method m = Container.class.getMethod("setComponentZOrder", Component.class, Integer.TYPE);
                m.invoke((Object)this, this.heavyPanel, new Integer(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.add((Component)this.heavyPanel, "Center");
        } else {
            this.add((Component)this.content, "Center");
            this.add((Component)this.topDragger, "North");
            this.add((Component)this.bottomDragger, "South");
            this.add((Component)this.leftDragger, "West");
            this.add((Component)this.rightDragger, "East");
        }
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                AutoHidePolicy.getPolicy().addPropertyChangeListener(AutoHideExpandPanel.this.controler);
                if (DockingPreferences.isLightWeightUsageEnabled()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", AutoHideExpandPanel.this.collapser);
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                AutoHidePolicy.getPolicy().removePropertyChangeListener(AutoHideExpandPanel.this.controler);
                if (DockingPreferences.isLightWeightUsageEnabled()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", AutoHideExpandPanel.this.collapser);
                }
            }
        });
        this.content.add((Component)this.titleBar, "North");
    }

    private void installHeavyWeightParentIfNeeded(Dockable target) {
        if (DockingPreferences.isLightWeightUsageEnabled()) {
            return;
        }
        if (!DockingPreferences.isSingleHeavyWeightComponent()) {
            return;
        }
        if (DockingUtilities.isHeavyWeightComponent(target.getComponent())) {
            if (this.isHeavyPanelInstalled) {
                this.removeAll();
                this.add((Component)this.content, "Center");
                this.add((Component)this.topDragger, "North");
                this.add((Component)this.bottomDragger, "South");
                this.add((Component)this.leftDragger, "West");
                this.add((Component)this.rightDragger, "East");
                this.revalidate();
                this.isHeavyPanelInstalled = false;
            }
        } else if (!this.isHeavyPanelInstalled) {
            this.removeAll();
            this.add((Component)this.heavyPanel, "Center");
            this.heavyPanel.add((Component)this.content, "Center");
            this.heavyPanel.add((Component)this.topDragger, "North");
            this.heavyPanel.add((Component)this.bottomDragger, "South");
            this.heavyPanel.add((Component)this.leftDragger, "West");
            this.heavyPanel.add((Component)this.rightDragger, "East");
            this.isHeavyPanelInstalled = true;
            this.revalidate();
            try {
                Method m = Container.class.getMethod("setComponentZOrder", Component.class, Integer.TYPE);
                m.invoke((Object)this, this.heavyPanel, new Integer(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return DockingPreferences.isLightWeightUsageEnabled();
    }

    public boolean isActive() {
        if (this.titleBar.isActive()) {
            return true;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        return this.isAncestorOf(focusOwner);
    }

    public boolean shouldCollapse() {
        return this.shouldCollapse;
    }

    public JPanel getTopDragger() {
        if (this.topDragger == null) {
            this.topDragger = new JPanel();
        }
        return this.topDragger;
    }

    public JPanel getLeftDragger() {
        if (this.leftDragger == null) {
            this.leftDragger = new JPanel();
        }
        return this.leftDragger;
    }

    public JPanel getBottomDragger() {
        if (this.bottomDragger == null) {
            this.bottomDragger = new JPanel();
        }
        return this.bottomDragger;
    }

    public JPanel getRightDragger() {
        if (this.rightDragger == null) {
            this.rightDragger = new JPanel();
        }
        return this.rightDragger;
    }

    protected DockViewTitleBar createTitleBar() {
        return DockableContainerFactory.getFactory().createTitleBar();
    }

    public DockViewTitleBar getTitleBar() {
        return this.titleBar;
    }

    public void resetBorders() {
        Color shadow = UIManager.getColor("VLDocking.shadow");
        Color highlight = UIManager.getColor("VLDocking.highlight");
        if (highlight == null) {
            highlight = shadow.brighter();
        }
        this.getTopDragger().setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, shadow));
        this.getLeftDragger().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, shadow));
        this.getBottomDragger().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, shadow));
        this.getRightDragger().setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, shadow));
        this.expandFromTopBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, shadow), BorderFactory.createMatteBorder(1, 1, 1, 0, highlight)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.expandFromLeftBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, shadow), BorderFactory.createMatteBorder(1, 1, 1, 1, highlight)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.expandFromBottomBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, shadow), BorderFactory.createMatteBorder(1, 1, 1, 1, highlight)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.expandFromRightBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, shadow), BorderFactory.createMatteBorder(1, 1, 1, 1, highlight)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    protected void initBorders() {
        Dimension min = new Dimension(4, 4);
        this.topDragger.setVisible(false);
        this.topDragger.setPreferredSize(min);
        this.topDragger.setCursor(Cursor.getPredefinedCursor(8));
        DragListener topListener = new DragListener(2);
        this.topDragger.addMouseMotionListener(topListener);
        this.topDragger.addMouseListener(topListener);
        this.leftDragger.setVisible(false);
        this.leftDragger.setPreferredSize(min);
        this.leftDragger.setCursor(Cursor.getPredefinedCursor(10));
        DragListener leftListener = new DragListener(3);
        this.leftDragger.addMouseMotionListener(leftListener);
        this.leftDragger.addMouseListener(leftListener);
        this.bottomDragger.setVisible(false);
        this.bottomDragger.setPreferredSize(min);
        this.bottomDragger.setCursor(Cursor.getPredefinedCursor(9));
        DragListener bottomListener = new DragListener(0);
        this.bottomDragger.addMouseMotionListener(bottomListener);
        this.bottomDragger.addMouseListener(bottomListener);
        this.rightDragger.setVisible(false);
        this.rightDragger.setPreferredSize(min);
        this.rightDragger.setCursor(Cursor.getPredefinedCursor(11));
        DragListener rightListener = new DragListener(1);
        this.rightDragger.addMouseMotionListener(rightListener);
        this.rightDragger.addMouseListener(rightListener);
        if (DockingPreferences.isLightWeightUsageEnabled()) {
            this.add((Component)this.topDragger, "North");
            this.add((Component)this.bottomDragger, "South");
            this.add((Component)this.leftDragger, "West");
            this.add((Component)this.rightDragger, "East");
        } else if (!DockingPreferences.isSingleHeavyWeightComponent()) {
            this.heavyPanel.add((Component)this.topDragger, "North");
            this.heavyPanel.add((Component)this.bottomDragger, "South");
            this.heavyPanel.add((Component)this.leftDragger, "West");
            this.heavyPanel.add((Component)this.rightDragger, "East");
        }
    }

    private void initDockingFunctions() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("DockTitle.AUTOHIDE")) {
                    Dockable d = AutoHideExpandPanel.this.selectedButton.getDockable();
                    AutoHideExpandPanel.this.desk.setAutoHide(d, false);
                } else if (e.getPropertyName().equals("DockTitle.CLOSED")) {
                    Dockable d = AutoHideExpandPanel.this.selectedButton.getDockable();
                    AutoHideExpandPanel.this.collapse();
                    AutoHideExpandPanel.this.desk.close(d);
                } else if (e.getPropertyName().equals("DockTitle.DRAGGED")) {
                    AutoHideExpandPanel.this.collapse();
                } else if (e.getPropertyName().equals("DockTitle.FLOAT")) {
                    Dockable d = AutoHideExpandPanel.this.selectedButton.getDockable();
                    AutoHideExpandPanel.this.collapse();
                    AutoHideExpandPanel.this.desk.setFloating(d, true);
                }
            }
        };
        this.titleBar.addPropertyChangeListener("DockTitle.AUTOHIDE", listener);
        this.titleBar.addPropertyChangeListener("DockTitle.CLOSED", listener);
        this.titleBar.addPropertyChangeListener("DockTitle.DRAGGED", listener);
        this.titleBar.addPropertyChangeListener("DockTitle.FLOAT", listener);
        this.titleBar.installDocking(this.desk);
        this.desk.installDockableDragSource(this.titleBar);
    }

    ExpandControler getControler() {
        return this.controler;
    }

    public void select(AutoHideButton btn) {
        if (this.selectedButton != null && this.selectedButton != btn) {
            this.collapse();
        }
        this.selectedButton = btn;
        btn.setSelected(true);
    }

    private void restartCollapseTimer() {
        if (this.canUseMouseInfo) {
            this.lastTimeMouseWasIn = System.currentTimeMillis();
            this.collapseTimer.restart();
        }
    }

    private void stopCollapseTimer() {
        if (this.canUseMouseInfo) {
            this.collapseTimer.stop();
        }
    }

    public void expand() {
        Dimension bestDimension;
        Rectangle bounds;
        block26: {
            int model;
            block27: {
                AutoHidePolicy policy;
                block25: {
                    if (this.selectedButton == null) {
                        return;
                    }
                    this.installComponent();
                    this.restartCollapseTimer();
                    this.setVisible(true);
                    bounds = this.desk.getBounds();
                    policy = AutoHidePolicy.getPolicy();
                    model = policy.getInitialExpansionModel();
                    bestDimension = null;
                    if (model != 0) break block25;
                    bestDimension = this.savedDimensions.get(this.selectedButton);
                    if (bestDimension != null) break block26;
                    bestDimension = this.selectedButton.getDockable().getComponent().getPreferredSize();
                    switch (this.selectedButton.getZone()) {
                        case 0: 
                        case 2: {
                            if (bestDimension.height > bounds.height / 2) {
                                bestDimension.height = bounds.height / 2;
                                break;
                            }
                            break block26;
                        }
                        case 1: 
                        case 3: {
                            if (bestDimension.width <= bounds.width / 2) break block26;
                            bestDimension.width = bounds.width / 2;
                        }
                        default: {
                            break;
                        }
                        {
                            break block26;
                        }
                    }
                    break block26;
                }
                if (model != 1) break block27;
                bestDimension = new Dimension();
                switch (this.selectedButton.getZone()) {
                    case 0: 
                    case 2: {
                        bestDimension.height = policy.getInitialExpansionHeight();
                        if (bestDimension.height > bounds.height / 2) {
                            bestDimension.height = bounds.height / 2;
                            break;
                        }
                        break block26;
                    }
                    case 1: 
                    case 3: {
                        bestDimension.width = policy.getInitialExpansionWidth();
                        if (bestDimension.width <= bounds.width / 2) break block26;
                        bestDimension.width = bounds.width / 2;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block26;
            }
            throw new RuntimeException("invalid Initial Expansion model : " + model);
        }
        Insets i = this.desk.getDockingPanelInsets();
        Insets i2 = this.getComponentInsets();
        switch (this.selectedButton.getZone()) {
            case 0: {
                new ComponentAnimator(this, new Rectangle(i.left, i.top, bounds.width - i.left - i.right, 0), new Rectangle(i.left, i.top, bounds.width - i.left - i.right, bestDimension.height + i2.top + i2.bottom), (float)AutoHidePolicy.getPolicy().getExpansionDuration() / 1000.0f, this.animationControler);
                break;
            }
            case 2: {
                new ComponentAnimator(this, new Rectangle(i.left, bounds.height - i.bottom, bounds.width - i.left - i.right, 0), new Rectangle(i.left, bounds.height - bestDimension.height - i.bottom - i2.top - i2.bottom, bounds.width - i.left - i.right, bestDimension.height + i2.top + i2.bottom), (float)AutoHidePolicy.getPolicy().getExpansionDuration() / 1000.0f, this.animationControler);
                break;
            }
            case 1: {
                new ComponentAnimator(this, new Rectangle(i.left, i.top, 0, bounds.height - i.top - i.bottom), new Rectangle(i.left, i.top, bestDimension.width + i2.left + i2.right, bounds.height - i.top - i.bottom), (float)AutoHidePolicy.getPolicy().getExpansionDuration() / 1000.0f, this.animationControler);
                break;
            }
            case 3: {
                new ComponentAnimator(this, new Rectangle(bounds.width - i.right, i.top, 0, bounds.height - i.top - i.bottom), new Rectangle(bounds.width - bestDimension.width - i.right - i2.left - i2.right, i.top, bestDimension.width + i2.left + i2.right, bounds.height - i.top - i.bottom), (float)AutoHidePolicy.getPolicy().getExpansionDuration() / 1000.0f, this.animationControler);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.firePropertyChange(PROPERTY_EXPANDED, false, true);
    }

    public void remove(Dockable dockable) {
        Component comp = dockable.getComponent();
        if (this.expandedComponent != null && this.expandedComponent == comp) {
            this.content.remove(this.expandedComponent);
            this.expandedComponent = null;
        }
    }

    private void installComponent() {
        Component comp = this.selectedButton.getDockable().getComponent();
        if (this.expandedComponent != null) {
            if (this.expandedComponent != comp) {
                this.content.remove(this.expandedComponent);
                this.content.add(comp, "Center");
                this.installHeavyWeightParentIfNeeded(this.selectedButton.getDockable());
                this.expandedComponent = comp;
            }
        } else {
            this.content.add(comp, "Center");
            this.installHeavyWeightParentIfNeeded(this.selectedButton.getDockable());
            this.expandedComponent = comp;
        }
        this.titleBar.setDockable(this.selectedButton.getDockable());
        this.desk.installDockableDragSource(this.titleBar);
        switch (this.selectedButton.getZone()) {
            case 0: {
                this.content.setBorder(this.expandFromTopBorder);
                this.bottomDragger.setVisible(true);
                if (this.lastDragger != null && this.lastDragger != this.bottomDragger) {
                    this.lastDragger.setVisible(false);
                }
                this.lastDragger = this.bottomDragger;
                break;
            }
            case 2: {
                this.content.setBorder(this.expandFromBottomBorder);
                this.topDragger.setVisible(true);
                if (this.lastDragger != null && this.lastDragger != this.topDragger) {
                    this.lastDragger.setVisible(false);
                }
                this.lastDragger = this.topDragger;
                break;
            }
            case 1: {
                this.content.setBorder(this.expandFromLeftBorder);
                this.rightDragger.setVisible(true);
                if (this.lastDragger != null && this.lastDragger != this.rightDragger) {
                    this.lastDragger.setVisible(false);
                }
                this.lastDragger = this.rightDragger;
                break;
            }
            case 3: {
                this.content.setBorder(this.expandFromRightBorder);
                this.leftDragger.setVisible(true);
                if (this.lastDragger != null && this.lastDragger != this.leftDragger) {
                    this.lastDragger.setVisible(false);
                }
                this.lastDragger = this.leftDragger;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.revalidate();
        this.repaint();
    }

    private Insets getComponentInsets() {
        Insets i = this.getInsets();
        Insets i2 = this.content.getInsets();
        i.top += i2.top;
        i.left += i2.left;
        i.bottom += i2.bottom;
        i.right += i2.right;
        if (this.topDragger.isVisible()) {
            i.top += this.topDragger.getHeight();
        }
        i.top += this.titleBar.getHeight();
        if (this.leftDragger.isVisible()) {
            i.left += this.leftDragger.getWidth();
        }
        if (this.bottomDragger.isVisible()) {
            i.bottom += this.bottomDragger.getHeight();
        }
        if (this.rightDragger.isVisible()) {
            i.right += this.rightDragger.getWidth();
        }
        return i;
    }

    public void collapse() {
        if (this.selectedButton != null) {
            this.savedDimensions.put(this.selectedButton, this.selectedButton.getDockable().getComponent().getSize());
            this.selectedButton.setSelected(false);
            this.firePropertyChange(PROPERTY_EXPANDED, true, false);
        }
        this.selectedButton = null;
        this.setVisible(false);
        this.titleBar.closePopUp();
        this.stopCollapseTimer();
        if (!DockingPreferences.isLightWeightUsageEnabled()) {
            this.desk.repaint();
        }
    }

    @Override
    public void uninstallDocking(DockingDesktop desktop) {
        this.titleBar.uninstallDocking(this.desk);
    }

    @Override
    public void installDocking(DockingDesktop desktop) {
        this.desk = desktop;
        this.initDockingFunctions();
    }

    @Override
    public Dockable getDockable() {
        if (this.selectedButton != null) {
            return this.selectedButton.getDockable();
        }
        return null;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void clear() {
        this.savedDimensions.clear();
    }

    private class AnimationControler
    implements AnimationListener {
        private AnimationControler() {
        }

        @Override
        public void animation(AnimationEvent e) {
            AutoHideExpandPanel.this.isExpanding = e.getState() != 2;
            if (e.getState() == 2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoHideExpandPanel.this.content.repaint();
                    }
                });
            }
        }
    }

    private class DragListener
    implements MouseListener,
    MouseMotionListener {
        int zone;

        DragListener(int zone) {
            this.zone = zone;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), AutoHideExpandPanel.this.desk);
            Insets insets = AutoHideExpandPanel.this.getInsets();
            Insets idesk = AutoHideExpandPanel.this.desk.getDockingPanelInsets();
            switch (this.zone) {
                case 0: {
                    int newHeight = p.y - idesk.top + AutoHideExpandPanel.this.bottomDragger.getHeight() / 2 + insets.bottom + insets.top;
                    newHeight = Math.max(10, Math.min(newHeight, AutoHideExpandPanel.this.desk.getHeight()));
                    AutoHideExpandPanel.this.setSize(AutoHideExpandPanel.this.getWidth(), newHeight);
                    AutoHideExpandPanel.this.invalidate();
                    AutoHideExpandPanel.this.validate();
                    AutoHideExpandPanel.this.repaint();
                    break;
                }
                case 2: {
                    int newHeight = AutoHideExpandPanel.this.desk.getHeight() - idesk.bottom - p.y + AutoHideExpandPanel.this.topDragger.getHeight() / 2 + insets.top + insets.bottom;
                    int maxHeight = AutoHideExpandPanel.this.desk.getHeight() - AutoHideExpandPanel.this.topDragger.getHeight();
                    if (newHeight > maxHeight) {
                        newHeight = maxHeight;
                    } else if (newHeight < 10) {
                        newHeight = 10;
                    }
                    Rectangle bounds = AutoHideExpandPanel.this.getBounds();
                    bounds.y = AutoHideExpandPanel.this.desk.getHeight() - idesk.bottom - newHeight;
                    bounds.height = newHeight;
                    AutoHideExpandPanel.this.setBounds(bounds);
                    AutoHideExpandPanel.this.invalidate();
                    AutoHideExpandPanel.this.validate();
                    AutoHideExpandPanel.this.repaint();
                    break;
                }
                case 1: {
                    int newWidth = p.x + AutoHideExpandPanel.this.rightDragger.getWidth() / 2 - idesk.left + insets.right + insets.left;
                    int maxWidth = AutoHideExpandPanel.this.desk.getWidth() - AutoHideExpandPanel.this.rightDragger.getWidth();
                    if (newWidth > maxWidth) {
                        newWidth = maxWidth;
                    } else if (newWidth < 10) {
                        newWidth = 10;
                    }
                    AutoHideExpandPanel.this.setSize(newWidth, AutoHideExpandPanel.this.getHeight());
                    AutoHideExpandPanel.this.invalidate();
                    AutoHideExpandPanel.this.validate();
                    AutoHideExpandPanel.this.repaint();
                    break;
                }
                case 3: {
                    int newWidth = AutoHideExpandPanel.this.desk.getWidth() - idesk.right - p.x + AutoHideExpandPanel.this.leftDragger.getWidth() / 2 + insets.left + insets.right;
                    int maxWidth = AutoHideExpandPanel.this.desk.getWidth() - AutoHideExpandPanel.this.leftDragger.getWidth();
                    if (newWidth > maxWidth) {
                        newWidth = maxWidth;
                    } else if (newWidth < 10) {
                        newWidth = 10;
                    }
                    Rectangle bounds = AutoHideExpandPanel.this.getBounds();
                    bounds.x = AutoHideExpandPanel.this.desk.getWidth() - idesk.right - newWidth;
                    bounds.width = newWidth;
                    AutoHideExpandPanel.this.setBounds(bounds);
                    AutoHideExpandPanel.this.invalidate();
                    AutoHideExpandPanel.this.validate();
                    AutoHideExpandPanel.this.repaint();
                }
            }
            AutoHideExpandPanel.this.desk.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AutoHideExpandPanel.this.shouldCollapse = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AutoHideExpandPanel.this.shouldCollapse = true;
        }
    }

    private class ExpandControler
    implements MouseListener,
    ActionListener,
    PropertyChangeListener {
        private AutoHideButton mouseEnteredButton;
        private boolean isUnderControl = false;

        private ExpandControler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!AutoHideExpandPanel.this.isExpanding) {
                if (AutoHideExpandPanel.this.expansionTimer != null) {
                    AutoHideExpandPanel.this.expansionTimer.stop();
                }
                AutoHideButton clicked = (AutoHideButton)e.getSource();
                if (AutoHideExpandPanel.this.selectedButton != clicked) {
                    this.isUnderControl = true;
                    AutoHideExpandPanel.this.select(clicked);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoHideExpandPanel.this.expand();
                            ExpandControler.this.isUnderControl = false;
                        }
                    });
                } else {
                    AutoHideExpandPanel.this.collapse();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!AutoHideExpandPanel.this.isRolloverTimer) {
                return;
            }
            AutoHideButton btn = (AutoHideButton)e.getSource();
            if (!btn.isSelected()) {
                if (AutoHideExpandPanel.this.expansionTimer != null) {
                    AutoHideExpandPanel.this.expansionTimer.restart();
                }
                this.mouseEnteredButton = btn;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!AutoHideExpandPanel.this.isRolloverTimer) {
                return;
            }
            AutoHideButton btn = (AutoHideButton)e.getSource();
            if (!btn.isSelected()) {
                AutoHideExpandPanel.this.expansionTimer.stop();
                this.mouseEnteredButton = null;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("expandMode")) {
                if (AutoHidePolicy.getPolicy().getExpandMode() == AutoHidePolicy.ExpandMode.EXPAND_ON_ROLLOVER) {
                    AutoHideExpandPanel.this.expansionTimer = new Timer(AutoHidePolicy.getPolicy().getRolloverTriggerDelay(), this);
                    AutoHideExpandPanel.this.isRolloverTimer = true;
                } else {
                    AutoHideExpandPanel.this.expansionTimer.stop();
                    AutoHideExpandPanel.this.expansionTimer = null;
                    AutoHideExpandPanel.this.isRolloverTimer = false;
                }
            } else if (e.getPropertyName().equals("rolloverTriggerDelay") && AutoHidePolicy.getPolicy().getExpandMode() == AutoHidePolicy.ExpandMode.EXPAND_ON_ROLLOVER) {
                AutoHideExpandPanel.this.expansionTimer.setDelay(AutoHidePolicy.getPolicy().getRolloverTriggerDelay());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (this.mouseEnteredButton != null);
            this.isUnderControl = true;
            AutoHideExpandPanel.this.select(this.mouseEnteredButton);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoHideExpandPanel.this.expand();
                    ExpandControler.this.isUnderControl = false;
                }
            });
        }
    }

    private class FocusCollapser
    implements PropertyChangeListener {
        private FocusCollapser() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Component c;
            if (!AutoHideExpandPanel.this.controler.isUnderControl && (c = (Component)e.getNewValue()) != null && !AutoHideExpandPanel.this.isAncestorOf(c) && DockingUtilities.findSingleDockableContainerAncestor(c) != null) {
                AutoHideExpandPanel.this.collapse();
            }
        }
    }
}

