/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;

public class ToolBarPanelLayout
implements LayoutManager2 {
    private ToolBarPanel panel;
    private ArrayList componentInfos = new ArrayList();
    private int gap = 3;
    private int align = 3;

    public ToolBarPanelLayout(ToolBarPanel panel, int align) {
        this.panel = panel;
        this.align = align;
    }

    public ToolBarPanelLayout(ToolBarPanel panel) {
        this(panel, 3);
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    private int getAlignedX(Container target) {
        int left = 0;
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        int width = this.preferredLayoutSize((Container)target).width;
        switch (this.align) {
            case 0: {
                left += ltr ? 0 : target.getSize().width - width;
                break;
            }
            case 1: {
                left += (target.getSize().width - width) / 2;
                break;
            }
            case 2: {
                left += ltr ? target.getSize().width - width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                left += target.getSize().width - width;
            }
        }
        return left;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            throw new NullPointerException();
        }
        ToolBarConstraints tc = (ToolBarConstraints)constraints;
        this.componentInfos.add(new ComponentInfo(comp, tc));
        this.reorderComponents();
    }

    public ToolBarConstraints getConstraints(Component comp) {
        int i = 0;
        while (i < this.componentInfos.size()) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.comp == comp) {
                return ci.constraints;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        int i = 0;
        while (i < this.componentInfos.size()) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.comp == comp) {
                this.componentInfos.remove(i);
                return;
            }
            ++i;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        ToolBarPanel panel = (ToolBarPanel)parent;
        boolean isHorizontal = panel.getOrientation() == 0;
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int majorCount = this.getMajorCount();
            int i = 0;
            while (i < majorCount) {
                Dimension minorDim = new Dimension(0, 0);
                ArrayList minorList = this.getMinorComponents(i);
                int j = 0;
                while (j < minorList.size()) {
                    ComponentInfo ci = (ComponentInfo)minorList.get(j);
                    Dimension d = ci.comp.getPreferredSize();
                    if (ci.comp.isVisible()) {
                        if (isHorizontal) {
                            minorDim.width += d.width;
                            minorDim.height = Math.max(minorDim.height, d.height);
                            if (j > 0) {
                                minorDim.width += this.gap;
                            }
                        } else {
                            minorDim.width = Math.max(minorDim.width, d.width);
                            minorDim.height += d.height;
                            if (j > 0) {
                                minorDim.height += this.gap;
                            }
                        }
                    }
                    ++j;
                }
                if (isHorizontal) {
                    dim.width = Math.max(dim.width, minorDim.width);
                    dim.height += minorDim.height;
                } else {
                    dim.width += minorDim.width;
                    dim.height = Math.max(dim.height, minorDim.height);
                }
                ++i;
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public Component[] getComponents() {
        Component[] comps = new Component[this.componentInfos.size()];
        int i = 0;
        while (i < this.componentInfos.size()) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            comps[i] = ci.comp;
            ++i;
        }
        return comps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        ToolBarPanel panel = (ToolBarPanel)target;
        boolean isHorizontal = panel.getOrientation() == 0;
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        Object object = target.getTreeLock();
        synchronized (object) {
            Collections.sort(this.componentInfos);
            Insets insets = target.getInsets();
            if (isHorizontal) {
                int top = insets.top;
                int majorCount = this.getMajorCount();
                int i = 0;
                while (i < majorCount) {
                    Dimension d;
                    ComponentInfo ci;
                    int j;
                    int left = insets.left + this.getAlignedX(target);
                    int maxHeight = 0;
                    ArrayList minorList = this.getMinorComponents(i);
                    if (ltr) {
                        j = 0;
                        while (j < minorList.size()) {
                            ci = (ComponentInfo)minorList.get(j);
                            d = this.layoutHorizMinor(ci, left, top);
                            if (d != null) {
                                left += d.width + this.gap;
                                maxHeight = Math.max(maxHeight, d.height);
                            }
                            ++j;
                        }
                    } else {
                        j = minorList.size() - 1;
                        while (j >= 0) {
                            ci = (ComponentInfo)minorList.get(j);
                            d = this.layoutHorizMinor(ci, left, top);
                            if (d != null) {
                                left += d.width + this.gap;
                                maxHeight = Math.max(maxHeight, d.height);
                            }
                            --j;
                        }
                    }
                    top += maxHeight;
                    ++i;
                }
            } else {
                int majorCount = this.getMajorCount();
                int left = insets.left;
                if (ltr) {
                    int i = 0;
                    while (i < majorCount) {
                        int maxWidth = this.layoutVertMajor(insets, left, i);
                        left += maxWidth;
                        ++i;
                    }
                } else {
                    int i = majorCount - 1;
                    while (i >= 0) {
                        int maxWidth = this.layoutVertMajor(insets, left, i);
                        left += maxWidth;
                        --i;
                    }
                }
            }
        }
    }

    private Dimension layoutHorizMinor(ComponentInfo ci, int left, int top) {
        Component comp = ci.comp;
        if (comp.isVisible()) {
            Dimension d = comp.getPreferredSize();
            comp.setBounds(left, top, d.width, d.height);
            return d;
        }
        return null;
    }

    private int layoutVertMajor(Insets insets, int left, int i) {
        int top = insets.top;
        int maxWidth = 0;
        ArrayList minorList = this.getMinorComponents(i);
        int j = 0;
        while (j < minorList.size()) {
            ComponentInfo ci = (ComponentInfo)minorList.get(j);
            Component comp = ci.comp;
            if (comp.isVisible()) {
                Dimension d = comp.getPreferredSize();
                comp.setBounds(left, top, d.width, d.height);
                top += d.height + this.gap;
                maxWidth = Math.max(maxWidth, d.width);
            }
            ++j;
        }
        return maxWidth;
    }

    private void reorderComponents() {
        ComponentInfo next;
        int j;
        ComponentInfo ci;
        Collections.sort(this.componentInfos);
        int i = 0;
        while (i < this.componentInfos.size()) {
            ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.constraints.majorOffset < 0) {
                ci.constraints.majorOffset = 0;
                j = i + 1;
                while (j < this.componentInfos.size()) {
                    next = (ComponentInfo)this.componentInfos.get(j);
                    ++next.constraints.majorOrder;
                    ++j;
                }
            } else if (ci.constraints.majorOffset > 0) {
                ci.constraints.majorOffset = 0;
                j = i;
                while (j < this.componentInfos.size()) {
                    next = (ComponentInfo)this.componentInfos.get(j);
                    ++next.constraints.majorOrder;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.componentInfos.size()) {
            ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.constraints.minorOffset < 0) {
                ci.constraints.minorOffset = 0;
                j = i + 1;
                while (j < this.componentInfos.size()) {
                    next = (ComponentInfo)this.componentInfos.get(j);
                    if (next.constraints.majorOrder == ci.constraints.majorOrder) {
                        ++next.constraints.minorOrder;
                    }
                    ++j;
                }
            } else if (ci.constraints.minorOffset > 0) {
                ci.constraints.minorOffset = 0;
                j = i;
                while (j < this.componentInfos.size()) {
                    next = (ComponentInfo)this.componentInfos.get(j);
                    if (next.constraints.majorOrder == ci.constraints.majorOrder) {
                        ++next.constraints.minorOrder;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int order = 0;
        int minorOrder = 0;
        int lastMajorOrder = -1;
        int lastMinorOrder = -1;
        int i2 = 0;
        while (i2 < this.componentInfos.size()) {
            ComponentInfo ci2 = (ComponentInfo)this.componentInfos.get(i2);
            if (lastMajorOrder == -1) {
                lastMajorOrder = ci2.constraints.majorOrder;
                lastMinorOrder = ci2.constraints.minorOrder;
            }
            if (ci2.constraints.majorOrder == lastMajorOrder) {
                ci2.constraints.majorOrder = order;
                if (ci2.constraints.minorOrder == lastMinorOrder) {
                    ci2.constraints.minorOrder = minorOrder;
                } else {
                    lastMinorOrder = ci2.constraints.minorOrder;
                    ci2.constraints.minorOrder = ++minorOrder;
                }
            } else {
                minorOrder = 0;
                lastMajorOrder = ci2.constraints.majorOrder;
                lastMinorOrder = ci2.constraints.minorOrder;
                ci2.constraints.majorOrder = ++order;
                ci2.constraints.minorOrder = minorOrder;
            }
            ++i2;
        }
    }

    private ToolBarConstraints getHorizontalInsertionContraintsAt(Component draggedComponent, Point p) {
        ToolBarConstraints tc = new ToolBarConstraints();
        int majorCount = this.getMajorCount();
        int i = 0;
        while (i < majorCount) {
            Rectangle bounds = this.getMinorBounds(i);
            if (p.y < bounds.y) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = -1;
                return tc;
            }
            if (p.y < bounds.y + 5) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = -1;
                return tc;
            }
            if (p.y <= bounds.y + bounds.height) {
                ArrayList minorList;
                if (p.y > bounds.y + bounds.height - 5) {
                    tc.majorOrder = i;
                    tc.minorOrder = 0;
                    tc.majorOffset = 1;
                    return tc;
                }
                if (p.x < bounds.x + bounds.width) {
                    minorList = this.getMinorComponents(i);
                    int j = 0;
                    while (j < minorList.size()) {
                        ComponentInfo ci = (ComponentInfo)minorList.get(j);
                        Component comp = ci.comp;
                        if (comp.isVisible() && p.x < comp.getX() + comp.getWidth()) {
                            if (comp == draggedComponent) {
                                return null;
                            }
                            if (p.x < comp.getX() + 10) {
                                tc.majorOrder = i;
                                tc.minorOrder = j;
                                tc.minorOffset = -1;
                                return tc;
                            }
                            if (j < minorList.size() - 1) {
                                ComponentInfo next = (ComponentInfo)minorList.get(j + 1);
                                if (next.comp == draggedComponent) {
                                    return null;
                                }
                            }
                            tc.majorOrder = i;
                            tc.minorOrder = j;
                            tc.minorOffset = 1;
                            return tc;
                        }
                        ++j;
                    }
                } else {
                    minorList = this.getMinorComponents(i);
                    tc.majorOrder = i;
                    tc.minorOrder = minorList.size();
                    return tc;
                }
            }
            ++i;
        }
        tc.majorOrder = majorCount;
        tc.minorOrder = 0;
        return tc;
    }

    private ToolBarConstraints getVerticalInsertionContraintsAt(Component draggedComponent, Point p) {
        ToolBarConstraints tc = new ToolBarConstraints();
        int majorCount = this.getMajorCount();
        int i = 0;
        while (i < majorCount) {
            Rectangle bounds = this.getMinorBounds(i);
            if (p.x < bounds.x) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = -1;
                return tc;
            }
            if (p.x < bounds.x + 3) {
                tc.majorOrder = i;
                tc.minorOrder = 0;
                tc.majorOffset = -1;
                return tc;
            }
            if (p.x <= bounds.x + bounds.width) {
                ArrayList minorList;
                if (p.x > bounds.x + bounds.width - 3) {
                    tc.majorOrder = i;
                    tc.minorOrder = 0;
                    tc.majorOffset = 1;
                    return tc;
                }
                if (p.y < bounds.y + bounds.height) {
                    minorList = this.getMinorComponents(i);
                    int j = 0;
                    while (j < minorList.size()) {
                        ComponentInfo ci = (ComponentInfo)minorList.get(j);
                        Component comp = ci.comp;
                        if (comp.isVisible() && p.y < comp.getY() + comp.getHeight()) {
                            if (comp == draggedComponent) {
                                return null;
                            }
                            if (p.y < comp.getY() + 10) {
                                tc.majorOrder = i;
                                tc.minorOrder = j;
                                tc.minorOffset = -1;
                                return tc;
                            }
                            if (j < minorList.size() - 1) {
                                ComponentInfo next = (ComponentInfo)minorList.get(j + 1);
                                if (next.comp == draggedComponent) {
                                    return null;
                                }
                            }
                            tc.majorOrder = i;
                            tc.minorOrder = j;
                            tc.minorOffset = 1;
                            return tc;
                        }
                        ++j;
                    }
                } else {
                    minorList = this.getMinorComponents(i);
                    tc.majorOrder = i;
                    tc.minorOrder = minorList.size();
                    return tc;
                }
            }
            ++i;
        }
        tc.majorOrder = majorCount;
        tc.minorOrder = 0;
        return tc;
    }

    public ToolBarConstraints getInsertionContraintsAt(Component draggedComponent, Point p) {
        boolean isHorizontal;
        boolean bl = isHorizontal = this.panel.getOrientation() == 0;
        if (isHorizontal) {
            return this.getHorizontalInsertionContraintsAt(draggedComponent, p);
        }
        return this.getVerticalInsertionContraintsAt(draggedComponent, p);
    }

    private int getMajorCount() {
        int max = 0;
        int i = 0;
        while (i < this.componentInfos.size()) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            ToolBarConstraints tc = ci.constraints;
            if (tc.majorOrder > max) {
                max = tc.majorOrder;
            }
            ++i;
        }
        return max + 1;
    }

    private Rectangle getMinorBounds(int majorOrder) {
        Rectangle r = new Rectangle();
        Rectangle temp = null;
        int i = 0;
        while (i < this.componentInfos.size()) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.constraints.majorOrder == majorOrder) {
                temp = ci.comp.getBounds(temp);
                r = r.union(temp);
            }
            ++i;
        }
        return r;
    }

    private ArrayList getMinorComponents(int majorOrder) {
        ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
        int i = 0;
        while (i < this.componentInfos.size()) {
            ComponentInfo ci = (ComponentInfo)this.componentInfos.get(i);
            if (ci.constraints.majorOrder == majorOrder) {
                list.add(ci);
            }
            ++i;
        }
        return list;
    }

    private class ComponentInfo
    implements Comparable {
        Component comp;
        ToolBarConstraints constraints;

        ComponentInfo(Component comp, ToolBarConstraints constraints) {
            this.comp = comp;
            this.constraints = constraints;
        }

        private int getCompareOrder() {
            int order = this.constraints.majorOrder * 100000 + this.constraints.majorOffset * 10000 + this.constraints.minorOrder * 100 + this.constraints.minorOffset;
            return order;
        }

        public int compareTo(Object obj) {
            ComponentInfo ci = (ComponentInfo)obj;
            return this.getCompareOrder() - ci.getCompareOrder();
        }
    }
}

