/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.xliff;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleBindings;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.main.ToolBar;
import org.omegat.gui.scripting.IScriptLogger;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.util.StaticUtils;

public class XliffSheet
implements IPopupMenuConstructor {
    protected final EditorController ec;
    private final Transformer xsl_html;
    private final Transformer xsl_tmx;
    private final Properties config;
    private static final Pattern compPattern = Pattern.compile("\\{([\\-\\+]?\\d+)\\}");

    public XliffSheet(EditorController ec) throws Exception {
        this.ec = ec;
        this.config = new Properties();
        this.config.load(XliffSheet.findResource("config-default.properties"));
        TransformerFactory tFactory = TransformerFactory.newInstance();
        this.xsl_html = tFactory.newTransformer(new StreamSource(XliffSheet.findResource("stylesheet-default.xsl")));
        this.xsl_tmx = tFactory.newTransformer(new StreamSource(XliffSheet.findResource("stylesheet-tmx.xsl")));
        if (ToolBar.INSTANCE != null) {
            JButton btnQuit = null;
            for (int i = 0; i < ToolBar.INSTANCE.getComponentCount(); ++i) {
                try {
                    btnQuit = (JButton)ToolBar.INSTANCE.getComponent(i);
                    if (!btnQuit.getActionCommand().equals("projectExitMenuItem")) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ToolBar.INSTANCE.remove(btnQuit);
            ImageIcon icon = new ImageIcon(XliffSheet.class.getResource("/eu/europa/xliff/icon.JPG"));
            final JButton item = new JButton(icon);
            ToolBar.INSTANCE.add((Component)item);
            item.addActionListener(new ItemAction());
            item.setEnabled(Core.getProject().isProjectLoaded());
            CoreEvents.registerProjectChangeListener((IProjectEventListener)new IProjectEventListener(){

                public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                    switch (eventType) {
                        case CREATE: 
                        case LOAD: {
                            item.setEnabled(true);
                            break;
                        }
                        case CLOSE: {
                            item.setEnabled(false);
                            break;
                        }
                        case COMPILE: {
                            try {
                                XliffSheet.this.sendToOngoing();
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            ToolBar.INSTANCE.addSeparator();
            ToolBar.INSTANCE.add((Component)btnQuit);
        }
    }

    private void sendToOngoing() throws Exception {
        ScriptEngine groovy = ScriptRunner.MANAGER.getEngineByExtension("groovy");
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("project", (Object)Core.getProject());
        bindings.put("console", (Object)new IScriptLogger(){

            public void print(Object o) {
                System.err.print(o);
            }

            public void println(Object o) {
                this.print(o.toString() + "\n");
            }

            public void clear() {
            }
        });
        groovy.eval((Reader)new FileReader(System.getenv().get("OMEGAT_HOME") + File.separator + "scripts" + File.separator + "extra" + File.separator + "write_xliff_ongoing.groovy"), (Bindings)bindings);
        IProject proj = Core.getProject();
        ProjectProperties props = proj.getProjectProperties();
        for (IProject.FileInfo info : proj.getProjectFiles()) {
            String xliff = info.filePath;
            if (!info.filePath.matches(".(sdl)?xli?ff?\\z")) {
                xliff = Core.getProject().getProjectProperties().getProjectRoot() + "script_output/" + info.filePath + ".xlf";
            }
            String dest = this.config.getProperty("distantRoot") + File.separator + this.interpolation(xliff.substring((Core.getProject().getProjectProperties().getProjectRoot() + "script_output/").length()), props.getTargetLanguage().getLanguageCode().toUpperCase(), "??");
            System.err.println("Copying " + xliff + " to " + dest);
            Files.copy(new File(xliff).toPath(), new File(dest).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static InputStream findResource(String name) {
        File configFile = new File(StaticUtils.getConfigDir() + "/xliffsheet/" + name.replace("-default", ""));
        if (configFile.exists()) {
            try {
                return new FileInputStream(configFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return XliffSheet.class.getResourceAsStream("/eu/europa/xliff/" + name);
    }

    public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        if (this.xsl_html == null) {
            return;
        }
        if (ToolBar.INSTANCE != null) {
            return;
        }
        JMenuItem item = menu.add("View other target languages");
        item.addActionListener(new ItemAction());
    }

    private String interpolation(String expression, String lang, String subpart) {
        String[] components = expression.substring(0, expression.indexOf(46)).split("-");
        String path = this.config.getProperty("path");
        path = path.replace("{lang}", lang);
        if (subpart.equals("??")) {
            String pathSpec = path;
            if (path.contains(",")) {
                pathSpec = path.substring(0, path.indexOf(","));
            }
            pathSpec = pathSpec.substring(pathSpec.indexOf(File.separator) + 1);
            String[] pathComponents = pathSpec.split("-");
            for (int i = 0; i < pathComponents.length; ++i) {
                if (!pathComponents[i].equals("{subpart}")) continue;
                subpart = components[i];
            }
            if (subpart.equals("??")) {
                subpart = "00";
            }
        }
        path = path.replace("{subpart}", subpart);
        if (expression.toLowerCase().endsWith(".sdlxliff")) {
            expression = expression.substring(0, expression.lastIndexOf(46));
        }
        path = path.replace("{fileExtension}", expression.substring(expression.lastIndexOf(".") + 1));
        Matcher m = compPattern.matcher(path);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            int val = Integer.parseInt(m.group(1));
            if (val < 0) {
                val += components.length;
            }
            m.appendReplacement(s, components[val]);
        }
        m.appendTail(s);
        return s.toString();
    }

    class ItemAction
    extends AbstractAction {
        private JDialog dialog = new JDialog((Frame)((JFrame)Core.getMainWindow()), true);
        private JComboBox langBox = new JComboBox();
        private final JSpinner subpart = new JSpinner();

        ItemAction() {
            this.dialog.setLocationRelativeTo((JFrame)Core.getMainWindow());
            this.dialog.getContentPane().setLayout(new GridLayout(4, 2));
            this.dialog.getContentPane().add(new JLabel("Language:"));
            this.dialog.getContentPane().add(this.langBox);
            for (String lang : XliffSheet.this.config.getProperty("languages.order").split(",")) {
                this.langBox.addItem(lang);
            }
            this.dialog.getContentPane().add(new JLabel("Subpart:"));
            this.dialog.getContentPane().add(this.subpart);
            JButton bTM = new JButton("Import TM/penalty-50");
            this.dialog.getContentPane().add(bTM);
            JButton bOther = new JButton("Import tmx2source");
            this.dialog.getContentPane().add(bOther);
            JButton bHTML = new JButton("View HTML");
            this.dialog.getContentPane().add(bHTML);
            JButton bCancel = new JButton("Cancel");
            this.dialog.getContentPane().add(bCancel);
            bHTML.addActionListener(new TransformAction(){

                @Override
                public void doTransform(String path) throws TransformerException, IOException {
                    System.err.println("XSL: transforming " + path + " to " + path + "-ot.html");
                    XliffSheet.this.xsl_html.transform(new StreamSource(path), new StreamResult(path + "-ot.html"));
                    System.err.println("XSL: opening " + path + "-ot.html");
                    Desktop.getDesktop().open(new File(path + "-ot.html"));
                }
            });
            abstract class ImportAction
            extends TransformAction {
                ImportAction() {
                }

                public abstract String getDir(ProjectProperties var1);

                @Override
                public void doTransform(String path) throws TransformerException {
                    XliffSheet.this.xsl_tmx.setParameter("srcLang", Core.getProject().getProjectProperties().getSourceLanguage().toString());
                    XliffSheet.this.xsl_tmx.setParameter("traLang", ItemAction.this.langBox.getSelectedItem().toString());
                    String dir = this.getDir(Core.getProject().getProjectProperties());
                    XliffSheet.this.xsl_tmx.transform(new StreamSource(path), new StreamResult(dir + File.separator + ItemAction.this.langBox.getSelectedItem().toString() + ".tmp"));
                    File tmpFile = new File(dir + File.separator + ItemAction.this.langBox.getSelectedItem().toString() + ".tmp");
                    File tmxFile = new File(dir + File.separator + ItemAction.this.langBox.getSelectedItem().toString() + ".tmx");
                    if (tmxFile.exists()) {
                        tmxFile.delete();
                    }
                    tmpFile.renameTo(tmxFile);
                }
            }
            bTM.addActionListener(new ImportAction(){
                {
                }

                @Override
                public String getDir(ProjectProperties p) {
                    return p.getTMRoot() + File.separator + "penalty-50";
                }
            });
            bOther.addActionListener(new ImportAction(){
                {
                }

                @Override
                public String getDir(ProjectProperties p) {
                    return p.getTMOtherLangRoot();
                }
            });
            bCancel.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ItemAction.this.dialog.setVisible(false);
                }
            });
            this.dialog.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dialog.setVisible(true);
        }

        private String xliffFilePath() {
            String file = XliffSheet.this.ec.getCurrentFile();
            file = file.substring(file.lastIndexOf(File.separator) + 1);
            return XliffSheet.this.interpolation(file, this.langBox.getSelectedItem().toString(), String.format("%02d", Integer.parseInt(this.subpart.getValue().toString())));
        }

        private abstract class TransformAction
        extends AbstractAction {
            private final Pattern SRC_LANG_XLIFF = Pattern.compile("source-language=\\\"([a-z][a-z](\\-[A-Z][A-Z])?)\\\"");

            private TransformAction() {
            }

            protected abstract void doTransform(String var1) throws TransformerException, IOException;

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemAction.this.dialog.setVisible(false);
                String distantRoot = XliffSheet.this.config.getProperty("distantRoot");
                if (distantRoot == null || distantRoot.length() == 0 || distantRoot.trim().startsWith("#")) {
                    JOptionPane.showMessageDialog(null, "To use this feature, you must first configure it in the config/xliffsheet/config.properties file", "alert", 0);
                    return;
                }
                String[] paths = ItemAction.this.xliffFilePath().split(",");
                String path_ok = null;
                System.err.println("XSL: searching for " + ItemAction.this.xliffFilePath() + " in " + distantRoot);
                for (String path0 : paths) {
                    if (!new File(distantRoot + File.separator + path0).exists()) continue;
                    try {
                        System.err.println("Call : " + distantRoot + File.separator + path0);
                        path_ok = path0;
                        if (!this.checkSourceLang(distantRoot + File.separator + path0)) {
                            return;
                        }
                        this.doTransform(distantRoot + File.separator + path0);
                        return;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (path_ok == null) {
                    JOptionPane.showMessageDialog(null, "The file for lang " + ItemAction.this.langBox.getSelectedItem().toString() + " subpart " + ItemAction.this.subpart.getValue().toString() + " is not yet available\nFile : " + distantRoot + paths[0], "alert", 0);
                } else {
                    JOptionPane.showMessageDialog(null, "Error during conversion of " + path_ok + "\nCheck log file for details", "alert", 0);
                }
            }

            private boolean checkSourceLang(String fileName) {
                try {
                    String srcLang = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            Matcher m = this.SRC_LANG_XLIFF.matcher(line);
                            if (!m.find()) continue;
                            srcLang = m.group(1);
                            break;
                        }
                    }
                    return srcLang.equalsIgnoreCase(Core.getProject().getProjectProperties().getSourceLanguage().toString()) || JOptionPane.showConfirmDialog(null, "Warning: source language for SDLXLIFF is " + srcLang + "\nImport anyway?", "Alert", 0) != 1;
                }
                catch (Exception e) {
                    return true;
                }
            }
        }
    }
}

