/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.JTextComponent;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.util.PatternConsts;

public class PlaceholdersInsertionPopup
implements IPopupMenuConstructor {
    protected final EditorController ec;

    public PlaceholdersInsertionPopup(EditorController ec) {
        this.ec = ec;
    }

    public void addItems(JPopupMenu menu, final JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        String sourceText = this.ec.getCurrentEntry().getSrcText();
        Pattern placeholderPattern = PatternConsts.getPlaceholderPattern();
        Matcher placeholderMatch = placeholderPattern.matcher(sourceText);
        int count = 0;
        while (placeholderMatch.find()) {
            final String toAdd = placeholderMatch.group();
            if (toAdd.startsWith("</")) continue;
            JMenuItem item = new JMenuItem(toAdd);
            menu.add(item);
            if (toAdd.startsWith("<") && sourceText.contains("</" + toAdd.substring(1))) {
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String selection = PlaceholdersInsertionPopup.this.ec.getSelectedText();
                        String endTag = "</" + toAdd.substring(1);
                        if (selection != null) {
                            StringBuffer buf = new StringBuffer(selection);
                            buf.insert(0, toAdd);
                            buf.append(endTag);
                            comp.replaceSelection(buf.toString());
                        } else {
                            PlaceholdersInsertionPopup.this.ec.insertText(toAdd);
                            PlaceholdersInsertionPopup.this.ec.insertText(endTag);
                        }
                    }
                });
            } else {
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlaceholdersInsertionPopup.this.ec.insertText(toAdd);
                    }
                });
            }
            ++count;
        }
        if (count > 0) {
            menu.add(new JSeparator());
        }
    }
}

