/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.tinysegmenter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ModelExporter {
    public static void main(String[] args) throws Exception {
        try {
            Context ctx = ContextFactory.getGlobal().enterContext();
            ScriptableObject scope = ctx.initStandardObjects();
            ModelExporter.evaluateSource(ctx, (Scriptable)scope, args[0]);
            ModelExporter.evaluateSource(ctx, (Scriptable)scope, args[1]);
            ModelExporter.emit(ctx, (Scriptable)scope, args[2]);
        }
        finally {
            Context.exit();
        }
    }

    private static void evaluateSource(Context ctx, Scriptable scope, String filename) throws Exception {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            File f = new File(filename);
            fis = new FileInputStream(f);
            isr = new InputStreamReader((InputStream)fis, "utf-8");
            ctx.evaluateReader(scope, (Reader)isr, f.getName(), 1, null);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void emit(Context ctx, Scriptable scope, String filename) throws Exception {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            File f = new File(filename);
            fos = new FileOutputStream(f);
            osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
            ModelExporter.emitToWriter(ctx, scope, osw);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void emitToWriter(Context ctx, Scriptable scope, Writer w) throws Exception {
        String name;
        ModelExporter.emitPrologue(w);
        String[] names = new String[]{"BC1", "BC2", "BC3", "BP1", "BP2", "BQ1", "BQ2", "BQ3", "BQ4", "BW1", "BW2", "BW3", "TC1", "TC2", "TC3", "TC4", "TQ1", "TQ2", "TQ3", "TQ4", "TW1", "TW2", "TW3", "TW4", "UC1", "UC2", "UC3", "UC4", "UC5", "UC6", "UP1", "UP2", "UP3", "UQ1", "UQ2", "UQ3", "UW1", "UW2", "UW3", "UW4", "UW5", "UW6"};
        Function getKeys = (Function)scope.get("getKeys", scope);
        Function getValues = (Function)scope.get("getValues", scope);
        Object bias = scope.get("BIAS", scope);
        w.write("    public static final int BIAS = " + Context.toString((Object)bias) + ";\r\n");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            String keys = Context.toString((Object)getKeys.call(ctx, scope, scope, (Object[])new String[]{name}));
            String vals = Context.toString((Object)getValues.call(ctx, scope, scope, (Object[])new String[]{name}));
            w.write("    public static final String[] " + name + "_KEYS" + " = " + keys + ";\r\n");
            w.write("    public static final Integer[] " + name + "_VALS" + " = " + vals + ";\r\n");
            ++n2;
        }
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            w.write("    public static final Map<String, Integer> " + name + ";\r\n");
            ++n2;
        }
        ModelExporter.emitStaticBlock(w, names);
        ModelExporter.emitEpilogue(w);
    }

    private static void emitPrologue(Writer w) throws Exception {
        w.write("// Automatically generated. Do not edit.\r\n");
        w.write("package net.moraleboost.tinysegmenter;\r\n\r\n");
        w.write("import java.util.Collections;\r\n");
        w.write("import java.util.Map;\r\n");
        w.write("import java.util.HashMap;\r\n\r\n");
        w.write("public class TinySegmenterConstants\r\n");
        w.write("{\r\n");
    }

    private static void emitEpilogue(Writer w) throws Exception {
        w.write("}\r\n");
    }

    private static void emitStaticBlock(Writer w, String[] names) throws Exception {
        w.write("    static {\r\n");
        w.write("        int i;\r\n");
        w.write("        Map<String, Integer> m;\r\n");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            w.write("        ");
            w.write("m = new HashMap<String, Integer>();\r\n");
            w.write("        ");
            w.write("for (i=0; i<" + name + "_KEYS.length; ++i) {\r\n");
            w.write("        ");
            w.write("    m.put(" + name + "_KEYS[i], " + name + "_VALS[i]);\r\n");
            w.write("        ");
            w.write("}\r\n");
            w.write("        ");
            w.write(String.valueOf(name) + " = Collections.unmodifiableMap(m);\r\n");
            ++n2;
        }
        w.write("    }\r\n");
    }
}

