/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.segmentation.Rule;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;

public abstract class ParseEntry
implements IParseCallback {
    private final ProjectProperties m_config;
    private List<ParseEntryQueueItem> parseQueue = new ArrayList<ParseEntryQueueItem>();

    public ParseEntry(ProjectProperties m_config) {
        this.m_config = m_config;
    }

    protected void setCurrentFile(IProject.FileInfo fi) {
    }

    protected void fileFinished() {
        for (ParseEntryQueueItem item : this.parseQueue) {
            this.addSegment(item.id, item.segmentIndex, item.segmentSource, item.protectedParts, item.traInfo, item.prevSegment, item.nextSegment, item.path);
        }
        this.parseQueue.clear();
    }

    @Override
    public void linkPrevNextSegments() {
        for (int i = 0; i < this.parseQueue.size(); ++i) {
            ParseEntryQueueItem item = this.parseQueue.get(i);
            try {
                item.prevSegment = this.parseQueue.get((int)(i - 1)).segmentSource;
            }
            catch (IndexOutOfBoundsException ex) {
                item.prevSegment = "";
            }
            try {
                item.nextSegment = this.parseQueue.get((int)(i + 1)).segmentSource;
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                item.nextSegment = "";
            }
        }
    }

    @Override
    public void addEntry(String id, String path, String source, SourceTextEntry.SourceTranslationInfo traInfo, IFilter filter, List<ProtectedPart> protectedParts) {
        if (StringUtil.isEmpty(source)) {
            return;
        }
        ParseEntryResult tmp = new ParseEntryResult();
        boolean removeSpaces = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg();
        source = ParseEntry.stripSomeChars(source, tmp, this.m_config.isRemoveTags(), removeSpaces);
        source = StringUtil.normalizeUnicode(source);
        if (this.m_config.isRemoveTags() && protectedParts != null) {
            for (int i = 0; i < protectedParts.size(); ++i) {
                ProtectedPart p = protectedParts.get(i);
                String s = p.getTextInSourceSegment();
                if ((s = PatternConsts.OMEGAT_TAG.matcher(s).replaceAll("")).isEmpty()) {
                    protectedParts.remove(i);
                    --i;
                    continue;
                }
                p.setTextInSourceSegment(s);
            }
        }
        if (traInfo != null && traInfo.isTranslated()) {
            traInfo.applyToTranslation(tra -> StringUtil.normalizeUnicode(ParseEntry.stripSomeChars(tra, tmp, this.m_config.isRemoveTags(), removeSpaces)));
        }
        if (this.m_config.isSentenceSegmentingEnabled()) {
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            Language sourceLang = this.m_config.getSourceLanguage();
            List<String> segments = Core.getSegmenter().segment(sourceLang, source, spaces, brules);
            if (segments.size() == 1) {
                this.internalAddSegment(id, (short)0, segments.get(0), traInfo, path, protectedParts);
            } else if (traInfo == null) {
                for (short i = 0; i < segments.size(); i = (short)(i + 1)) {
                    String onesrc = segments.get(i);
                    List<ProtectedPart> segmentProtectedParts = ProtectedPart.extractFor(protectedParts, onesrc);
                    this.internalAddSegment(id, i, onesrc, null, path, segmentProtectedParts);
                }
            } else {
                List<SourceTextEntry.SourceTranslationInfo> cutInfo = traInfo.cut(this.m_config.getTargetLanguage());
                if (cutInfo.size() == segments.size()) {
                    for (short i = 0; i < segments.size(); i = (short)(i + 1)) {
                        String onesrc = segments.get(i);
                        List<ProtectedPart> segmentProtectedParts = ProtectedPart.extractFor(protectedParts, onesrc);
                        this.internalAddSegment(id, i, onesrc, cutInfo.get(i), path, segmentProtectedParts);
                    }
                } else {
                    traInfo.setUntranslated();
                    for (short i = 0; i < segments.size(); i = (short)(i + 1)) {
                        String onesrc = segments.get(i);
                        List<ProtectedPart> segmentProtectedParts = ProtectedPart.extractFor(protectedParts, onesrc);
                        this.internalAddSegment(id, i, onesrc, traInfo, path, segmentProtectedParts);
                    }
                }
            }
        } else {
            this.internalAddSegment(id, (short)0, source, traInfo, path, protectedParts);
        }
    }

    private void internalAddSegment(String id, short segmentIndex, String segmentSource, SourceTextEntry.SourceTranslationInfo traInfo, String path, List<ProtectedPart> protectedParts) {
        if (segmentSource.trim().isEmpty()) {
            return;
        }
        ParseEntryQueueItem item = new ParseEntryQueueItem();
        item.id = id;
        item.segmentIndex = segmentIndex;
        item.segmentSource = segmentSource;
        item.protectedParts = protectedParts;
        item.traInfo = traInfo;
        item.path = path;
        this.parseQueue.add(item);
    }

    protected abstract void addSegment(String var1, short var2, String var3, List<ProtectedPart> var4, SourceTextEntry.SourceTranslationInfo var5, String var6, String var7, String var8);

    static String stripSomeChars(String src, ParseEntryResult per, boolean removeTags, boolean removeSpaces) {
        int e;
        int b;
        String r = src;
        int len = r.length();
        if (removeSpaces) {
            int cp;
            for (b = 0; b < len && (Character.isWhitespace(cp = r.codePointAt(b)) || cp == 160); b += Character.charCount(cp)) {
            }
        }
        per.spacesAtBegin = b;
        if (removeSpaces) {
            int cp;
            for (e = len; e > b && (Character.isWhitespace(cp = r.codePointBefore(e)) || cp == 160); e -= Character.charCount(cp)) {
            }
        }
        per.spacesAtEnd = len - e;
        boolean bl = per.crlf = (r = r.substring(b, e)).indexOf("\r\n") > 0;
        if (per.crlf) {
            r = r.replace("\r\n", "\n");
        }
        boolean bl2 = per.cr = r.indexOf("\r") > 0;
        if (per.cr) {
            r = r.replace("\r", "\n");
        }
        if (removeTags) {
            r = PatternConsts.OMEGAT_TAG.matcher(r).replaceAll("");
        }
        r = StringUtil.removeXMLInvalidChars(r);
        return r;
    }

    protected static class ParseEntryQueueItem {
        String id;
        short segmentIndex;
        String segmentSource;
        List<ProtectedPart> protectedParts;
        SourceTextEntry.SourceTranslationInfo traInfo;
        String prevSegment;
        String nextSegment;
        String path;

        protected ParseEntryQueueItem() {
        }
    }

    public static class ParseEntryResult {
        public boolean crlf;
        public boolean cr;
        int spacesAtBegin;
        int spacesAtEnd;
    }
}

