/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.util.TMXProp;

public class PrepareTMXEntry
implements Serializable,
ITMXEntry {
    public String source;
    public String translation;
    public String changer;
    public long changeDate;
    public String creator;
    public long creationDate;
    public String note;
    public List<TMXProp> otherProperties;

    public PrepareTMXEntry() {
    }

    public PrepareTMXEntry(TMXEntry e) {
        this.source = e.source;
        this.translation = e.translation;
        this.changer = e.changer;
        this.changeDate = e.changeDate;
        this.creator = e.creator;
        this.creationDate = e.creationDate;
        this.note = e.note;
        if (e.revisor != null) {
            this.otherProperties = Collections.singletonList(new TMXProp("revisor", e.revisor));
        }
    }

    @Override
    public String getSourceText() {
        return this.source;
    }

    @Override
    public String getTranslationText() {
        return this.translation;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public long getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getChanger() {
        return this.changer;
    }

    @Override
    public long getChangeDate() {
        return this.changeDate;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public boolean hasProperties() {
        return this.otherProperties != null && this.otherProperties.size() > 0;
    }

    @Override
    public List<TMXProp> getProperties() {
        return this.otherProperties;
    }

    @Override
    public String getPropValue(String propType) {
        if (this.otherProperties == null) {
            return null;
        }
        for (int i = 0; i < this.otherProperties.size(); ++i) {
            TMXProp kv = this.otherProperties.get(i);
            if (!propType.equals(kv.getType())) continue;
            return kv.getValue();
        }
        return null;
    }

    @Override
    public boolean hasPropValue(String propType, String propValue) {
        if (this.otherProperties == null) {
            return false;
        }
        for (int i = 0; i < this.otherProperties.size(); ++i) {
            TMXProp kv = this.otherProperties.get(i);
            if (!propType.equals(kv.getType())) continue;
            if (propValue == null) {
                return true;
            }
            if (!propValue.equals(kv.getValue())) continue;
            return true;
        }
        return false;
    }
}

