/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.matching.external.ProjectMemory;

public class NoDelaySaver
implements ProjectMemory.IExternalProjectMemory {
    private PrintStream out;

    public NoDelaySaver(Properties propList) {
    }

    public List<ProjectMemory.ContextTMXEntry> findChanges(long timeStamp) throws Exception {
        if (this.out != null) {
            return Collections.emptyList();
        }
        ArrayList<ProjectMemory.ContextTMXEntry> res = new ArrayList<ProjectMemory.ContextTMXEntry>();
        File outFile = new File(Core.getProject().getProjectProperties().getProjectInternal() + "project_save.tmp");
        System.err.println("Using " + outFile + " for immediate save");
        if (outFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(outFile), "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] fields = line.split("\t");
                    fields[1] = fields[1].replaceAll("\\t", "\t");
                    fields[2] = fields[2].replaceAll("\\t", "\t");
                    fields[7] = fields[7].replaceAll("\\t", "\t");
                    ProjectMemory.ContextTMXEntry nEntry = new ProjectMemory.ContextTMXEntry();
                    res.add(nEntry);
                    nEntry.source = fields[1];
                    nEntry.translation = fields[2];
                    if (fields[2].equals("")) {
                        fields[2] = null;
                    }
                    nEntry.changer = fields[3];
                    nEntry.changeDate = Long.parseLong(fields[4]);
                    nEntry.creator = fields[5];
                    nEntry.creationDate = Long.parseLong(fields[6]);
                    nEntry.note = fields[7];
                    nEntry.isDefault = "true".equals(fields[8]);
                    nEntry.entryNum = Integer.parseInt(fields[9]);
                }
            }
            outFile.delete();
            Core.getProject().saveProject();
        }
        this.out = new PrintStream(outFile, "UTF-8");
        return res;
    }

    @Override
    public void registerTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        if (this.out == null) {
            return;
        }
        StringBuffer buf = new StringBuffer("+\t");
        this.entryToBuf(entry, buf);
        this.out.println(buf);
        this.out.flush();
    }

    @Override
    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        if (this.out == null) {
            return;
        }
        StringBuffer buf = new StringBuffer("-\t");
        this.entryToBuf(entry, buf);
        this.out.println(buf);
        this.out.flush();
    }

    private void entryToBuf(ProjectMemory.ContextTMXEntry entry, StringBuffer buf) {
        buf.append(entry.source.replaceAll("\t", "\\t")).append("\t");
        buf.append(entry.translation == null ? "" : entry.translation.replaceAll("\t", "\\t")).append("\t");
        buf.append(entry.changer).append("\t");
        buf.append(entry.changeDate).append("\t");
        buf.append(entry.creator).append("\t");
        buf.append(entry.creationDate).append("\t");
        buf.append(entry.note == null ? "" : entry.note.replaceAll("\t", "\\t")).append("\t");
        buf.append(entry.isDefault).append("\t");
        buf.append(entry.entryNum).append("\t");
    }
}

