/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.omegat.core.Core;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.util.Language;

public class LuceneGlossaryReader
implements IGlossary {
    private final Analyzer analyzer;
    private IndexReader indexReader;
    private IndexSearcher searcher;
    private String name;

    public LuceneGlossaryReader(Properties prop) throws IOException, InstantiationException, IllegalAccessException {
        this(new File(prop.getProperty("dir")));
    }

    public LuceneGlossaryReader(File indexDirectory) throws IOException, InstantiationException, IllegalAccessException {
        System.err.println("Reading Lucene : " + indexDirectory);
        if (!indexDirectory.isDirectory()) {
            indexDirectory = indexDirectory.getParentFile();
        }
        this.name = indexDirectory.getPath();
        this.indexReader = IndexReader.open((Directory)FSDirectory.open((File)indexDirectory));
        this.searcher = new IndexSearcher(this.indexReader);
        BaseTokenizer srcTok = (BaseTokenizer)PluginUtils.getTokenizerClassForLanguage(Core.getProject().getProjectProperties().getSourceLanguage()).newInstance();
        this.analyzer = srcTok.getGlossaryAnalyser();
    }

    public String getEngineName() {
        return "Lucene";
    }

    public String getShortName() {
        return this.name;
    }

    public String getLongName() {
        return this.name + " (Lucene)";
    }

    public boolean isExternal() {
        return false;
    }

    public boolean hasContents() {
        return true;
    }

    private BooleanQuery buildQuery(String text, BooleanClause.Occur occur) throws IOException {
        BooleanQuery query = new BooleanQuery();
        TokenStream queryTokenStream = this.analyzer.tokenStream("src", (Reader)new StringReader(text));
        TermAttribute termAtt = (TermAttribute)queryTokenStream.addAttribute(TermAttribute.class);
        queryTokenStream.reset();
        HashSet<String> terms = new HashSet<String>();
        while (queryTokenStream.incrementToken()) {
            terms.add(termAtt.term());
        }
        for (String current : terms) {
            Term t = new Term("src", current);
            query.add((Query)new TermQuery(t), occur);
        }
        queryTokenStream.end();
        queryTokenStream.close();
        BooleanQuery query1 = new BooleanQuery();
        query1.add(new BooleanClause((Query)query, BooleanClause.Occur.MUST));
        return query1;
    }

    @Override
    public List<GlossaryEntry> search(Language sLang, Language tLang, String srcText) throws Exception {
        return this.executeQuery(this.buildQuery(srcText, BooleanClause.Occur.SHOULD), 1000);
    }

    private List<GlossaryEntry> executeQuery(BooleanQuery query, int maxCount) throws IOException {
        TopDocs docs = this.searcher.search((Query)query, maxCount);
        ArrayList<GlossaryEntry> res = new ArrayList<GlossaryEntry>(docs.scoreDocs.length);
        for (int i = 0; i < res.size(); ++i) {
            res.add(this.toEntry(this.searcher.doc(docs.scoreDocs[i].doc)));
        }
        return res;
    }

    private GlossaryEntry toEntry(Document doc) {
        return new GlossaryEntry(doc.get("src"), doc.get("tra"), "", false);
    }
}

