/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.lucene.NgramAnalyzer;
import org.omegat.util.TMXProp;

public class LuceneWriter {
    private IndexWriter indexWriter;
    private NgramAnalyzer analyzer;
    private File indexDir;

    public LuceneWriter(File indexDirectory, boolean createNewTmIndex) throws IOException {
        this.indexDir = indexDirectory;
        this.analyzer = new NgramAnalyzer();
        this.indexWriter = new IndexWriter((Directory)FSDirectory.open((File)indexDirectory), (Analyzer)this.analyzer, createNewTmIndex, IndexWriter.MaxFieldLength.UNLIMITED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexAll(Collection<PrepareTMXEntry> entries) throws Exception {
        this.analyzer.calcstopNgrams(entries, this.indexDir);
        try {
            for (PrepareTMXEntry tu : entries) {
                Document doc = this.createDocument(tu);
                if (doc == null) continue;
                this.indexWriter.addDocument(doc);
            }
        }
        finally {
            try {
                this.indexWriter.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws Exception {
        this.indexWriter.close();
    }

    public Document createDocument(PrepareTMXEntry tu) {
        Document doc = new Document();
        doc.add((Fieldable)new Field("src", tu.source, Field.Store.YES, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.YES));
        if (tu.translation != null) {
            doc.add((Fieldable)new Field("tra", tu.translation, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (tu.creator != null) {
            doc.add((Fieldable)new Field("author", tu.creator, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (tu.changer != null) {
            doc.add((Fieldable)new Field("changer", tu.changer, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        for (TMXProp prop : tu.otherProperties) {
            doc.add((Fieldable)new Field("prop." + prop.getType(), prop.getValue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        return doc;
    }
}

