/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.Version;
import org.omegat.core.data.PrepareTMXEntry;

public class NgramAnalyzer
extends Analyzer {
    public Set<String> stopNgrams = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public void calcstopNgrams(Collection<PrepareTMXEntry> entries, File dest) throws IOException {
        HashMap<String, Integer> ngrams = new HashMap<String, Integer>();
        for (PrepareTMXEntry e : entries) {
            TokenStream in = this.tokenStream("", new StringReader(e.source));
            TermAttribute termAtt = (TermAttribute)in.addAttribute(TermAttribute.class);
            in.reset();
            while (in.incrementToken()) {
                String term = termAtt.term();
                if (ngrams.get(term) == null) {
                    ngrams.put(term, 1);
                    continue;
                }
                ngrams.put(term, (Integer)ngrams.get(term) + 1);
            }
            in.end();
            in.close();
        }
        this.stopNgrams = new HashSet<String>();
        for (Map.Entry me : ngrams.entrySet()) {
            if ((Integer)me.getValue() <= entries.size() / 2) continue;
            this.stopNgrams.add((String)me.getKey());
        }
        File destFile = new File(dest, "stop");
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), "UTF-8"));
            for (String text : this.stopNgrams) {
                bw.write(text);
                bw.newLine();
            }
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadstopNgrams(String filename) {
        BufferedReader br = null;
        try {
            String thisLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            this.stopNgrams = new HashSet<String>();
            while ((thisLine = br.readLine()) != null) {
                this.stopNgrams.add(thisLine);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        LowerCaseFilter stream = new LowerCaseFilter((TokenStream)new NGramTokenizer(reader, 4, 4));
        if (this.stopNgrams != null) {
            stream = new StopFilter(Version.LUCENE_31, (TokenStream)stream, this.stopNgrams);
        }
        return stream;
    }
}

