/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.search.ExternalSearchResultEntry;
import org.omegat.core.search.GlossarySearchResultEntry;
import org.omegat.core.search.ISearchable;
import org.omegat.core.search.InternalSearchResultEntry;
import org.omegat.core.search.OngoingSearchResultEntry;
import org.omegat.core.search.ProjectSearcher;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.search.SourceSearchResultEntry;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.core.search.VarMatch;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.search.ProjectSearchWindow;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.TMXProp;

public class FullProjectSearcher
extends ProjectSearcher {
    public static final int SEARCH_SCOPE_TM = 4;
    public static final int SEARCH_SCOPE_GLOSSARIES = 8;
    protected final int m_searchLocation;
    protected final boolean m_andSearch;
    protected final String m_lastSearchField;
    protected final TranslationStateFilter m_translationStateFilter;
    protected final TranslationStateFilter m_sourceTranslationStateFilter;
    protected final TextExpression m_searchSource;
    protected final TextExpression m_searchTarget;
    protected final TextExpression m_searchNotes;
    private final String m_searchFile;

    public FullProjectSearcher(ProjectSearchWindow window, IProject project, boolean removeDup, boolean trueMissing, int numberOfResults, TranslationStateFilter translationStateFilter, int searchLocation, String searchFile, TextExpression searchSource, TextExpression searchTarget, TextExpression searchNotes, String lastSearchField, boolean andSearch, boolean andThenSearch, TextExpression author, TextExpression translator, long dateAfter, long dateBefore) {
        super(window, project, removeDup, trueMissing, numberOfResults, author, translator, dateAfter, dateBefore);
        this.m_translationStateFilter = translationStateFilter;
        this.m_searchLocation = searchLocation;
        this.m_andSearch = andSearch;
        this.m_searchFile = searchFile;
        this.m_lastSearchField = lastSearchField;
        if (andThenSearch) {
            if (searchSource != null && !searchSource.hasVariables()) {
                this.m_searchSource = searchSource.asVariableKeeper();
                this.m_searchTarget = searchTarget;
                this.m_searchNotes = searchNotes;
            } else if (searchTarget != null && !searchTarget.hasVariables()) {
                this.m_searchTarget = searchTarget.asVariableKeeper();
                this.m_searchSource = searchSource;
                this.m_searchNotes = searchNotes;
            } else if (searchNotes != null && !searchNotes.hasVariables()) {
                this.m_searchNotes = searchNotes.asVariableKeeper();
                this.m_searchSource = searchSource;
                this.m_searchTarget = searchTarget;
            } else {
                this.m_searchSource = searchSource;
                this.m_searchTarget = searchTarget;
                this.m_searchNotes = searchNotes;
            }
        } else {
            this.m_searchSource = searchSource;
            this.m_searchTarget = searchTarget;
            this.m_searchNotes = searchNotes;
        }
        this.m_sourceTranslationStateFilter = (searchLocation & 1) > 0 ? TranslationStateFilter.TRANSLATED_ONLY : this.getTranslationStateFilter();
    }

    @Override
    protected void doSearch() {
        super.doSearch();
        if ((this.m_searchLocation & 4) != 0) {
            int count = this.m_project.getTransMemories().entrySet().size();
            int progress = 0;
            for (Map.Entry<String, IExternalMemory> entry : this.m_project.getTransMemories().entrySet()) {
                String fileTM = entry.getKey();
                this.m_window.displayProgress("TM:" + fileTM, progress++, count, this.m_numFinds);
                try {
                    ISearchable mem = (ISearchable)((Object)entry.getValue());
                    if (!this.searchEntries(this.searchInProvider(mem), fileTM)) {
                        return;
                    }
                }
                catch (ClassCastException mem) {
                }
                catch (Exception otherException) {
                    otherException.printStackTrace();
                }
                this.checkInterrupted();
            }
            count = this.m_project.getOtherTargetLanguageTMs().entrySet().size();
            progress = 0;
            for (Map.Entry entry : this.m_project.getOtherTargetLanguageTMs().entrySet()) {
                Language langTM = (Language)entry.getKey();
                this.m_window.displayProgress("OTHER_LANG", progress++, count, this.m_numFinds);
                if (!this.searchEntriesAlternative(((ProjectTMX)entry.getValue()).getDefaults(), langTM.getLanguage())) {
                    return;
                }
                if (!this.searchEntriesAlternative(((ProjectTMX)entry.getValue()).getAlternatives(), langTM.getLanguage())) {
                    return;
                }
                this.checkInterrupted();
            }
            this.checkInterrupted();
        }
        if ((this.m_searchLocation & 8) != 0) {
            if (this.m_author != null || this.m_dateAfter < Long.MAX_VALUE || this.m_dateBefore > Long.MIN_VALUE) {
                return;
            }
            String intro = OStrings.getString("SW_GLOSSARY_RESULT");
            List<GlossaryEntry> entries = Core.getGlossaryManager().search("");
            for (GlossaryEntry glossaryEntry : entries) {
                this.testGlossary(glossaryEntry);
                if (this.m_numFinds >= this.m_maxResults) {
                    return;
                }
                this.checkInterrupted();
            }
        }
    }

    private boolean searchEntries(Iterable<PrepareTMXEntry> tmEn, String tmxID) {
        for (PrepareTMXEntry tm : tmEn) {
            if (this.m_numFinds >= this.m_maxResults) {
                return false;
            }
            this.testTM(tmxID, tm);
            this.checkInterrupted();
        }
        return true;
    }

    private boolean searchEntriesAlternative(Iterable<TMXEntry> tmEn, String tmxID) {
        for (TMXEntry tm : tmEn) {
            if (this.m_numFinds >= this.m_maxResults) {
                return false;
            }
            this.testInternalEntry(tmxID, tm);
            this.checkInterrupted();
        }
        return true;
    }

    private void checkMatchesOrdered(TextExpression expr1, String text1, TextExpression expr2, String text2, TextExpression expr3, String text3, int id, EntryBuilder eBuilder) {
        LinkedList<SearchMatch> toRemove;
        List<SearchMatch> matchesA = (expr1 = expr1.asVariableKeeper()).searchString(text1);
        if (matchesA == null) {
            return;
        }
        LinkedList<SearchMatch> matchesB = new LinkedList<SearchMatch>();
        LinkedList<SearchMatch> matchesC = new LinkedList<SearchMatch>();
        if (expr2 != null) {
            if (text2 == null) {
                return;
            }
            toRemove = new LinkedList<SearchMatch>();
            for (SearchMatch m : matchesA) {
                List<SearchMatch> matches2 = expr2.rebuildForVariables(((VarMatch)m).groups).searchString(text2);
                if (matches2 == null) {
                    toRemove.add(m);
                    continue;
                }
                matchesB.addAll(matches2);
            }
            matchesA.removeAll(toRemove);
            toRemove.clear();
        }
        if (expr3 != null) {
            if (text3 == null) {
                return;
            }
            toRemove = new LinkedList();
            for (SearchMatch m : matchesA) {
                List<SearchMatch> matches3 = expr3.rebuildForVariables(((VarMatch)m).groups).searchString(text3);
                if (matches3 == null) {
                    toRemove.add(m);
                    continue;
                }
                matchesC.addAll(matches3);
            }
            matchesA.removeAll(toRemove);
            toRemove.clear();
        }
        if (matchesA.size() > 0) {
            switch (id) {
                case 1: {
                    this.addEntry(eBuilder.buildEntry(matchesA, matchesB, matchesC));
                    break;
                }
                case 2: {
                    this.addEntry(eBuilder.buildEntry(matchesB, matchesA, matchesC));
                    break;
                }
                case 3: {
                    this.addEntry(eBuilder.buildEntry(matchesB, matchesC, matchesA));
                }
            }
        }
    }

    protected void checkMatches(String srcText, String traText, String noteText, EntryBuilder eBuilder) {
        List<SearchMatch> srcMatches = null;
        List<SearchMatch> targetMatches = null;
        List<SearchMatch> noteMatches = null;
        if (this.m_searchSource != null && this.m_searchSource.isVariableKeeper()) {
            this.checkMatchesOrdered(this.m_searchSource, srcText, this.m_searchTarget, traText, this.m_searchNotes, noteText, 1, eBuilder);
        } else if (this.m_searchTarget != null && this.m_searchTarget.isVariableKeeper()) {
            this.checkMatchesOrdered(this.m_searchTarget, traText, this.m_searchSource, srcText, this.m_searchNotes, noteText, 2, eBuilder);
        } else if (this.m_searchNotes != null && this.m_searchNotes.isVariableKeeper()) {
            this.checkMatchesOrdered(this.m_searchNotes, noteText, this.m_searchSource, srcText, this.m_searchTarget, traText, 3, eBuilder);
        } else if (!this.m_andSearch) {
            if (this.m_searchSource != null) {
                srcMatches = this.m_searchSource.searchString(srcText);
            }
            if (this.m_searchTarget != null && traText != null) {
                targetMatches = this.m_searchTarget.searchString(traText);
            }
            if (this.m_searchNotes != null && noteText != null) {
                noteMatches = this.m_searchNotes.searchString(noteText);
            }
            if (srcMatches != null || targetMatches != null || noteMatches != null) {
                this.addEntry(eBuilder.buildEntry(srcMatches, targetMatches, noteMatches));
            }
        } else {
            if (this.m_searchSource != null && (srcMatches = this.m_searchSource.searchString(srcText)) == null) {
                return;
            }
            if (this.m_searchTarget != null && traText != null && (targetMatches = this.m_searchTarget.searchString(traText)) == null) {
                return;
            }
            if (this.m_searchNotes != null && noteText != null && (noteMatches = this.m_searchNotes.searchString(noteText)) == null) {
                return;
            }
            this.addEntry(eBuilder.buildEntry(srcMatches, targetMatches, noteMatches));
        }
    }

    @Override
    protected void testOngoing(SourceTextEntry ste) {
        TMXEntry tmxEntry = this.m_project.getTranslationInfo(ste);
        if (!this.getTranslationStateFilter().isValidEntry(tmxEntry)) {
            return;
        }
        if (!this.checkFilters(tmxEntry)) {
            return;
        }
        if (this.m_searchFile != null && this.m_searchFile.trim().length() > 0 && !ste.getKey().file.contains(this.m_searchFile)) {
            return;
        }
        String lastFieldValue = tmxEntry.note;
        if (this.m_lastSearchField.contains("PROP")) {
            lastFieldValue = lastFieldValue + "\n";
            lastFieldValue = lastFieldValue + "id: " + ste.getKey().id + "\n";
            lastFieldValue = lastFieldValue + "path: " + ste.getKey().path + "\n";
        }
        this.checkMatches(ste.getSrcText(), tmxEntry.translation, lastFieldValue, (srcMatches, targetMatches, noteMatches) -> new OngoingSearchResultEntry(ste, tmxEntry, srcMatches, targetMatches, noteMatches));
    }

    @Override
    protected boolean testSourceDocument(SourceTextEntry ste) {
        if (!this.m_sourceTranslationStateFilter.isValidEntry(ste)) {
            return false;
        }
        if (this.m_searchFile != null && this.m_searchFile.trim().length() > 0 && !ste.getKey().file.contains(this.m_searchFile)) {
            return false;
        }
        String lastFieldValue = ste.getComment();
        if (this.m_lastSearchField.contains("PROP")) {
            lastFieldValue = lastFieldValue + "\n";
            lastFieldValue = lastFieldValue + "id: " + ste.getKey().id + "\n";
            lastFieldValue = lastFieldValue + "path: " + ste.getKey().path + "\n";
        }
        if (super.testSourceDocument(ste)) {
            this.checkMatches(ste.getSrcText(), ste.getSourceTranslation(), lastFieldValue, (srcMatches, targetMatches, noteMatches) -> new SourceSearchResultEntry(ste, srcMatches, targetMatches, noteMatches));
            return true;
        }
        return false;
    }

    private void testTM(String fileName, PrepareTMXEntry entry) {
        if (!this.m_translationStateFilter.isValidEntry(entry)) {
            return;
        }
        if (this.m_searchFile != null && this.m_searchFile.trim().length() > 0 && !fileName.contains(this.m_searchFile)) {
            return;
        }
        if (!this.checkFilters(entry)) {
            return;
        }
        String lastFieldValue = entry.note;
        if (this.m_lastSearchField.contains("PROP")) {
            lastFieldValue = lastFieldValue + "\n";
            for (TMXProp prop : entry.otherProperties) {
                lastFieldValue = lastFieldValue + prop.getType() + ": " + prop.getValue() + "\n";
            }
        }
        this.checkMatches(entry.source, entry.translation, lastFieldValue, (srcMatches, targetMatches, noteMatches) -> new ExternalSearchResultEntry(fileName, entry, srcMatches, targetMatches, noteMatches));
    }

    @Override
    protected boolean testInternalEntry(String fileName, TMXEntry entry) {
        if (!this.m_translationStateFilter.isValidEntry(entry)) {
            return false;
        }
        if (!this.checkFilters(entry)) {
            return false;
        }
        this.checkMatches(entry.source, entry.translation, entry.note, (srcMatches, targetMatches, noteMatches) -> new InternalSearchResultEntry(fileName, entry, srcMatches, targetMatches, noteMatches));
        return true;
    }

    private void testGlossary(GlossaryEntry entry) {
        if (this.m_searchFile != null) {
            return;
        }
        if (!this.m_trueMissing) {
            if (this.m_author != null) {
                return;
            }
            if (this.m_dateAfter < Long.MAX_VALUE) {
                return;
            }
            if (this.m_dateBefore > Long.MIN_VALUE) {
                return;
            }
        }
        if (!this.m_translationStateFilter.isValidEntry(entry)) {
            return;
        }
        this.checkMatches(entry.getSrcText(), entry.getLocText(), entry.getCommentText(), (srcMatches, targetMatches, noteMatches) -> new GlossarySearchResultEntry(entry, srcMatches, targetMatches, noteMatches));
    }

    @Override
    public TranslationStateFilter getTranslationStateFilter() {
        return this.m_translationStateFilter;
    }

    @Override
    public boolean searchOn(int location) {
        return (location & this.m_searchLocation) > 0;
    }

    public List<SearchMatch> searchInTranslation(String text) {
        return this.m_searchTarget == null ? null : this.m_searchTarget.searchString(text);
    }

    public <T> Iterable<T> searchInProvider(ISearchable<T> provider) throws Exception {
        return provider.search(this.m_maxResults, this.m_searchSource, this.m_searchTarget, this.m_searchNotes, this.m_andSearch, this.m_author, this.m_dateAfter, this.m_dateBefore);
    }

    protected static interface EntryBuilder {
        public SearchResultEntry buildEntry(List<SearchMatch> var1, List<SearchMatch> var2, List<SearchMatch> var3);
    }
}

