/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.FullSearchResultEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.util.TMXProp;

public class OngoingSearchResultEntry
extends FullSearchResultEntry {
    private SourceTextEntry m_sourceEntry;
    private TMXEntry m_tmxEntry;

    public OngoingSearchResultEntry(SourceTextEntry sourceEntry, TMXEntry traEntry, List<SearchMatch> srcMatch, List<SearchMatch> targetMatch, List<SearchMatch> noteMatch) {
        super(srcMatch, targetMatch, noteMatch);
        this.m_tmxEntry = traEntry;
        this.m_sourceEntry = sourceEntry;
    }

    @Override
    public int getEntryNum() {
        return this.m_sourceEntry.entryNum();
    }

    @Override
    public String getPreamble() {
        return "" + this.getEntryNum() + this.getMoreString();
    }

    @Override
    public String getSrcText() {
        return this.m_sourceEntry.getSrcText();
    }

    @Override
    public String getTranslation() {
        return this.m_tmxEntry.translation == null ? "" : this.m_tmxEntry.translation;
    }

    @Override
    public String getNote() {
        return this.m_tmxEntry.note == null ? "" : this.m_tmxEntry.note;
    }

    @Override
    public String getFileName() {
        return this.m_sourceEntry.getKey().file;
    }

    @Override
    public String getAuthor() {
        return this.m_tmxEntry.creator == null ? "" : this.m_tmxEntry.creator;
    }

    @Override
    public String getRevisor() {
        return this.m_tmxEntry.revisor;
    }

    @Override
    public Date getDate() {
        return new Date(this.m_tmxEntry.creationDate);
    }

    @Override
    public List<TMXProp> getProperties() {
        return Collections.emptyList();
    }
}

