/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import org.omegat.core.Core;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.threads.LongProcessInterruptedException;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.filters2.TranslationException;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.Log;

public abstract class Searcher
extends LongProcessThread {
    protected volatile Collection<SearchResultEntry> m_searchResults;
    protected int m_numFinds;
    protected int m_maxResults;
    protected final SearchWindow m_window;
    public long startTime = System.currentTimeMillis();

    public Searcher(SearchWindow window, boolean removeDup, int maxResults) {
        this.m_window = window;
        this.m_maxResults = maxResults;
        this.m_searchResults = removeDup ? new TreeSet<SearchResultEntry>() : new ArrayList<SearchResultEntry>();
        this.m_numFinds = 0;
    }

    @Override
    public void run() {
        try {
            this.startTime = System.currentTimeMillis();
            this.doSearch();
            this.checkInterrupted();
            this.m_window.displaySearchResult(this.m_searchResults);
        }
        catch (LongProcessInterruptedException longProcessInterruptedException) {
        }
        catch (PatternSyntaxException e) {
            this.m_window.displayErrorRB(e, "ST_REGEXP_ERROR", new Object[0]);
        }
        catch (IOException e) {
            Log.logErrorRB(e, "ST_FILE_SEARCH_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(e, "ST_FILE_SEARCH_ERROR", new Object[0]);
        }
        catch (TranslationException te) {
            Log.logErrorRB(te, "ST_FILE_SEARCH_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(te, "ST_FILE_SEARCH_ERROR", new Object[0]);
        }
        catch (Exception re) {
            Log.logErrorRB(re, "ST_FATAL_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(re, "ST_FATAL_ERROR", new Object[0]);
        }
    }

    public Collection<SearchResultEntry> getSearchResults() {
        return this.m_searchResults;
    }

    protected abstract void doSearch() throws Exception;

    protected void addEntry(SearchResultEntry entry) {
        if (this.m_searchResults instanceof TreeSet) {
            for (SearchResultEntry se : this.m_searchResults) {
                if (!se.equals(entry)) continue;
                se.addMore();
                return;
            }
        }
        if (this.m_numFinds >= this.m_maxResults) {
            return;
        }
        if (this.isInterrupted()) {
            return;
        }
        this.m_searchResults.add(entry);
        ++this.m_numFinds;
    }
}

